/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.kev;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.github.jeremylong.openvulnerability.client.DataFeed;
import io.github.jeremylong.openvulnerability.client.kev.KevCatalog;
import io.github.jeremylong.openvulnerability.client.kev.KevException;
import java.io.IOException;
import java.net.ProxySelector;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class KevDataFeed
implements DataFeed<KevCatalog> {
    private static final String DEFAULT_LOCATION = "https://www.cisa.gov/sites/default/files/feeds/known_exploited_vulnerabilities.json";
    private final ObjectMapper objectMapper;
    private final String downloadUrl;

    public KevDataFeed() {
        this(DEFAULT_LOCATION);
    }

    public KevDataFeed(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JavaTimeModule());
    }

    @Override
    public KevCatalog download() {
        String json;
        HttpGet request = new HttpGet(this.downloadUrl);
        SystemDefaultRoutePlanner planner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        try (CloseableHttpClient client = HttpClientBuilder.create().setRoutePlanner((HttpRoutePlanner)planner).build();){
            json = (String)client.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
        }
        catch (IOException e) {
            throw new KevException("Unable to download the Known Exploitable Vulnerability Catalog", e);
        }
        try {
            return (KevCatalog)this.objectMapper.readValue(json, KevCatalog.class);
        }
        catch (JsonProcessingException e) {
            throw new KevException("Failed to parse JSON starting with: \"" + json.substring(0, 100) + "\"", e);
        }
    }
}

