/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.AttributeMapper;
import io.github.dmlloyd.classfile.ClassBuilder;
import io.github.dmlloyd.classfile.ClassFile;
import io.github.dmlloyd.classfile.ClassHierarchyResolver;
import io.github.dmlloyd.classfile.ClassModel;
import io.github.dmlloyd.classfile.ClassTransform;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.ConstantPoolBuilder;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.impl.AbstractPoolEntry;
import io.github.dmlloyd.classfile.impl.ClassHierarchyImpl;
import io.github.dmlloyd.classfile.impl.ClassImpl;
import io.github.dmlloyd.classfile.impl.DirectClassBuilder;
import io.github.dmlloyd.classfile.impl.SplitConstantPool;
import io.github.dmlloyd.classfile.impl.verifier.VerifierImpl;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ClassFileImpl
implements ClassFile {
    private ClassFile.Option stackMapsOption;
    private ClassFile.Option debugElementsOption;
    private ClassFile.Option lineNumbersOption;
    private ClassFile.Option attributesProcessingOption;
    private ClassFile.Option constantPoolSharingOption;
    private ClassFile.Option shortJumpsOption;
    private ClassFile.Option deadCodeOption;
    private ClassFile.Option deadLabelsOption;
    private ClassFile.Option classHierarchyResolverOption;
    private ClassFile.Option attributeMapperOption;
    public static final ClassFileImpl DEFAULT_CONTEXT = new ClassFileImpl(null, null, null, null, null, null, null, null, null, null);

    private ClassFileImpl(ClassFile.Option stackMapsOption, ClassFile.Option debugElementsOption, ClassFile.Option lineNumbersOption, ClassFile.Option attributesProcessingOption, ClassFile.Option constantPoolSharingOption, ClassFile.Option shortJumpsOption, ClassFile.Option deadCodeOption, ClassFile.Option deadLabelsOption, ClassFile.Option classHierarchyResolverOption, ClassFile.Option attributeMapperOption) {
        this.stackMapsOption = stackMapsOption;
        this.debugElementsOption = debugElementsOption;
        this.lineNumbersOption = lineNumbersOption;
        this.attributesProcessingOption = attributesProcessingOption;
        this.constantPoolSharingOption = constantPoolSharingOption;
        this.shortJumpsOption = shortJumpsOption;
        this.deadCodeOption = deadCodeOption;
        this.deadLabelsOption = deadLabelsOption;
        this.classHierarchyResolverOption = classHierarchyResolverOption;
        this.attributeMapperOption = attributeMapperOption;
    }

    @Override
    public ClassFileImpl withOptions(ClassFile.Option ... options) {
        ClassFile.Option smo = this.stackMapsOption;
        ClassFile.Option deo = this.debugElementsOption;
        ClassFile.Option lno = this.lineNumbersOption;
        ClassFile.Option apo = this.attributesProcessingOption;
        ClassFile.Option cpso = this.constantPoolSharingOption;
        ClassFile.Option sjo = this.shortJumpsOption;
        ClassFile.Option dco = this.deadCodeOption;
        ClassFile.Option dlo = this.deadLabelsOption;
        ClassFile.Option chro = this.classHierarchyResolverOption;
        ClassFile.Option amo = this.attributeMapperOption;
        for (ClassFile.Option o : options) {
            if (o instanceof ClassFile.StackMapsOption) {
                ClassFile.StackMapsOption oo = (ClassFile.StackMapsOption)o;
                smo = oo;
                continue;
            }
            if (o instanceof ClassFile.ClassHierarchyResolverOption) {
                ClassFile.ClassHierarchyResolverOption oo = (ClassFile.ClassHierarchyResolverOption)o;
                chro = oo;
                continue;
            }
            if (o instanceof ClassFile.DebugElementsOption) {
                ClassFile.DebugElementsOption oo = (ClassFile.DebugElementsOption)o;
                deo = oo;
                continue;
            }
            if (o instanceof ClassFile.LineNumbersOption) {
                ClassFile.LineNumbersOption oo = (ClassFile.LineNumbersOption)o;
                lno = oo;
                continue;
            }
            if (o instanceof ClassFile.AttributesProcessingOption) {
                ClassFile.AttributesProcessingOption oo = (ClassFile.AttributesProcessingOption)o;
                apo = oo;
                continue;
            }
            if (o instanceof ClassFile.ConstantPoolSharingOption) {
                ClassFile.ConstantPoolSharingOption oo = (ClassFile.ConstantPoolSharingOption)o;
                cpso = oo;
                continue;
            }
            if (o instanceof ClassFile.ShortJumpsOption) {
                ClassFile.ShortJumpsOption oo = (ClassFile.ShortJumpsOption)o;
                sjo = oo;
                continue;
            }
            if (o instanceof ClassFile.DeadCodeOption) {
                ClassFile.DeadCodeOption oo = (ClassFile.DeadCodeOption)o;
                dco = oo;
                continue;
            }
            if (o instanceof ClassFile.DeadLabelsOption) {
                ClassFile.DeadLabelsOption oo = (ClassFile.DeadLabelsOption)o;
                dlo = oo;
                continue;
            }
            if (o instanceof ClassFile.AttributeMapperOption) {
                ClassFile.AttributeMapperOption oo = (ClassFile.AttributeMapperOption)o;
                amo = oo;
                continue;
            }
            throw new IllegalArgumentException("Invalid option: " + String.valueOf(Objects.requireNonNull(o)));
        }
        return new ClassFileImpl(smo, deo, lno, apo, cpso, sjo, dco, dlo, chro, amo);
    }

    @Override
    public ClassModel parse(byte[] bytes) {
        return new ClassImpl(bytes, this);
    }

    @Override
    public byte[] build(ClassEntry thisClassEntry, ConstantPoolBuilder constantPool, Consumer<? super ClassBuilder> handler) {
        thisClassEntry = AbstractPoolEntry.maybeClone(constantPool, thisClassEntry);
        DirectClassBuilder builder = new DirectClassBuilder((SplitConstantPool)constantPool, this, thisClassEntry);
        handler.accept(builder);
        return builder.build();
    }

    @Override
    public byte[] transformClass(final ClassModel model, ClassEntry newClassName, final ClassTransform transform) {
        ConstantPoolBuilder constantPool = this.sharedConstantPool() ? ConstantPoolBuilder.of(model) : ConstantPoolBuilder.of();
        return this.build(newClassName, constantPool, (Consumer<? super ClassBuilder>)new Consumer<ClassBuilder>(){

            @Override
            public void accept(ClassBuilder builder) {
                ((DirectClassBuilder)builder).setOriginal((ClassImpl)model);
                ((DirectClassBuilder)builder).setSizeHint(((ClassImpl)model).classfileLength());
                builder.transform((ClassImpl)model, transform);
            }
        });
    }

    public boolean sharedConstantPool() {
        return this.constantPoolSharingOption == null || this.constantPoolSharingOption == ClassFile.ConstantPoolSharingOption.SHARED_POOL;
    }

    @Override
    public List<VerifyError> verify(ClassModel model) {
        try {
            return VerifierImpl.verify(model, this.classHierarchyResolver(), null);
        }
        catch (IllegalArgumentException verifierInitializationError) {
            return List.of(new VerifyError(verifierInitializationError.getMessage()));
        }
    }

    @Override
    public List<VerifyError> verify(byte[] bytes) {
        try {
            return this.verify(this.parse(bytes));
        }
        catch (IllegalArgumentException parsingError) {
            return List.of(new VerifyError(parsingError.getMessage()));
        }
    }

    public Function<Utf8Entry, AttributeMapper<?>> attributeMapper() {
        if (this.attributeMapperOption == null) {
            return __ -> null;
        }
        return ((ClassFile.AttributeMapperOption)this.attributeMapperOption).attributeMapper();
    }

    public ClassHierarchyResolver classHierarchyResolver() {
        if (this.classHierarchyResolverOption == null) {
            return ClassHierarchyImpl.DEFAULT_RESOLVER;
        }
        return ((ClassFile.ClassHierarchyResolverOption)this.classHierarchyResolverOption).classHierarchyResolver();
    }

    public boolean dropDeadLabels() {
        return this.deadLabelsOption != null && this.deadLabelsOption == ClassFile.DeadLabelsOption.DROP_DEAD_LABELS;
    }

    public boolean passDebugElements() {
        return this.debugElementsOption == null || this.debugElementsOption == ClassFile.DebugElementsOption.PASS_DEBUG;
    }

    public boolean passLineNumbers() {
        return this.lineNumbersOption == null || this.lineNumbersOption == ClassFile.LineNumbersOption.PASS_LINE_NUMBERS;
    }

    public ClassFile.AttributesProcessingOption attributesProcessingOption() {
        return this.attributesProcessingOption == null ? ClassFile.AttributesProcessingOption.PASS_ALL_ATTRIBUTES : (ClassFile.AttributesProcessingOption)this.attributesProcessingOption;
    }

    public boolean fixShortJumps() {
        return this.shortJumpsOption == null || this.shortJumpsOption == ClassFile.ShortJumpsOption.FIX_SHORT_JUMPS;
    }

    public boolean stackMapsWhenRequired() {
        return this.stackMapsOption == null || this.stackMapsOption == ClassFile.StackMapsOption.STACK_MAPS_WHEN_REQUIRED;
    }

    public boolean generateStackMaps() {
        return this.stackMapsOption == ClassFile.StackMapsOption.GENERATE_STACK_MAPS;
    }

    public boolean dropStackMaps() {
        return this.stackMapsOption == ClassFile.StackMapsOption.DROP_STACK_MAPS;
    }

    public boolean patchDeadCode() {
        return this.deadCodeOption == null || this.deadCodeOption == ClassFile.DeadCodeOption.PATCH_DEAD_CODE;
    }

    public record ClassHierarchyResolverOptionImpl(ClassHierarchyResolver classHierarchyResolver) implements ClassFile.ClassHierarchyResolverOption
    {
    }

    public record AttributeMapperOptionImpl(Function<Utf8Entry, AttributeMapper<?>> attributeMapper) implements ClassFile.AttributeMapperOption
    {
    }
}

