/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.openssl.jcajce;

import io.gatling.recorder.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import io.gatling.recorder.internal.bouncycastle.jcajce.util.JcaJceHelper;
import io.gatling.recorder.internal.bouncycastle.jcajce.util.NamedJcaJceHelper;
import io.gatling.recorder.internal.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import io.gatling.recorder.internal.bouncycastle.openssl.PEMDecryptor;
import io.gatling.recorder.internal.bouncycastle.openssl.PEMDecryptorProvider;
import io.gatling.recorder.internal.bouncycastle.openssl.PEMException;
import io.gatling.recorder.internal.bouncycastle.openssl.PasswordException;
import io.gatling.recorder.internal.bouncycastle.openssl.jcajce.PEMUtilities;
import java.security.Provider;

public class JcePEMDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePEMDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePEMDecryptorProviderBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public PEMDecryptorProvider build(final char[] cArray) {
        return new PEMDecryptorProvider(){

            @Override
            public PEMDecryptor get(final String string) {
                return new PEMDecryptor(){

                    @Override
                    public byte[] decrypt(byte[] byArray, byte[] byArray2) throws PEMException {
                        if (cArray == null) {
                            throw new PasswordException("Password is null, but a password is required");
                        }
                        return PEMUtilities.crypt(false, JcePEMDecryptorProviderBuilder.this.helper, byArray, cArray, string, byArray2);
                    }
                };
            }
        };
    }
}

