/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.jcajce.provider.asymmetric;

import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Encodable;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1EncodableVector;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Integer;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1OctetString;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Sequence;
import io.gatling.recorder.internal.bouncycastle.asn1.DERNull;
import io.gatling.recorder.internal.bouncycastle.asn1.DERSequence;
import io.gatling.recorder.internal.bouncycastle.asn1.bc.BCObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import io.gatling.recorder.internal.bouncycastle.asn1.sec.SECObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.gatling.recorder.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import io.gatling.recorder.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.internal.asn1.edec.EdECObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.internal.asn1.misc.MiscObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.jcajce.CompositePrivateKey;
import io.gatling.recorder.internal.bouncycastle.jcajce.CompositePublicKey;
import io.gatling.recorder.internal.bouncycastle.jcajce.provider.asymmetric.compositesignatures.CompositeSignaturesConstants;
import io.gatling.recorder.internal.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import io.gatling.recorder.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import io.gatling.recorder.internal.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import io.gatling.recorder.internal.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public class COMPOSITE {
    private static final String PREFIX = "io.gatling.recorder.internal.bouncycastle.jcajce.provider.asymmetric.COMPOSITE";
    private static final Map<String, String> compositeAttributes = new HashMap<String, String>();
    private static AsymmetricKeyInfoConverter baseConverter;

    static {
        compositeAttributes.put("SupportedKeyClasses", "io.gatling.recorder.internal.bouncycastle.jcajce.CompositePublicKey|org.bouncycastle.jcajce.CompositePrivateKey");
        compositeAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    private static class CompositeKeyInfoConverter
    implements AsymmetricKeyInfoConverter {
        private final ConfigurableProvider provider;

        public CompositeKeyInfoConverter(ConfigurableProvider configurableProvider) {
            this.provider = configurableProvider;
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(privateKeyInfo.parsePrivateKey());
            PrivateKey[] privateKeyArray = new PrivateKey[aSN1Sequence.size()];
            ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(0);
            if (aSN1Encodable instanceof ASN1OctetString) {
                CompositeSignaturesConstants.CompositeName compositeName = CompositeSignaturesConstants.ASN1IdentifierCompositeNameMap.get(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
                switch (compositeName) {
                    case MLDSA44_Ed25519_SHA512: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_44), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case MLDSA65_Ed25519_SHA512: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_65), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case MLDSA87_Ed448_SHA512: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_87), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed448), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case MLDSA44_RSA2048_PSS_SHA256: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_44), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case MLDSA65_RSA3072_PSS_SHA512: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_65), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case MLDSA44_RSA2048_PKCS15_SHA256: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_44), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case MLDSA65_RSA3072_PKCS15_SHA512: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_65), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case MLDSA44_ECDSA_P256_SHA256: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_44), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, SECObjectIdentifiers.secp256r1), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case MLDSA44_ECDSA_brainpoolP256r1_SHA256: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_44), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case MLDSA65_ECDSA_P256_SHA512: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_65), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, SECObjectIdentifiers.secp256r1), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case MLDSA65_ECDSA_brainpoolP256r1_SHA512: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_65), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, TeleTrusTObjectIdentifiers.brainpoolP256r1), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case MLDSA87_ECDSA_P384_SHA512: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_87), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, SECObjectIdentifiers.secp384r1), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case MLDSA87_ECDSA_brainpoolP384r1_SHA512: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_87), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, TeleTrusTObjectIdentifiers.brainpoolP384r1), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case Falcon512_ECDSA_P256_SHA256: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(BCObjectIdentifiers.falcon_512), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, SECObjectIdentifiers.secp256r1), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case Falcon512_ECDSA_brainpoolP256r1_SHA256: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(BCObjectIdentifiers.falcon_512), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, TeleTrusTObjectIdentifiers.brainpoolP256r1), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    case Falcon512_Ed25519_SHA512: {
                        privateKeyArray[0] = this.createPrivateKey(new AlgorithmIdentifier(BCObjectIdentifiers.falcon_512), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        privateKeyArray[1] = this.createPrivateKey(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown composite algorithm");
                    }
                }
            } else {
                for (int i = 0; i != aSN1Sequence.size(); ++i) {
                    ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(i));
                    PrivateKeyInfo privateKeyInfo2 = PrivateKeyInfo.getInstance(aSN1Sequence2);
                    privateKeyArray[i] = this.provider.getKeyInfoConverter(privateKeyInfo2.getPrivateKeyAlgorithm().getAlgorithm()).generatePrivate(privateKeyInfo2);
                }
            }
            return new CompositePrivateKey(privateKeyArray);
        }

        private PrivateKey createPrivateKey(AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString) throws IOException {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(new ASN1Integer(0L));
            aSN1EncodableVector.add(algorithmIdentifier);
            aSN1EncodableVector.add(aSN1OctetString);
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(new DERSequence(aSN1EncodableVector));
            return this.provider.getKeyInfoConverter(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()).generatePrivate(privateKeyInfo);
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            PublicKey[] publicKeyArray = new PublicKey[aSN1Sequence.size()];
            for (int i = 0; i != aSN1Sequence.size(); ++i) {
                SubjectPublicKeyInfo subjectPublicKeyInfo2 = SubjectPublicKeyInfo.getInstance(aSN1Sequence.getObjectAt(i));
                publicKeyArray[i] = this.provider.getKeyInfoConverter(subjectPublicKeyInfo2.getAlgorithm().getAlgorithm()).generatePublic(subjectPublicKeyInfo2);
            }
            return new CompositePublicKey(publicKeyArray);
        }
    }

    public static class KeyFactory
    extends BaseKeyFactorySpi {
        @Override
        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            try {
                if (key instanceof PrivateKey) {
                    return this.generatePrivate(PrivateKeyInfo.getInstance(key.getEncoded()));
                }
                if (key instanceof PublicKey) {
                    return this.generatePublic(SubjectPublicKeyInfo.getInstance(key.getEncoded()));
                }
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("key could not be parsed: " + iOException.getMessage());
            }
            throw new InvalidKeyException("key not recognized");
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            return baseConverter.generatePrivate(privateKeyInfo);
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            return baseConverter.generatePublic(subjectPublicKeyInfo);
        }
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("KeyFactory.COMPOSITE", "io.gatling.recorder.internal.bouncycastle.jcajce.provider.asymmetric.COMPOSITE$KeyFactory");
            configurableProvider.addAlgorithm("KeyFactory." + MiscObjectIdentifiers.id_alg_composite, "io.gatling.recorder.internal.bouncycastle.jcajce.provider.asymmetric.COMPOSITE$KeyFactory");
            configurableProvider.addAlgorithm("KeyFactory.OID." + MiscObjectIdentifiers.id_alg_composite, "io.gatling.recorder.internal.bouncycastle.jcajce.provider.asymmetric.COMPOSITE$KeyFactory");
            configurableProvider.addAlgorithm("KeyFactory." + MiscObjectIdentifiers.id_composite_key, "io.gatling.recorder.internal.bouncycastle.jcajce.provider.asymmetric.COMPOSITE$KeyFactory");
            configurableProvider.addAlgorithm("KeyFactory.OID." + MiscObjectIdentifiers.id_composite_key, "io.gatling.recorder.internal.bouncycastle.jcajce.provider.asymmetric.COMPOSITE$KeyFactory");
            baseConverter = new CompositeKeyInfoConverter(configurableProvider);
            configurableProvider.addKeyInfoConverter(MiscObjectIdentifiers.id_alg_composite, baseConverter);
            configurableProvider.addKeyInfoConverter(MiscObjectIdentifiers.id_composite_key, baseConverter);
        }
    }
}

