/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.response;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.validation.Failure;
import io.gatling.core.session.Session;
import io.gatling.http.auth.DigestAuth;
import io.gatling.http.auth.DigestAuthSupport$;
import io.gatling.http.cache.Http2PriorKnowledgeSupport$;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.check.HttpCheck;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.cookie.CookieSupport$;
import io.gatling.http.engine.response.CheckProcessor$;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\re!B\b\u0011\u0003CY\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001dB\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"Aq\t\u0001B\u0001B\u0003%\u0001\nC\u0003O\u0001\u0011\u0005q\nC\u0003X\u0001\u0011\u0005\u0001\fC\u0003j\u0001\u0011%!\u000eC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u0011Q\f\u0001\u0005\n\u0005}\u0003bBA4\u0001\u0019E\u0011\u0011\u000e\u0005\b\u0003_\u0002a\u0011CA9\u0005A\u0019Vm]:j_:\u0004&o\\2fgN|'O\u0003\u0002\u0012%\u0005A!/Z:q_:\u001cXM\u0003\u0002\u0014)\u00051QM\\4j]\u0016T!!\u0006\f\u0002\t!$H\u000f\u001d\u0006\u0003/a\tqaZ1uY&twMC\u0001\u001a\u0003\tIwn\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g-\u0001\u0004tS2,g\u000e\u001e\t\u0003;\u0011J!!\n\u0010\u0003\u000f\t{w\u000e\\3b]\u00069!/Z9vKN$\bC\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0015\u0003\u0019\u0019G.[3oi&\u0011A&\u000b\u0002\b%\u0016\fX/Z:u\u0003\u0019\u0019\u0007.Z2lgB\u0019qf\u000e\u001e\u000f\u0005A*dBA\u00195\u001b\u0005\u0011$BA\u001a\u001b\u0003\u0019a$o\\8u}%\tq$\u0003\u00027=\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001d:\u0005\u0011a\u0015n\u001d;\u000b\u0005Yr\u0002CA\u001e?\u001b\u0005a$BA\u001f\u0015\u0003\u0015\u0019\u0007.Z2l\u0013\tyDHA\u0005IiR\u00048\t[3dW\u0006Q\u0001\u000e\u001e;q\u0007\u0006\u001c\u0007.Z:\u0011\u0005\t+U\"A\"\u000b\u0005\u0011#\u0012!B2bG\",\u0017B\u0001$D\u0005)AE\u000f\u001e9DC\u000eDWm]\u0001\rQR$\b\u000f\u0015:pi>\u001cw\u000e\u001c\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017R\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003\u001b*\u0013A\u0002\u0013;uaB\u0013x\u000e^8d_2\fa\u0001P5oSRtDC\u0002)S'R+f\u000b\u0005\u0002R\u00015\t\u0001\u0003C\u0003#\r\u0001\u00071\u0005C\u0003'\r\u0001\u0007q\u0005C\u0003.\r\u0001\u0007a\u0006C\u0003A\r\u0001\u0007\u0011\tC\u0003H\r\u0001\u0007\u0001*\u0001\u000bva\u0012\fG/Z*fgNLwN\\\"sCNDW\r\u001a\u000b\u00053\u0006\u0014w\r\u0005\u0002[?6\t1L\u0003\u0002];\u000691/Z:tS>t'B\u00010\u0017\u0003\u0011\u0019wN]3\n\u0005\u0001\\&aB*fgNLwN\u001c\u0005\u00069\u001e\u0001\r!\u0017\u0005\u0006G\u001e\u0001\r\u0001Z\u0001\u000fgR\f'\u000f\u001e+j[\u0016\u001cH/Y7q!\tiR-\u0003\u0002g=\t!Aj\u001c8h\u0011\u0015Aw\u00011\u0001e\u00031)g\u000e\u001a+j[\u0016\u001cH/Y7q\u0003I)\b\u000fZ1uKN+7o]5p]N#\u0018\r^:\u0015\u000be[G.\u001c8\t\u000bqC\u0001\u0019A-\t\u000b\rD\u0001\u0019\u00013\t\u000b!D\u0001\u0019\u00013\t\u000b=D\u0001\u0019\u00019\u0002\rM$\u0018\r^;t!\t\th/D\u0001s\u0015\t\u0019H/A\u0003ti\u0006$8O\u0003\u0002v-\u000591m\\7n_:\u001c\u0018BA<s\u0005\u0019\u0019F/\u0019;vg\u0006qQ\u000f\u001d3bi\u0016$7+Z:tS>tG#\u0002>\u0002\u0012\u0005M\u0001\u0003B\u000f|3vL!\u0001 \u0010\u0003\rQ+\b\u000f\\33!\u0011ib0!\u0001\n\u0005}t\"AB(qi&|g\u000e\u0005\u0003\u0002\u0004\u0005-a\u0002BA\u0003\u0003\u000f\u0001\"!\r\u0010\n\u0007\u0005%a$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\tyA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013q\u0002\"\u0002/\n\u0001\u0004I\u0006BB\t\n\u0001\u0004\t)\u0002\u0005\u0003\u0002\u0018\u0005mQBAA\r\u0015\t\tB#\u0003\u0003\u0002\u001e\u0005e!\u0001\u0003*fgB|gn]3\u0002-U\u0004H-\u0019;fIJ+G-\u001b:fGR\u001cVm]:j_:$r!WA\u0012\u0003K\t9\u0003C\u0003]\u0015\u0001\u0007\u0011\f\u0003\u0004\u0012\u0015\u0001\u0007\u0011Q\u0003\u0005\b\u0003SQ\u0001\u0019AA\u0016\u0003-\u0011X\rZ5sK\u000e$XK]5\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\r*\u0003\r)(/[\u0005\u0005\u0003k\tyCA\u0002Ve&\fQ$\u001e9eCR,G\rR5hKN$8\t[1mY\u0016tw-Z*fgNLwN\u001c\u000b\b3\u0006m\u0012QHA \u0011\u0015a6\u00021\u0001Z\u0011\u0019\t2\u00021\u0001\u0002\u0016!9\u0011\u0011I\u0006A\u0002\u0005\r\u0013AC2iC2dWM\\4fgB)q&!\u0012\u0002J%\u0019\u0011qI\u001d\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002L\u0005]c\u0002BA'\u0003'j!!a\u0014\u000b\u0007\u0005EC#\u0001\u0003bkRD\u0017\u0002BA+\u0003\u001f\n!\u0002R5hKN$\u0018)\u001e;i\u0013\u0011\tI&a\u0017\u0003\u0013\rC\u0017\r\u001c7f]\u001e,'\u0002BA+\u0003\u001f\nQbY1dQ\u0016\u0014V\rZ5sK\u000e$HcB-\u0002b\u0005\r\u0014Q\r\u0005\u000692\u0001\r!\u0017\u0005\u0007#1\u0001\r!!\u0006\t\u000f\u0005%B\u00021\u0001\u0002,\u0005iQ\u000f\u001d3bi\u0016\u0014VMZ3sKJ$R!WA6\u0003[BQ\u0001X\u0007A\u0002eCa!E\u0007A\u0002\u0005U\u0011!G;qI\u0006$Xm\u0012:pkB\u0014V-];fgR$\u0016.\\5oON$r!WA:\u0003k\n9\bC\u0003]\u001d\u0001\u0007\u0011\fC\u0003d\u001d\u0001\u0007A\rC\u0003i\u001d\u0001\u0007A-K\u0003\u0001\u0003w\ny(C\u0002\u0002~A\u0011\u0001DU3t_V\u00148-Z*fgNLwN\u001c)s_\u000e,7o]8s\u0013\r\t\t\t\u0005\u0002\u0015%>|GoU3tg&|g\u000e\u0015:pG\u0016\u001c8o\u001c:")
public abstract class SessionProcessor {
    private final boolean silent;
    private final Request request;
    private final List<HttpCheck> checks;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;

    public Session updateSessionCrashed(Session session, long startTimestamp, long endTimestamp) {
        return this.updateSessionStats(session, startTimestamp, endTimestamp, (Status)KO$.MODULE$);
    }

    private Session updateSessionStats(Session session, long startTimestamp, long endTimestamp, Status status) {
        Session session2;
        if (this.silent) {
            session2 = session;
        } else {
            Status status2 = status;
            KO$ kO$ = KO$.MODULE$;
            Session sessionWithUpdatedStatus = !(status2 != null ? !status2.equals(kO$) : kO$ != null) ? session.markAsFailed() : session;
            session2 = this.updateGroupRequestTimings(sessionWithUpdatedStatus, startTimestamp, endTimestamp);
        }
        return session2;
    }

    public Tuple2<Session, Option<String>> updatedSession(Session session, Response response) {
        Tuple2<Session, Option<Failure>> tuple2 = CheckProcessor$.MODULE$.check(session, response, this.checks);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Session sessionWithCheckSavedValues = (Session)tuple2._1();
        Option checkError = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sessionWithCheckSavedValues, (Object)checkError);
        Tuple2 tuple23 = tuple22;
        Session sessionWithCheckSavedValues2 = (Session)tuple23._1();
        Option checkError2 = (Option)tuple23._2();
        Session sessionWithHttp2PriorKnowledge = this.httpProtocol.enginePart().enableHttp2() ? Http2PriorKnowledgeSupport$.MODULE$.updateSessionHttp2PriorKnowledge(sessionWithCheckSavedValues2, response) : sessionWithCheckSavedValues2;
        KO$ newStatus = checkError2.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
        Session newSession = this.updateSessionAfterChecks$1(sessionWithHttp2PriorKnowledge, (Status)newStatus, response);
        return new Tuple2((Object)newSession, (Object)checkError2.map((Function1 & Serializable)x$2 -> x$2.message()));
    }

    public Session updatedRedirectSession(Session session, Response response, Uri redirectUri) {
        Session sessionWithCookieStoreUpdate = CookieSupport$.MODULE$.storeCookies(session, this.request.getUri(), response.cookies(), response.endTimestamp());
        Session sessionWithGroupUpdate = this.updateSessionStats(sessionWithCookieStoreUpdate, response.startTimestamp(), response.endTimestamp(), (Status)OK$.MODULE$);
        return this.cacheRedirect(sessionWithGroupUpdate, response, redirectUri);
    }

    public Session updatedDigestChallengeSession(Session session, Response response, Seq<DigestAuth.Challenge> challenges) {
        Session sessionWithCookieStoreUpdate = CookieSupport$.MODULE$.storeCookies(session, this.request.getUri(), response.cookies(), response.endTimestamp());
        Session sessionWihUpdatedStore = DigestAuthSupport$.MODULE$.storeChallenges(sessionWithCookieStoreUpdate, challenges);
        return this.updateSessionStats(sessionWihUpdatedStore, response.startTimestamp(), response.endTimestamp(), (Status)OK$.MODULE$);
    }

    private Session cacheRedirect(Session session, Response response, Uri redirectUri) {
        return this.httpProtocol.requestPart().cache() && HttpHelper$.MODULE$.isPermanentRedirect(response.status()) ? this.httpCaches.addRedirect(session, this.request, redirectUri) : session;
    }

    public abstract Session updateReferer(Session var1, Response var2);

    public abstract Session updateGroupRequestTimings(Session var1, long var2, long var4);

    private final Session updateSessionAfterChecks$1(Session s1, Status status, Response response$1) {
        Session s2 = CookieSupport$.MODULE$.storeCookies(s1, this.request.getUri(), response$1.cookies(), response$1.endTimestamp());
        Session s3 = this.updateReferer(s2, response$1);
        Session s4 = this.httpCaches.cacheContent(s3, this.httpProtocol, this.request, response$1.headers());
        return this.updateSessionStats(s4, response$1.startTimestamp(), response$1.endTimestamp(), status);
    }

    public SessionProcessor(boolean silent, Request request, List<HttpCheck> checks, HttpCaches httpCaches, HttpProtocol httpProtocol) {
        this.silent = silent;
        this.request = request;
        this.checks = checks;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
    }
}

