/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.ws.fsm;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.Status;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.action.ws.fsm.NextWsState;
import io.gatling.http.action.ws.fsm.SendBinaryFrame;
import io.gatling.http.action.ws.fsm.SendFrame;
import io.gatling.http.action.ws.fsm.SendTextFrame;
import io.gatling.http.action.ws.fsm.WsClosedState;
import io.gatling.http.action.ws.fsm.WsConnectingState$;
import io.gatling.http.action.ws.fsm.WsFsm;
import io.gatling.http.action.ws.fsm.WsState;
import io.gatling.http.check.ws.WsFrameCheck;
import io.gatling.http.check.ws.WsFrameCheckSequence;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import java.io.Serializable;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001\u0002\u0006\f\u0005aA\u0001\u0002\u0004\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u0015A\u0005\u0001\"\u0011J\u0011\u0015q\u0007\u0001\"\u0011p\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!a\f\u0001\t\u0013\t\tD\u0001\bXg\u000e\u0013\u0018m\u001d5fIN#\u0018\r^3\u000b\u00051i\u0011a\u00014t[*\u0011abD\u0001\u0003oNT!\u0001E\t\u0002\r\u0005\u001cG/[8o\u0015\t\u00112#\u0001\u0003iiR\u0004(B\u0001\u000b\u0016\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011AF\u0001\u0003S>\u001c\u0001aE\u0002\u00013u\u0001\"AG\u000e\u000e\u0003-I!\u0001H\u0006\u0003\u000f]\u001b8\u000b^1uKB\u0011a$J\u0007\u0002?)\u0011\u0001%I\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003E\r\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002I\u0005\u00191m\\7\n\u0005\u0019z\"!D*ue&\u001cG\u000fT8hO&tw\r\u0005\u0002\u001bQ%\u0011\u0011f\u0003\u0002\u0006/N45/\\\u0001\rKJ\u0014xN]'fgN\fw-\u001a\t\u0004Y=\nT\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\r=\u0003H/[8o!\t\u0011\u0014H\u0004\u00024oA\u0011A'L\u0007\u0002k)\u0011agF\u0001\u0007yI|w\u000e\u001e \n\u0005aj\u0013A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u0017\u0002'I,W.Y5oS:<'+Z2p]:,7\r^:\u0016\u0003y\u0002\"\u0001L \n\u0005\u0001k#aA%oi\u0006!\"/Z7bS:Lgn\u001a*fG>tg.Z2ug\u0002\na\u0001P5oSRtD\u0003\u0002#F\r\u001e\u0003\"A\u0007\u0001\t\u000b1)\u0001\u0019A\u0014\t\u000b)*\u0001\u0019A\u0016\t\u000bq*\u0001\u0019\u0001 \u0002)=t7\t\\5f]R\u001cEn\\:f%\u0016\fX/Z:u)\u0015QUj\u00140h!\tQ2*\u0003\u0002M\u0017\tYa*\u001a=u/N\u001cF/\u0019;f\u0011\u0015qe\u00011\u00012\u0003)\t7\r^5p]:\u000bW.\u001a\u0005\u0006!\u001a\u0001\r!U\u0001\fG2|7/Z*uCR,8\u000f\u0005\u0002S96\t1K\u0003\u0002U+\u0006Qq/\u001a2t_\u000e\\W\r\u001e=\u000b\u0005I1&BA,Y\u0003\u0015\u0019w\u000eZ3d\u0015\tI&,A\u0004iC:$G.\u001a:\u000b\u0005m+\u0012!\u00028fiRL\u0018BA/T\u0005Q9VMY*pG.,Go\u00117pg\u0016\u001cF/\u0019;vg\")qL\u0002a\u0001A\u000691/Z:tS>t\u0007CA1f\u001b\u0005\u0011'BA0d\u0015\t!7#\u0001\u0003d_J,\u0017B\u00014c\u0005\u001d\u0019Vm]:j_:DQ\u0001\u001b\u0004A\u0002%\fAA\\3yiB\u0011!\u000e\\\u0007\u0002W*\u0011\u0001cY\u0005\u0003[.\u0014a!Q2uS>t\u0017aD8o'\u0016tG\rV3yi\u001a\u0013\u0018-\\3\u0015\u0011)\u0003\u0018o]A\t\u0003'AQAT\u0004A\u0002EBQA]\u0004A\u0002E\nq!\\3tg\u0006<W\rC\u0003u\u000f\u0001\u0007Q/\u0001\bdQ\u0016\u001c7nU3rk\u0016t7-Z:\u0011\u0007Y\\hP\u0004\u0002xs:\u0011A\u0007_\u0005\u0002]%\u0011!0L\u0001\ba\u0006\u001c7.Y4f\u0013\taXP\u0001\u0003MSN$(B\u0001>.!\u0015y\u0018qAA\u0006\u001b\t\t\tAC\u0002\u000f\u0003\u0007Q1!!\u0002\u0012\u0003\u0015\u0019\u0007.Z2l\u0013\u0011\tI!!\u0001\u0003)]\u001bhI]1nK\u000eCWmY6TKF,XM\\2f!\ry\u0018QB\u0005\u0005\u0003\u001f\t\tA\u0001\u0007Xg\u001a\u0013\u0018-\\3DQ\u0016\u001c7\u000eC\u0003`\u000f\u0001\u0007\u0001\rC\u0003i\u000f\u0001\u0007\u0011.A\tp]N+g\u000e\u001a\"j]\u0006\u0014\u0018P\u0012:b[\u0016$2BSA\r\u00037\tI#a\u000b\u0002.!)a\n\u0003a\u0001c!1!\u000f\u0003a\u0001\u0003;\u0001R\u0001LA\u0010\u0003GI1!!\t.\u0005\u0015\t%O]1z!\ra\u0013QE\u0005\u0004\u0003Oi#\u0001\u0002\"zi\u0016DQ\u0001\u001e\u0005A\u0002UDQa\u0018\u0005A\u0002\u0001DQ\u0001\u001b\u0005A\u0002%\fa\u0003[1oI2,7+\u001a8e\rJ\fW.\u001a$bS2,(/\u001a\u000b\f\u0015\u0006M\u0012QGA\u001c\u0003s\t\u0019\u0005C\u0003O\u0013\u0001\u0007\u0011\u0007C\u0003`\u0013\u0001\u0007\u0001\rC\u0003i\u0013\u0001\u0007\u0011\u000eC\u0004\u0002<%\u0001\r!!\u0010\u0002)\u00054G/\u001a:SK\u000e|gN\\3di\u0006\u001bG/[8o!\rQ\u0012qH\u0005\u0004\u0003\u0003Z!!C*f]\u00124%/Y7f\u0011\u0019\t)%\u0003a\u0001c\u0005IaM]1nKRK\b/\u001a")
public final class WsCrashedState
extends WsState {
    private final WsFsm fsm;
    private final Option<String> errorMessage;
    private final int remainingReconnects;

    @Override
    public int remainingReconnects() {
        return this.remainingReconnects;
    }

    @Override
    public NextWsState onClientCloseRequest(String actionName, WebSocketCloseStatus closeStatus, Session session, Action next) {
        Session session2;
        Option<String> option = this.errorMessage;
        if (option instanceof Some) {
            Some some = (Some)option;
            String mess = (String)some.value();
            Session newSession = session.markAsFailed();
            this.fsm.statsEngine().logCrash(session.scenario(), session.groups(), actionName, new StringBuilder(61).append("Client issued close order but WebSocket was already crashed: ").append(mess).toString());
            session2 = newSession;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Client issued close order but WebSocket was already closed");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            session2 = session;
        }
        Session newSession = session2.remove(this.fsm.wsName());
        return new NextWsState(new WsClosedState(this.fsm), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> next.$bang(newSession));
    }

    @Override
    public NextWsState onSendTextFrame(String actionName, String message, List<WsFrameCheckSequence<WsFrameCheck>> checkSequences, Session session, Action next) {
        return this.handleSendFrameFailure(actionName, session, next, new SendTextFrame(actionName, message, checkSequences, next), "text");
    }

    @Override
    public NextWsState onSendBinaryFrame(String actionName, byte[] message, List<WsFrameCheckSequence<WsFrameCheck>> checkSequences, Session session, Action next) {
        return this.handleSendFrameFailure(actionName, session, next, new SendBinaryFrame(actionName, message, checkSequences, next), "binary");
    }

    private NextWsState handleSendFrameFailure(String actionName, Session session, Action next, SendFrame afterReconnectAction, String frameType) {
        NextWsState nextWsState;
        BoxedUnit boxedUnit;
        String string;
        Option<String> option = this.errorMessage;
        if (option instanceof Some) {
            Some some = (Some)option;
            String mess = (String)some.value();
            string = new StringBuilder(58).append("Client issued a ").append(frameType).append(" frame but WebSocket was already crashed: ").append(mess).toString();
        } else {
            string = "Client issued a $frameType frame but WebSocket was already closed";
        }
        String loggedMessage = string;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(loggedMessage);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.remainingReconnects() > 0) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Reconnecting WebSocket remainingReconnects={}", (Object)BoxesRunTime.boxToInteger((int)this.remainingReconnects()));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            nextWsState = WsConnectingState$.MODULE$.gotoConnecting(this.fsm, session, (Either<Action, SendFrame>)package$.MODULE$.Right().apply((Object)afterReconnectAction), this.remainingReconnects() - 1);
        } else {
            BoxedUnit boxedUnit3;
            long now = this.fsm.clock().nowMillis();
            String message = new StringBuilder(86).append("Client issued ").append(frameType).append(" frame but server has closed the WebSocket and max reconnects is reached").toString();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(message);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            Session newSession = this.logResponse(session, actionName, now, now, (Status)KO$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)message));
            nextWsState = new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> next.$bang(newSession));
        }
        return nextWsState;
    }

    public WsCrashedState(WsFsm fsm, Option<String> errorMessage, int remainingReconnects) {
        this.fsm = fsm;
        this.errorMessage = errorMessage;
        this.remainingReconnects = remainingReconnects;
        super(fsm);
    }
}

