/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import io.gatling.app.RunResult;
import io.gatling.app.RunResultProcessor$;
import io.gatling.app.cli.StatusCode;
import io.gatling.app.cli.StatusCode$AssertionsFailed$;
import io.gatling.app.cli.StatusCode$Success$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.ReportsGenerator;
import io.gatling.charts.stats.LogFileReader;
import io.gatling.commons.stats.GeneralStatsSource;
import io.gatling.commons.stats.assertion.AssertionResult;
import io.gatling.commons.stats.assertion.AssertionValidator$;
import io.gatling.commons.util.ClockSingleton$;
import io.gatling.core.config.GatlingConfiguration;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Map;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.compat.java8.JFunction2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}<a!\u0001\u0002\t\u0002\tA\u0011A\u0005*v]J+7/\u001e7u!J|7-Z:t_JT!a\u0001\u0003\u0002\u0007\u0005\u0004\bO\u0003\u0002\u0006\r\u00059q-\u0019;mS:<'\"A\u0004\u0002\u0005%|\u0007CA\u0005\u000b\u001b\u0005\u0011aAB\u0006\u0003\u0011\u0003\u0011AB\u0001\nSk:\u0014Vm];miB\u0013xnY3tg>\u00148C\u0001\u0006\u000e!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fM\")AC\u0003C\u0001-\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\t\u0011\u0015A\"\u0002\"\u0001\u001a\u0003\u0015\t\u0007\u000f\u001d7z)\tQb\u0010\u0005\u0002\n7\u0019!1B\u0001\u0001\u001d'\tYR\u0002\u0003\u0005\u001f7\t\u0005\t\u0015!\u0003 \u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0007G>tg-[4\u000b\u0005\u0011\"\u0011\u0001B2pe\u0016L!AJ\u0011\u0003)\u001d\u000bG\u000f\\5oO\u000e{gNZ5hkJ\fG/[8o\u0011\u0015!2\u0004\"\u0001))\tQ\u0012\u0006C\u0003\u001fO\u0001\u0007q\u0004C\u0004#7\t\u0007I1A\u0016\u0016\u0003}Aa!L\u000e!\u0002\u0013y\u0012aB2p]\u001aLw\r\t\u0005\u0006_m!\t\u0001M\u0001\u0011aJ|7-Z:t%Vt'+Z:vYR$\"!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0012\u0011aA2mS&\u0011ag\r\u0002\u000b'R\fG/^:D_\u0012,\u0007\"\u0002\u001d/\u0001\u0004I\u0014!\u0003:v]J+7/\u001e7u!\tI!(\u0003\u0002<\u0005\tI!+\u001e8SKN,H\u000e\u001e\u0005\u0006{m!IAP\u0001\u0012S:LG\u000fT8h\r&dWMU3bI\u0016\u0014HCA K!\rq\u0001IQ\u0005\u0003\u0003>\u0011aa\u00149uS>t\u0007CA\"I\u001b\u0005!%BA#G\u0003\u0015\u0019H/\u0019;t\u0015\t9E!\u0001\u0004dQ\u0006\u0014Ho]\u0005\u0003\u0013\u0012\u0013Q\u0002T8h\r&dWMU3bI\u0016\u0014\b\"\u0002\u001d=\u0001\u0004I\u0004\"\u0002'\u001c\t\u0013i\u0015\u0001\u0007:fa>\u0014Ho]$f]\u0016\u0014\u0018\r^5p]\u0016s\u0017M\u00197fIV\ta\n\u0005\u0002\u000f\u001f&\u0011\u0001k\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015\u00116\u0004\"\u0003T\u0003=9WM\\3sCR,'+\u001a9peR\u001cHc\u0001+X?B\u0011a\"V\u0005\u0003->\u0011A!\u00168ji\")\u0001,\u0015a\u00013\u00069\"/\u001a9peR\u001cx)\u001a8fe\u0006$\u0018n\u001c8J]B,Ho\u001d\t\u00035vk\u0011a\u0017\u0006\u00039\u001a\u000baA]3q_J$\u0018B\u00010\\\u0005]\u0011V\r]8siN<UM\\3sCRLwN\\%oaV$8\u000fC\u0003a#\u0002\u0007\u0011-A\u0003ti\u0006\u0014H\u000f\u0005\u0002\u000fE&\u00111m\u0004\u0002\u0005\u0019>tw\rC\u0003f7\u0011%a-A\u0005sk:\u001cF/\u0019;vgR\u0011\u0011g\u001a\u0005\u0006Q\u0012\u0004\r![\u0001\u0011CN\u001cXM\u001d;j_:\u0014Vm];miN\u00042A\u001b:v\u001d\tY\u0007O\u0004\u0002m_6\tQN\u0003\u0002o+\u00051AH]8pizJ\u0011\u0001E\u0005\u0003c>\tq\u0001]1dW\u0006<W-\u0003\u0002ti\n!A*[:u\u0015\t\tx\u0002\u0005\u0002wy6\tqO\u0003\u0002ys\u0006I\u0011m]:feRLwN\u001c\u0006\u0003\u000bjT!a\u001f\u0003\u0002\u000f\r|W.\\8og&\u0011Qp\u001e\u0002\u0010\u0003N\u001cXM\u001d;j_:\u0014Vm];mi\")ad\u0006a\u0001?\u0001")
public class RunResultProcessor {
    private final GatlingConfiguration configuration;
    private final GatlingConfiguration config;
    private static /* synthetic */ Map $deserializeLambdaCache$;

    public static RunResultProcessor apply(GatlingConfiguration gatlingConfiguration) {
        return RunResultProcessor$.MODULE$.apply(gatlingConfiguration);
    }

    public GatlingConfiguration config() {
        return this.config;
    }

    public StatusCode processRunResult(RunResult runResult) {
        StatusCode statusCode;
        long start = ClockSingleton$.MODULE$.nowMillis();
        Option<LogFileReader> option = this.initLogFileReader(runResult);
        if (option instanceof Some) {
            Some some = (Some)option;
            LogFileReader reader = (LogFileReader)some.x();
            List assertionResults = AssertionValidator$.MODULE$.validateAssertions((GeneralStatsSource)reader);
            if (this.reportsGenerationEnabled()) {
                ReportsGenerationInputs reportsGenerationInputs = new ReportsGenerationInputs(runResult.runId(), reader, assertionResults);
                this.generateReports(reportsGenerationInputs, start);
            }
            statusCode = this.runStatus((List<AssertionResult>)assertionResults);
        } else {
            statusCode = StatusCode$Success$.MODULE$;
        }
        return statusCode;
    }

    private Option<LogFileReader> initLogFileReader(RunResult runResult) {
        return this.reportsGenerationEnabled() || runResult.hasAssertions() ? new Some((Object)new LogFileReader(runResult.runId(), this.config())) : None$.MODULE$;
    }

    private boolean reportsGenerationEnabled() {
        return this.configuration.core().directory().reportsOnly().isDefined() || this.configuration.data().fileDataWriterEnabled() && !this.configuration.charting().noReports();
    }

    private void generateReports(ReportsGenerationInputs reportsGenerationInputs, long start) {
        Predef$.MODULE$.println((Object)"Generating reports...");
        Path indexFile = new ReportsGenerator(this.config()).generateFor(reportsGenerationInputs);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reports generated in ", "s."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((ClockSingleton$.MODULE$.nowMillis() - start) / 1000L))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please open the following file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indexFile.toFile()})));
    }

    private StatusCode runStatus(List<AssertionResult> assertionResults) {
        boolean consolidatedAssertionResult = BoxesRunTime.unboxToBoolean((Object)assertionResults.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)(JFunction2 & Serializable & scala.Serializable)(isValid, assertionResult) -> BoxesRunTime.boxToBoolean((boolean)RunResultProcessor.io$gatling$app$RunResultProcessor$$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)isValid), assertionResult))));
        return consolidatedAssertionResult ? StatusCode$Success$.MODULE$ : StatusCode$AssertionsFailed$.MODULE$;
    }

    public static final /* synthetic */ boolean io$gatling$app$RunResultProcessor$$$anonfun$1(boolean isValid, AssertionResult assertionResult) {
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assertionResult.message(), BoxesRunTime.boxToBoolean((boolean)assertionResult.result())})));
        return isValid && assertionResult.result();
    }

    public RunResultProcessor(GatlingConfiguration configuration) {
        this.configuration = configuration;
        this.config = configuration;
    }
}

