/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeapitest.junit;

import io.fabric8.kubeapitest.KubeAPIServer;
import io.fabric8.kubeapitest.KubeAPIServerConfig;
import io.fabric8.kubeapitest.KubeAPIServerConfigBuilder;
import io.fabric8.kubeapitest.KubeAPITestException;
import io.fabric8.kubeapitest.junit.ClientInjectionHandler;
import io.fabric8.kubeapitest.junit.EnableKubeAPIServer;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeAPIServerExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final Logger log = LoggerFactory.getLogger(KubeAPIServerExtension.class);
    private KubeAPIServer kubeApiServer;
    private List<ClientInjectionHandler> clientInjectionHandlers;

    public KubeAPIServerExtension() {
        ServiceLoader<ClientInjectionHandler> loader = ServiceLoader.load(ClientInjectionHandler.class);
        this.clientInjectionHandlers = loader.stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
    }

    public void beforeAll(ExtensionContext extensionContext) {
        this.initialize(extensionContext, true);
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.stopIfAnnotationPresent(extensionContext);
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.initialize(extensionContext, false);
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.stopIfAnnotationPresent(extensionContext);
    }

    private void initialize(ExtensionContext extensionContext, boolean staticContext) {
        List<ClientInjectionHandler> targetInjectors = this.clientInjectionHandlers.stream().filter(h -> h.isTargetFieldAvailable(extensionContext, staticContext)).collect(Collectors.toList());
        this.startIfAnnotationPresent(extensionContext, !targetInjectors.isEmpty());
        targetInjectors.forEach(i -> i.inject(extensionContext, staticContext, this.kubeApiServer));
    }

    private void startIfAnnotationPresent(ExtensionContext extensionContext, boolean willInjectClient) {
        extensionContext.getElement().ifPresent(ae -> {
            Optional<EnableKubeAPIServer> annotation = this.getExtensionAnnotationInstance((AnnotatedElement)ae);
            annotation.ifPresent(a -> {
                if (!willInjectClient && !a.updateKubeConfigFile()) {
                    log.warn("Neither kube config file will be updated or client info will be injected into the test. This is probably a misconfiguration since server won't be easily accessible.");
                }
                this.startApiServer((EnableKubeAPIServer)a);
            });
        });
    }

    private void startApiServer(EnableKubeAPIServer annotation) {
        this.kubeApiServer = new KubeAPIServer(this.annotationToConfig(annotation));
        this.kubeApiServer.start();
    }

    private void stopIfAnnotationPresent(ExtensionContext extensionContext) {
        extensionContext.getElement().ifPresent(ae -> {
            Optional<EnableKubeAPIServer> annotation = this.getExtensionAnnotationInstance((AnnotatedElement)ae);
            annotation.ifPresent(a -> {
                this.clientInjectionHandlers.forEach(ih -> ih.cleanup(extensionContext));
                this.kubeApiServer.stop();
            });
        });
    }

    private KubeAPIServerConfig annotationToConfig(EnableKubeAPIServer annotation) {
        KubeAPIServerConfigBuilder builder = KubeAPIServerConfigBuilder.anAPIServerConfig();
        String version = annotation.kubeAPIVersion();
        if (!"NOT_SET".equals(version)) {
            builder.withApiServerVersion(version);
        }
        if (annotation.apiServerFlags().length > 0) {
            builder.withApiServerFlags(List.of(annotation.apiServerFlags()));
        }
        builder.withUpdateKubeConfig(annotation.updateKubeConfigFile());
        return builder.build();
    }

    private Optional<EnableKubeAPIServer> getExtensionAnnotationInstance(AnnotatedElement ae) {
        List annotations = Arrays.stream(ae.getAnnotations()).filter(a -> a.annotationType().isAssignableFrom(EnableKubeAPIServer.class)).collect(Collectors.toList());
        if (annotations.size() > 1) {
            throw new KubeAPITestException("Only one instance of @EnableKubeAPIServer annotation is allowed");
        }
        if (annotations.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((EnableKubeAPIServer)annotations.get(0));
    }
}

