/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeapitest;

import io.fabric8.kubeapitest.KubeAPIServerConfig;
import io.fabric8.kubeapitest.KubeAPIServerConfigBuilder;
import io.fabric8.kubeapitest.binary.BinaryManager;
import io.fabric8.kubeapitest.cert.CertManager;
import io.fabric8.kubeapitest.kubeconfig.KubeConfig;
import io.fabric8.kubeapitest.process.EtcdProcess;
import io.fabric8.kubeapitest.process.KubeAPIServerProcess;
import io.fabric8.kubeapitest.process.UnexpectedProcessStopHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeAPIServer
implements UnexpectedProcessStopHandler {
    private static final Logger log = LoggerFactory.getLogger(KubeAPIServer.class);
    private final KubeAPIServerConfig config;
    private final BinaryManager binaryManager;
    private final CertManager certManager;
    private final KubeConfig kubeConfig;
    private final EtcdProcess etcdProcess;
    private final KubeAPIServerProcess kubeApiServerProcess;

    public KubeAPIServer() {
        this(KubeAPIServerConfigBuilder.anAPIServerConfig().build());
    }

    public KubeAPIServer(KubeAPIServerConfig config) {
        this.config = config;
        this.binaryManager = new BinaryManager(config);
        this.certManager = new CertManager(config.getKubeAPITestDir());
        this.kubeConfig = new KubeConfig(this.certManager, this.binaryManager);
        this.etcdProcess = new EtcdProcess(this.binaryManager, this, config.isWaitForEtcdHealthCheckOnStartup(), config.getStartupTimeout());
        this.kubeApiServerProcess = new KubeAPIServerProcess(this.certManager, this.binaryManager, this, config);
    }

    public void start() {
        log.debug("Stating API Server. Using Kube API Test dir: {}", (Object)this.config.getKubeAPITestDir());
        this.binaryManager.initAndDownloadIfRequired();
        this.certManager.createCertificatesIfNeeded();
        int etcdPort = this.etcdProcess.startEtcd();
        int apiServerPort = this.kubeApiServerProcess.startApiServer(etcdPort);
        if (this.config.isUpdateKubeConfig()) {
            this.kubeConfig.updateKubeConfig(apiServerPort);
        }
        this.kubeApiServerProcess.waitUntilReady();
        log.debug("API Server ready to use");
    }

    public void stop() {
        log.debug("Stopping");
        this.kubeApiServerProcess.stopApiServer();
        this.etcdProcess.stopEtcd();
        if (this.config.isUpdateKubeConfig()) {
            this.kubeConfig.restoreKubeConfig();
        }
        this.etcdProcess.cleanEtcdData();
        log.debug("Stopped");
    }

    public String getKubeConfigYaml() {
        return this.kubeConfig.generateKubeConfigYaml(this.kubeApiServerProcess.getApiServerPort());
    }

    @Override
    public void processStopped(Process process) {
        this.stop();
    }
}

