/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.fabric8.maven.docker.access.PortMapping;
import io.fabric8.maven.docker.config.LogConfiguration;
import io.fabric8.maven.docker.config.UlimitConfig;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.JsonFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ContainerHostConfig {
    final JsonObject startConfig = new JsonObject();

    public ContainerHostConfig binds(List<String> bind) {
        if (bind != null && !bind.isEmpty()) {
            JsonArray binds = new JsonArray();
            for (String volume : bind) {
                if (!(volume = EnvUtil.fixupPath(volume)).contains(":")) continue;
                binds.add(volume);
            }
            this.startConfig.add("Binds", (JsonElement)binds);
        }
        return this;
    }

    public ContainerHostConfig capAdd(List<String> capAdd) {
        return this.addAsArray("CapAdd", capAdd);
    }

    public ContainerHostConfig capDrop(List<String> capDrop) {
        return this.addAsArray("CapDrop", capDrop);
    }

    public ContainerHostConfig sysctls(Map<String, String> sysctls) {
        if (sysctls != null && sysctls.size() > 0) {
            this.startConfig.add("Sysctls", (JsonElement)JsonFactory.newJsonObject(sysctls));
        }
        return this;
    }

    public ContainerHostConfig securityOpts(List<String> securityOpt) {
        return this.addAsArray("SecurityOpt", securityOpt);
    }

    public ContainerHostConfig memory(Long memory) {
        return this.add("Memory", memory);
    }

    public ContainerHostConfig memorySwap(Long memorySwap) {
        return this.add("MemorySwap", memorySwap);
    }

    public ContainerHostConfig dns(List<String> dns) {
        return this.addAsArray("Dns", dns);
    }

    public ContainerHostConfig networkMode(String net) {
        return this.add("NetworkMode", net);
    }

    public ContainerHostConfig dnsSearch(List<String> dnsSearch) {
        return this.addAsArray("DnsSearch", dnsSearch);
    }

    public ContainerHostConfig isolation(String isolation) {
        return this.add("Isolation", isolation);
    }

    public ContainerHostConfig cpuShares(Long cpuShares) {
        return this.add("CpuShares", cpuShares);
    }

    public ContainerHostConfig cpus(Double cpus) {
        return this.add("NanoCpus", this.convertToNanoCpus(cpus));
    }

    public ContainerHostConfig cpuSet(String cpuSet) {
        return this.add("CpusetCpus", cpuSet);
    }

    public ContainerHostConfig extraHosts(List<String> extraHosts) throws IllegalArgumentException {
        if (extraHosts != null) {
            ArrayList<String> mapped = new ArrayList<String>();
            for (int i = 0; i < extraHosts.size(); ++i) {
                String[] parts = extraHosts.get(i).split(":");
                if (parts.length == 1) {
                    throw new IllegalArgumentException("extraHosts must be in the form <host:host|ip>");
                }
                try {
                    mapped.add(i, parts[0] + ":" + InetAddress.getByName(parts[1]).getHostAddress());
                    continue;
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("unable to resolve ip address for " + parts[1], e);
                }
            }
            return this.addAsArray("ExtraHosts", mapped);
        }
        return this;
    }

    public ContainerHostConfig volumesFrom(List<String> volumesFrom) {
        return this.addAsArray("VolumesFrom", volumesFrom);
    }

    public ContainerHostConfig ulimits(List<UlimitConfig> ulimitsConfig) {
        if (ulimitsConfig != null && ulimitsConfig.size() > 0) {
            JsonArray ulimits = new JsonArray();
            for (UlimitConfig ulimit : ulimitsConfig) {
                JsonObject ulimitConfigJson = new JsonObject();
                ulimitConfigJson.addProperty("Name", ulimit.getName());
                this.addIfNotNull(ulimitConfigJson, "Hard", ulimit.getHard());
                this.addIfNotNull(ulimitConfigJson, "Soft", ulimit.getSoft());
                ulimits.add((JsonElement)ulimitConfigJson);
            }
            this.startConfig.add("Ulimits", (JsonElement)ulimits);
        }
        return this;
    }

    private void addIfNotNull(JsonObject json, String key, Integer value) {
        if (value != null) {
            json.addProperty(key, (Number)value);
        }
    }

    public ContainerHostConfig links(List<String> links) {
        return this.addAsArray("Links", links);
    }

    public ContainerHostConfig portBindings(PortMapping portMapping) {
        JsonObject portBindings = portMapping.toDockerPortBindingsJson();
        if (portBindings != null) {
            this.startConfig.add("PortBindings", (JsonElement)portBindings);
        }
        return this;
    }

    public ContainerHostConfig privileged(Boolean privileged) {
        return this.add("Privileged", privileged);
    }

    public ContainerHostConfig tmpfs(List<String> mounts) {
        if (mounts != null && mounts.size() > 0) {
            JsonObject tmpfs = new JsonObject();
            for (String mount : mounts) {
                int idx = mount.indexOf(58);
                if (idx > -1) {
                    tmpfs.addProperty(mount.substring(0, idx), mount.substring(idx + 1));
                    continue;
                }
                tmpfs.addProperty(mount, "");
            }
            this.startConfig.add("Tmpfs", (JsonElement)tmpfs);
        }
        return this;
    }

    public ContainerHostConfig shmSize(Long shmSize) {
        return this.add("ShmSize", shmSize);
    }

    public ContainerHostConfig restartPolicy(String name, int retry) {
        if (name != null) {
            JsonObject policy = new JsonObject();
            policy.addProperty("Name", name);
            policy.addProperty("MaximumRetryCount", (Number)retry);
            this.startConfig.add("RestartPolicy", (JsonElement)policy);
        }
        return this;
    }

    public ContainerHostConfig logConfig(LogConfiguration logConfig) {
        LogConfiguration.LogDriver logDriver;
        if (logConfig != null && (logDriver = logConfig.getDriver()) != null) {
            JsonObject logConfigJson = new JsonObject();
            logConfigJson.addProperty("Type", logDriver.getName());
            Map<String, String> opts = logDriver.getOpts();
            if (opts != null && opts.size() > 0) {
                JsonObject config = new JsonObject();
                for (Map.Entry<String, String> logOpt : opts.entrySet()) {
                    config.addProperty(logOpt.getKey(), logOpt.getValue());
                }
                logConfigJson.add("Config", (JsonElement)config);
            }
            this.startConfig.add("LogConfig", (JsonElement)logConfigJson);
        }
        return this;
    }

    public ContainerHostConfig readonlyRootfs(Boolean readOnly) {
        return this.add("ReadonlyRootfs", readOnly);
    }

    public ContainerHostConfig autoRemove(Boolean autoRemove) {
        return this.add("AutoRemove", autoRemove);
    }

    public String toJson() {
        return this.startConfig.toString();
    }

    public JsonObject toJsonObject() {
        return this.startConfig;
    }

    ContainerHostConfig addAsArray(String propKey, List<String> props) {
        if (props != null) {
            this.startConfig.add(propKey, (JsonElement)JsonFactory.newJsonArray(props));
        }
        return this;
    }

    private ContainerHostConfig add(String name, String value) {
        if (value != null) {
            this.startConfig.addProperty(name, value);
        }
        return this;
    }

    private ContainerHostConfig add(String name, Boolean value) {
        if (value != null) {
            this.startConfig.addProperty(name, value);
        }
        return this;
    }

    private ContainerHostConfig add(String name, Long value) {
        if (value != null) {
            this.startConfig.addProperty(name, (Number)value);
        }
        return this;
    }

    private Long convertToNanoCpus(Double cpus) {
        if (cpus == null) {
            return null;
        }
        return (long)(cpus * 1.0E9);
    }
}

