/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.usageformatter;

import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.SourceReference;
import io.cucumber.messages.types.StepDefinitionPattern;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class UsageReport {
    private final List<StepDefinitionUsage> stepDefinitions;

    UsageReport(List<StepDefinitionUsage> stepDefinitions) {
        this.stepDefinitions = Objects.requireNonNull(stepDefinitions);
    }

    public List<StepDefinitionUsage> getStepDefinitions() {
        return this.stepDefinitions;
    }

    public static final class StepUsage {
        private final String text;
        private final Duration duration;
        private final String uri;
        private final Location location;

        StepUsage(String text, Duration duration, String uri, Location location) {
            this.text = Objects.requireNonNull(text);
            this.duration = Objects.requireNonNull(duration);
            this.uri = Objects.requireNonNull(uri);
            this.location = location;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public String getUri() {
            return this.uri;
        }

        public Optional<Location> getLocation() {
            return Optional.ofNullable(this.location);
        }

        public String getText() {
            return this.text;
        }
    }

    public static final class Statistics {
        private final Duration sum;
        private final Duration mean;
        private final Duration moe95;

        Statistics(Duration sum, Duration mean, Duration moe95) {
            this.sum = sum;
            this.mean = mean;
            this.moe95 = moe95;
        }

        public Duration getSum() {
            return this.sum;
        }

        public Duration getMean() {
            return this.mean;
        }

        public Duration getMoe95() {
            return this.moe95;
        }
    }

    public static final class StepDefinitionUsage {
        private final StepDefinitionPattern pattern;
        private final SourceReference sourceReference;
        private final Statistics duration;
        private final List<StepUsage> matches;

        StepDefinitionUsage(StepDefinitionPattern pattern, SourceReference sourceReference, Statistics duration, List<StepUsage> matches) {
            this.pattern = Objects.requireNonNull(pattern);
            this.sourceReference = Objects.requireNonNull(sourceReference);
            this.duration = duration;
            this.matches = Objects.requireNonNull(matches);
        }

        public StepDefinitionPattern getExpression() {
            return this.pattern;
        }

        public Statistics getDuration() {
            return this.duration;
        }

        public List<StepUsage> getMatches() {
            return this.matches;
        }

        public SourceReference getSourceReference() {
            return this.sourceReference;
        }
    }
}

