/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.exceptionsorter;

import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import java.sql.SQLException;
import java.util.Locale;

public class OracleExceptionSorter
implements AgroalConnectionPoolConfiguration.ExceptionSorter {
    @Override
    public boolean isFatal(SQLException e) {
        int errorCode = Math.abs(e.getErrorCode());
        if (errorCode == 28 || errorCode == 600 || errorCode == 1012 || errorCode == 1014 || errorCode == 1033 || errorCode == 1034 || errorCode == 1035 || errorCode == 1089 || errorCode == 1090 || errorCode == 1092 || errorCode == 1094 || errorCode == 2396 || errorCode == 3106 || errorCode == 3111 || errorCode == 3113 || errorCode == 3114 || errorCode >= 12100 && errorCode <= 12299 || errorCode == 17002 || errorCode == 17008 || errorCode == 17410 || errorCode == 17447) {
            return true;
        }
        String errorText = e.getMessage().toUpperCase(Locale.US);
        if ((errorCode < 20000 || errorCode >= 21000) && (errorText.contains("SOCKET") || errorText.contains("CONNECTION HAS ALREADY BEEN CLOSED") || errorText.contains("BROKEN PIPE"))) {
            return true;
        }
        return "08000".equals(e.getSQLState());
    }
}

