/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.junit;

import cucumber.api.PendingException;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Runtime;
import cucumber.runtime.junit.ExecutionUnitRunner;
import cucumber.runtime.junit.JUnitOptions;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.List;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;

public class JUnitReporter
implements Reporter,
Formatter {
    private final List<Step> steps = new ArrayList<Step>();
    private final Reporter reporter;
    private final Formatter formatter;
    private final boolean strict;
    private final JUnitOptions junitOptions;
    EachTestNotifier stepNotifier;
    private ExecutionUnitRunner executionUnitRunner;
    private RunNotifier runNotifier;
    EachTestNotifier executionUnitNotifier;
    private boolean failedStep;
    private boolean ignoredStep;
    private boolean inScenarioLifeCycle;

    public JUnitReporter(Reporter reporter, Formatter formatter, boolean strict, JUnitOptions junitOption) {
        this.reporter = reporter;
        this.formatter = formatter;
        this.strict = strict;
        this.junitOptions = junitOption;
    }

    public void startExecutionUnit(ExecutionUnitRunner executionUnitRunner, RunNotifier runNotifier) {
        this.executionUnitRunner = executionUnitRunner;
        this.runNotifier = runNotifier;
        this.stepNotifier = null;
        this.failedStep = false;
        this.ignoredStep = false;
        this.executionUnitNotifier = new EachTestNotifier(runNotifier, executionUnitRunner.getDescription());
        this.executionUnitNotifier.fireTestStarted();
    }

    public void finishExecutionUnit() {
        if (this.ignoredStep && !this.failedStep) {
            this.executionUnitNotifier.fireTestIgnored();
        }
        this.executionUnitNotifier.fireTestFinished();
    }

    public void match(Match match) {
        Step runnerStep = this.fetchAndCheckRunnerStep();
        Description description = this.executionUnitRunner.describeChild(runnerStep);
        this.stepNotifier = new EachTestNotifier(this.runNotifier, description);
        this.reporter.match(match);
        if (this.junitOptions.allowStartedIgnored()) {
            this.stepNotifier.fireTestStarted();
        }
    }

    private Step fetchAndCheckRunnerStep() {
        Step scenarioStep = this.steps.remove(0);
        Step runnerStep = this.executionUnitRunner.getRunnerSteps().remove(0);
        if (!scenarioStep.getName().equals(runnerStep.getName())) {
            throw new CucumberException("Expected step: \"" + scenarioStep.getName() + "\" got step: \"" + runnerStep.getName() + "\"");
        }
        return runnerStep;
    }

    public void embedding(String mimeType, byte[] data) {
        this.reporter.embedding(mimeType, data);
    }

    public void write(String text) {
        this.reporter.write(text);
    }

    public void result(Result result) {
        Throwable error = result.getError();
        if (Result.SKIPPED == result) {
            this.stepNotifier.fireTestIgnored();
        } else if (this.isPendingOrUndefined(result)) {
            this.addFailureOrIgnoreStep(result);
        } else {
            if (this.stepNotifier != null) {
                if (!this.junitOptions.allowStartedIgnored()) {
                    this.stepNotifier.fireTestStarted();
                }
                if (error != null) {
                    this.stepNotifier.addFailure(error);
                }
                this.stepNotifier.fireTestFinished();
            }
            if (error != null) {
                this.failedStep = true;
                this.executionUnitNotifier.addFailure(error);
            }
        }
        if (this.steps.isEmpty()) {
            this.stepNotifier = null;
        }
        this.reporter.result(result);
    }

    public boolean useFilenameCompatibleNames() {
        return this.junitOptions.filenameCompatibleNames();
    }

    private boolean isPendingOrUndefined(Result result) {
        Throwable error = result.getError();
        return Result.UNDEFINED == result || Runtime.isPending((Throwable)error);
    }

    private void addFailureOrIgnoreStep(Result result) {
        if (this.strict) {
            if (!this.junitOptions.allowStartedIgnored()) {
                this.stepNotifier.fireTestStarted();
            }
            this.addFailure(result);
            this.stepNotifier.fireTestFinished();
        } else {
            this.ignoredStep = true;
            this.stepNotifier.fireTestIgnored();
        }
    }

    private void addFailure(Result result) {
        Throwable error = result.getError();
        if (error == null) {
            error = new PendingException();
        }
        this.failedStep = true;
        this.stepNotifier.addFailure(error);
        this.executionUnitNotifier.addFailure(error);
    }

    public void before(Match match, Result result) {
        this.handleHook(result);
        this.reporter.before(match, result);
    }

    public void after(Match match, Result result) {
        this.handleHook(result);
        this.reporter.after(match, result);
    }

    private void handleHook(Result result) {
        if (result.getStatus().equals("failed") || this.strict && Runtime.isPending((Throwable)result.getError())) {
            this.executionUnitNotifier.addFailure(result.getError());
        } else if (Runtime.isPending((Throwable)result.getError())) {
            this.ignoredStep = true;
        }
    }

    public void uri(String uri) {
        this.formatter.uri(uri);
    }

    public void feature(Feature feature) {
        this.formatter.feature(feature);
    }

    public void background(Background background) {
        this.formatter.background(background);
    }

    public void scenario(Scenario scenario) {
        this.formatter.scenario(scenario);
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.formatter.scenarioOutline(scenarioOutline);
    }

    public void examples(Examples examples) {
        this.formatter.examples(examples);
    }

    public void step(Step step) {
        if (this.inScenarioLifeCycle) {
            this.steps.add(step);
        }
        this.formatter.step(step);
    }

    public void eof() {
        this.formatter.eof();
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
        this.formatter.syntaxError(state, event, legalEvents, uri, line);
    }

    public void done() {
        this.formatter.done();
    }

    public void close() {
        this.formatter.close();
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        this.inScenarioLifeCycle = true;
        this.formatter.startOfScenarioLifeCycle(scenario);
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        this.formatter.endOfScenarioLifeCycle(scenario);
        this.inScenarioLifeCycle = false;
    }
}

