/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.junit;

import cucumber.runtime.CucumberException;
import gherkin.util.FixJava;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class JUnitOptions {
    public static final String OPTIONS_RESOURCE = "/cucumber/api/junit/OPTIONS.txt";
    private static String optionsText;
    private boolean allowStartedIgnored = false;
    private boolean filenameCompatibleNames = false;

    public JUnitOptions(List<String> argv) {
        argv = new ArrayList<String>(argv);
        this.parse(argv);
    }

    private void parse(List<String> args) {
        while (!args.isEmpty()) {
            String arg = args.remove(0).trim();
            if (arg.equals("--help") || arg.equals("-h")) {
                this.printOptions();
                System.exit(0);
                continue;
            }
            if (arg.equals("--no-allow-started-ignored") || arg.equals("--allow-started-ignored")) {
                this.allowStartedIgnored = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--no-filename-compatible-names") || arg.equals("--filename-compatible-names")) {
                this.filenameCompatibleNames = !arg.startsWith("--no-");
                continue;
            }
            throw new CucumberException("Unknown option: " + arg);
        }
    }

    public boolean allowStartedIgnored() {
        return this.allowStartedIgnored;
    }

    public boolean filenameCompatibleNames() {
        return this.filenameCompatibleNames;
    }

    private void printOptions() {
        JUnitOptions.loadUsageTextIfNeeded();
        System.out.println(optionsText);
    }

    static void loadUsageTextIfNeeded() {
        if (optionsText == null) {
            try {
                InputStreamReader reader = new InputStreamReader(FixJava.class.getResourceAsStream(OPTIONS_RESOURCE), "UTF-8");
                optionsText = FixJava.readReader((Reader)reader);
            }
            catch (Exception e) {
                optionsText = "Could not load usage text: " + e.toString();
            }
        }
    }
}

