/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.junit;

import cucumber.runtime.Runtime;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberScenario;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Step;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class ExecutionUnitRunner
extends ParentRunner<Step> {
    private final Runtime runtime;
    private final CucumberScenario cucumberScenario;
    private final JUnitReporter jUnitReporter;
    private Description description;
    private final Map<Step, Description> stepDescriptions = new HashMap<Step, Description>();
    private final List<Step> runnerSteps = new ArrayList<Step>();

    public ExecutionUnitRunner(Runtime runtime, CucumberScenario cucumberScenario, JUnitReporter jUnitReporter) throws InitializationError {
        super(ExecutionUnitRunner.class);
        this.runtime = runtime;
        this.cucumberScenario = cucumberScenario;
        this.jUnitReporter = jUnitReporter;
    }

    public List<Step> getRunnerSteps() {
        return this.runnerSteps;
    }

    protected List<Step> getChildren() {
        return this.cucumberScenario.getSteps();
    }

    public String getName() {
        String name = this.cucumberScenario.getVisualName();
        if (this.jUnitReporter.useFilenameCompatibleNames()) {
            return this.makeNameFilenameCompatible(name);
        }
        return name;
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)this.cucumberScenario.getGherkinModel(), (Annotation[])new Annotation[0]);
            if (this.cucumberScenario.getCucumberBackground() != null) {
                for (Step backgroundStep : this.cucumberScenario.getCucumberBackground().getSteps()) {
                    Step copy = new Step(backgroundStep.getComments(), backgroundStep.getKeyword(), backgroundStep.getName(), backgroundStep.getLine(), backgroundStep.getRows(), backgroundStep.getDocString());
                    this.description.addChild(this.describeChild(copy));
                    this.runnerSteps.add(copy);
                }
            }
            for (Step step : this.getChildren()) {
                this.description.addChild(this.describeChild(step));
                this.runnerSteps.add(step);
            }
        }
        return this.description;
    }

    protected Description describeChild(Step step) {
        Description description = this.stepDescriptions.get(step);
        if (description == null) {
            String testName = this.jUnitReporter.useFilenameCompatibleNames() ? this.makeNameFilenameCompatible(step.getKeyword() + step.getName()) : step.getKeyword() + step.getName();
            description = Description.createTestDescription((String)this.getName(), (String)testName, (Serializable)step);
            this.stepDescriptions.put(step, description);
        }
        return description;
    }

    public void run(RunNotifier notifier) {
        this.jUnitReporter.startExecutionUnit(this, notifier);
        this.cucumberScenario.run((Formatter)this.jUnitReporter, (Reporter)this.jUnitReporter, this.runtime);
        this.jUnitReporter.finishExecutionUnit();
    }

    protected void runChild(Step step, RunNotifier notifier) {
        throw new UnsupportedOperationException();
    }

    private String makeNameFilenameCompatible(String name) {
        return name.replaceAll("[^A-Za-z0-9_]", "_");
    }
}

