/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.junit;

import cucumber.runtime.Runtime;
import cucumber.runtime.junit.ExecutionUnitRunner;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberExamples;
import cucumber.runtime.model.CucumberScenario;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

public class ExamplesRunner
extends Suite {
    private final CucumberExamples cucumberExamples;
    private Description description;
    private JUnitReporter jUnitReporter;

    protected ExamplesRunner(Runtime runtime, CucumberExamples cucumberExamples, JUnitReporter jUnitReporter) throws InitializationError {
        super(ExamplesRunner.class, ExamplesRunner.buildRunners(runtime, cucumberExamples, jUnitReporter));
        this.cucumberExamples = cucumberExamples;
        this.jUnitReporter = jUnitReporter;
    }

    private static List<Runner> buildRunners(Runtime runtime, CucumberExamples cucumberExamples, JUnitReporter jUnitReporter) {
        ArrayList<Runner> runners = new ArrayList<Runner>();
        List exampleScenarios = cucumberExamples.createExampleScenarios();
        for (CucumberScenario scenario : exampleScenarios) {
            try {
                ExecutionUnitRunner exampleScenarioRunner = new ExecutionUnitRunner(runtime, scenario, jUnitReporter);
                runners.add((Runner)exampleScenarioRunner);
            }
            catch (InitializationError initializationError) {
                initializationError.printStackTrace();
            }
        }
        return runners;
    }

    protected String getName() {
        return this.cucumberExamples.getExamples().getKeyword() + ": " + this.cucumberExamples.getExamples().getName();
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)this.cucumberExamples.getExamples(), (Annotation[])new Annotation[0]);
            for (Runner child : this.getChildren()) {
                this.description.addChild(this.describeChild(child));
            }
        }
        return this.description;
    }

    public void run(RunNotifier notifier) {
        this.jUnitReporter.examples(this.cucumberExamples.getExamples());
        super.run(notifier);
    }
}

