/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.snippets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArgumentPattern {
    private final Pattern pattern;
    private final Class<?> type;

    public ArgumentPattern(Pattern pattern, Class<?> type) {
        this.pattern = pattern;
        this.type = type;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public Class<?> type() {
        return this.type;
    }

    public String replaceMatchesWithGroups(String name) {
        return this.replaceMatchWith(name, this.pattern.pattern());
    }

    public String replaceMatchesWithSpace(String name) {
        return this.replaceMatchWith(name, " ");
    }

    private String replaceMatchWith(String name, String replacement) {
        Matcher matcher = this.pattern.matcher(name);
        String quotedReplacement = Matcher.quoteReplacement(replacement);
        return matcher.replaceAll(quotedReplacement);
    }
}

