/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.StepDefinitionReporter;
import cucumber.runtime.AmbiguousStepDefinitionsException;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookComparator;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.StepDefinitionMatch;
import cucumber.runtime.UndefinedStepsTracker;
import cucumber.runtime.xstream.LocalizedXStreams;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RuntimeGlue
implements Glue {
    final Map<String, StepDefinition> stepDefinitionsByPattern = new TreeMap<String, StepDefinition>();
    final List<HookDefinition> beforeHooks = new ArrayList<HookDefinition>();
    final List<HookDefinition> afterHooks = new ArrayList<HookDefinition>();
    private final UndefinedStepsTracker tracker;
    private final LocalizedXStreams localizedXStreams;

    public RuntimeGlue(UndefinedStepsTracker tracker, LocalizedXStreams localizedXStreams) {
        this.tracker = tracker;
        this.localizedXStreams = localizedXStreams;
    }

    @Override
    public void addStepDefinition(StepDefinition stepDefinition) {
        StepDefinition previous = this.stepDefinitionsByPattern.get(stepDefinition.getPattern());
        if (previous != null) {
            throw new DuplicateStepDefinitionException(previous, stepDefinition);
        }
        this.stepDefinitionsByPattern.put(stepDefinition.getPattern(), stepDefinition);
    }

    @Override
    public void addBeforeHook(HookDefinition hookDefinition) {
        this.beforeHooks.add(hookDefinition);
        Collections.sort(this.beforeHooks, new HookComparator(true));
    }

    @Override
    public void addAfterHook(HookDefinition hookDefinition) {
        this.afterHooks.add(hookDefinition);
        Collections.sort(this.afterHooks, new HookComparator(false));
    }

    @Override
    public List<HookDefinition> getBeforeHooks() {
        return this.beforeHooks;
    }

    @Override
    public List<HookDefinition> getAfterHooks() {
        return this.afterHooks;
    }

    @Override
    public StepDefinitionMatch stepDefinitionMatch(String featurePath, Step step, I18n i18n) {
        List<StepDefinitionMatch> matches = this.stepDefinitionMatches(featurePath, step);
        try {
            if (matches.isEmpty()) {
                this.tracker.addUndefinedStep(step, i18n);
                StepDefinitionMatch stepDefinitionMatch = null;
                return stepDefinitionMatch;
            }
            if (matches.size() == 1) {
                StepDefinitionMatch stepDefinitionMatch = matches.get(0);
                return stepDefinitionMatch;
            }
            throw new AmbiguousStepDefinitionsException(matches);
        }
        finally {
            this.tracker.storeStepKeyword(step, i18n);
        }
    }

    private List<StepDefinitionMatch> stepDefinitionMatches(String featurePath, Step step) {
        ArrayList<StepDefinitionMatch> result = new ArrayList<StepDefinitionMatch>();
        for (StepDefinition stepDefinition : this.stepDefinitionsByPattern.values()) {
            List<Argument> arguments = stepDefinition.matchedArguments(step);
            if (arguments == null) continue;
            result.add(new StepDefinitionMatch(arguments, stepDefinition, featurePath, step, this.localizedXStreams));
        }
        return result;
    }

    @Override
    public void reportStepDefinitions(StepDefinitionReporter stepDefinitionReporter) {
        for (StepDefinition stepDefinition : this.stepDefinitionsByPattern.values()) {
            stepDefinitionReporter.stepDefinition(stepDefinition);
        }
    }

    @Override
    public void removeScenarioScopedGlue() {
        this.removeScenarioScopedHooks(this.beforeHooks);
        this.removeScenarioScopedHooks(this.afterHooks);
        this.removeScenarioScopedStepdefs();
    }

    private void removeScenarioScopedHooks(List<HookDefinition> beforeHooks1) {
        Iterator<HookDefinition> hookIterator = beforeHooks1.iterator();
        while (hookIterator.hasNext()) {
            HookDefinition hook = hookIterator.next();
            if (!hook.isScenarioScoped()) continue;
            hookIterator.remove();
        }
    }

    private void removeScenarioScopedStepdefs() {
        Iterator<Map.Entry<String, StepDefinition>> stepdefs = this.stepDefinitionsByPattern.entrySet().iterator();
        while (stepdefs.hasNext()) {
            StepDefinition stepDefinition = stepdefs.next().getValue();
            if (!stepDefinition.isScenarioScoped()) continue;
            stepdefs.remove();
        }
    }
}

