/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.rad;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.vaadin.firitin.components.details.VDetails;
import org.vaadin.firitin.components.html.VCode;
import org.vaadin.firitin.fields.internalhtmltable.Table;
import org.vaadin.firitin.fields.internalhtmltable.TableRow;
import org.vaadin.firitin.rad.DtoDisplay;
import org.vaadin.firitin.rad.PropertyContext;
import org.vaadin.firitin.rad.PropertyHeaderPrinter;
import org.vaadin.firitin.rad.PropertyPrinter;
import org.vaadin.firitin.rad.ValueContext;
import org.vaadin.firitin.rad.ValueContextImpl;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.introspect.BasicBeanDescription;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.type.ArrayType;
import tools.jackson.databind.type.CollectionLikeType;

public class PrettyPrinter {
    static final ObjectMapper jack = new ObjectMapper();
    static List<PropertyPrinter> _defaultPropertyPrinters = new ArrayList<PropertyPrinter>();
    private static final PrettyPrinter INSTANCE = new PrettyPrinter(PrettyPrinter.getDefaultPropertyPrinters());
    private final List<PropertyPrinter> propertyPrinters;
    private final List<PropertyHeaderPrinter> propertyHeaderPrinters;
    private Locale locale;

    public PrettyPrinter() {
        this(new ArrayList<PropertyPrinter>(PrettyPrinter.getDefaultPropertyPrinters()));
    }

    public PrettyPrinter(List<PropertyPrinter> propertyPrinters) {
        this.propertyPrinters = propertyPrinters;
        this.propertyHeaderPrinters = new ArrayList<PropertyHeaderPrinter>();
    }

    public static List<PropertyPrinter> getDefaultPropertyPrinters() {
        return Collections.unmodifiableList(_defaultPropertyPrinters);
    }

    static PrettyPrinter getDefault() {
        return INSTANCE;
    }

    public static Component toVaadin(Object value) {
        return INSTANCE.printToVaadin(value);
    }

    static BasicBeanDescription inrospect(Object dto) {
        if (dto == null) {
            return null;
        }
        JavaType javaType = jack.getTypeFactory().constructType(dto.getClass());
        return (BasicBeanDescription)jack._deserializationContext().introspectBeanDescription(javaType);
    }

    public static String printOneLiner(Object entity, int maxLength) {
        return PrettyPrinter.printOneLiner(entity, maxLength, "|", "|");
    }

    public static String printOneLiner(Object entity, int maxLength, String delim, String prefix) {
        if (entity == null) {
            return "null";
        }
        JavaType javaType = jack.getTypeFactory().constructType(entity.getClass());
        BasicBeanDescription bdd = (BasicBeanDescription)jack._deserializationContext().introspectBeanDescription(javaType);
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        List properties = bdd.findProperties();
        for (BeanPropertyDefinition p : properties) {
            String name;
            if (p.getAccessor() == null || (name = p.getName()).equals("hibernateLazyInitializer")) continue;
            Object value = p.getAccessor().getValue(entity);
            if (value == null) {
                sb.append("null");
                continue;
            }
            if (PrettyPrinter.isEntityType(p)) {
                BeanDescription introspect = jack._deserializationContext().introspectBeanDescription(jack.getTypeFactory().constructType((Type)p.getRawPrimaryType()));
                introspect.findProperties().stream().filter(pp -> pp.getName().equals("id")).findFirst().ifPresent(pp -> {
                    Object id = pp.getAccessor().getValue(value);
                    sb.append("\u21e2");
                    sb.append(p.getPrimaryType().getRawClass().getSimpleName());
                    sb.append("-");
                    sb.append(id);
                });
            } else {
                sb.append(value);
            }
            sb.append(delim);
        }
        if (sb.length() > maxLength) {
            return sb.substring(0, maxLength) + "...";
        }
        return sb.toString();
    }

    private static boolean isEntityType(BeanPropertyDefinition p) {
        try {
            Class<?> eaClazz = Class.forName("jakarta.persistence.Entity");
            Object annotation = p.getRawPrimaryType().getAnnotation(eaClazz);
            if (annotation != null) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return false;
    }

    public List<PropertyPrinter> getPropertyPrinters() {
        return this.propertyPrinters;
    }

    public Component printToVaadin(Object value) {
        ValueContextImpl valueContext = new ValueContextImpl(this, value);
        return this.printToVaadin(valueContext);
    }

    Component printToVaadin(ValueContext ctx) {
        DtoDisplay dtoDisplay = new DtoDisplay(this.propertyPrinters, ctx);
        this.propertyHeaderPrinters.forEach(dtoDisplay::withPropertyHeaderPrinter);
        return dtoDisplay;
    }

    public PrettyPrinter withPropertyPrinter(PropertyPrinter printer) {
        this.propertyPrinters.add(0, printer);
        return this;
    }

    public PrettyPrinter withPropertyHeaderPrinter(PropertyHeaderPrinter printer) {
        this.propertyHeaderPrinters.add(0, printer);
        return this;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            UI ui = UI.getCurrent();
            this.locale = ui != null ? ui.getLocale() : Locale.getDefault();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private static boolean isStringOrSimpleWrapper(Class<?> type) {
        return type == String.class || type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class;
    }

    static {
        _defaultPropertyPrinters.add(new PrimitivePrinter());
        _defaultPropertyPrinters.add(new EnumPrinter());
        _defaultPropertyPrinters.add(new RecordTypePrinter());
        _defaultPropertyPrinters.add(new CollectionPropertyPrinter());
        _defaultPropertyPrinters.add(new ObjectPrinter());
    }

    private static class PrimitivePrinter
    implements PropertyPrinter {
        private PrimitivePrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            JavaType primaryType = ctx.beanPropertyDefinition().getPrimaryType();
            if (primaryType.isPrimitive() || PrettyPrinter.isStringOrSimpleWrapper(primaryType.getRawClass())) {
                Object propertyValue = ctx.getPropertyValue();
                if (propertyValue instanceof Number) {
                    Number number = (Number)propertyValue;
                    Locale locale = ctx.getLocale();
                    propertyValue = NumberFormat.getInstance(locale).format(propertyValue);
                }
                return new Span(String.valueOf(propertyValue));
            }
            return null;
        }
    }

    private static class EnumPrinter
    implements PropertyPrinter {
        private EnumPrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            if (ctx.beanPropertyDefinition().getPrimaryType().isEnumType() || ctx.beanPropertyDefinition().getPrimaryType().isEnumImplType()) {
                return new VCode(String.valueOf(ctx.getPropertyValue()));
            }
            return null;
        }
    }

    private static class RecordTypePrinter
    implements PropertyPrinter {
        private RecordTypePrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            if (ctx.beanPropertyDefinition().getPrimaryType().isRecordType()) {
                ValueContext propertyContext = ctx.asValueContext();
                String header = propertyContext.toShortString();
                return new VDetails(header, (SerializableSupplier<Component>)(SerializableSupplier & Serializable)() -> propertyContext.getPrettyPrinter().printToVaadin(propertyContext));
            }
            return null;
        }
    }

    private static class CollectionPropertyPrinter
    implements PropertyPrinter {
        private CollectionPropertyPrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            JavaType primaryType = ctx.beanPropertyDefinition().getPrimaryType();
            if (primaryType instanceof CollectionLikeType || primaryType instanceof ArrayType) {
                JavaType contentType = primaryType.getContentType();
                BasicBeanDescription contentTypeBbd = (BasicBeanDescription)jack._deserializationContext().introspectBeanDescription(contentType);
                List properties = contentTypeBbd.findProperties();
                Object collection = ctx.getPropertyValue();
                if (collection == null) {
                    return new Paragraph("null");
                }
                Class<?> collectionClass = collection.getClass();
                if (properties.isEmpty()) {
                    Object str;
                    if (collectionClass.isArray()) {
                        TypeDescriptor.OfField aClass = collectionClass.componentType();
                        if (((Class)aClass).isPrimitive()) {
                            int length = Array.getLength(collection);
                            String simpleName = collectionClass.getSimpleName();
                            str = simpleName;
                            if (length > 5) {
                                str = (String)str + ", legth:" + length;
                            }
                            str = (String)str + ": [";
                            int max = Math.min(length, 5);
                            for (int i = 0; i < max; ++i) {
                                str = (String)str + String.valueOf(Array.get(collection, i));
                                if (i == max - 1) continue;
                                str = (String)str + ", ";
                            }
                            if (length > 5) {
                                str = (String)str + "...";
                            }
                            str = (String)str + "]";
                        } else {
                            Object[] array = (Object[])collection;
                            str = Arrays.stream(array).map(Object::toString).collect(Collectors.joining(", "));
                        }
                    } else if (collection != null && collection instanceof Iterable) {
                        Iterable iterable = (Iterable)collection;
                        StringBuilder sb = new StringBuilder();
                        Iterator iterator = iterable.iterator();
                        while (iterator.hasNext()) {
                            sb.append(iterator.next().toString());
                            if (!iterator.hasNext()) continue;
                            sb.append(", ");
                        }
                        str = sb.toString();
                    } else {
                        str = String.valueOf(collection);
                    }
                    return new Paragraph((String)str);
                }
                Table subTable = new Table();
                TableRow header = subTable.addRow();
                contentTypeBbd.findProperties().forEach(subP -> header.addHeaderCell().setText(DtoDisplay.deCamelCased(subP.getName())));
                if (collectionClass.isArray()) {
                    Object[] array;
                    for (Object e2 : array = (Object[])collection) {
                        TableRow subTableRow = subTable.addRow();
                        properties.forEach(subP -> {
                            Object value = subP.getGetter().getValue(e2);
                            subTableRow.addCells(String.valueOf(value));
                        });
                    }
                } else if (collection instanceof Iterable) {
                    Iterable iterable = (Iterable)collection;
                    try {
                        iterable.forEach(e -> {
                            TableRow subTableRow = subTable.addRow();
                            contentTypeBbd.findProperties().forEach(subP -> {
                                try {
                                    Object value = subP.getAccessor().getValue(e);
                                    subTableRow.addCells(String.valueOf(value));
                                }
                                catch (Exception e1) {
                                    if (e1.getMessage().contains("failed to lazily")) {
                                        subTableRow.addCells("[Hbn proxy]");
                                    }
                                    throw e1;
                                }
                            });
                        });
                    }
                    catch (Exception e1) {
                        if (e1.getMessage().contains("failed to lazily")) {
                            subTable.addRow().addCells("[Hbn proxy]");
                        }
                        throw e1;
                    }
                }
                return subTable;
            }
            return null;
        }
    }

    private static class ObjectPrinter
    implements PropertyPrinter {
        private ObjectPrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            ValueContext propCtx = ctx.asValueContext();
            String header = propCtx.toShortString();
            return new VDetails(header, (SerializableSupplier<Component>)(SerializableSupplier & Serializable)() -> propCtx.getPrettyPrinter().printToVaadin(propCtx));
        }
    }
}

