/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.element.svg;

import in.virit.color.Color;
import org.vaadin.firitin.element.svg.ClipPathElement;
import org.vaadin.firitin.element.svg.LinearGradientElement;
import org.vaadin.firitin.element.svg.MaskElement;
import org.vaadin.firitin.element.svg.PatternElement;
import org.vaadin.firitin.element.svg.RadialGradientElement;
import org.vaadin.firitin.element.svg.SvgElement;

public class SvgGraphicsElement
extends SvgElement {
    private static int idCounter = 0;

    public SvgGraphicsElement(String tag) {
        super(tag);
    }

    public <T extends SvgGraphicsElement> T fill(Color color) {
        this.setWriteOnlyAttribute("fill", color.toString());
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T fill(String fill) {
        this.setWriteOnlyAttribute("fill", fill);
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T fillRW(Color color) {
        this.setAttribute("fill", color.toString());
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T fillRW(String fill) {
        this.setAttribute("fill", fill);
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T noFill() {
        this.setWriteOnlyAttribute("fill", "none");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T noFillRW() {
        this.setAttribute("fill", "none");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T fillOpacity(double opacity) {
        this.setWriteOnlyAttribute("fill-opacity", String.valueOf(opacity));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T fillOpacityRW(double opacity) {
        this.setAttribute("fill-opacity", String.valueOf(opacity));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T stroke(Color color) {
        this.setWriteOnlyAttribute("stroke", color.toString());
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T stroke(String stroke) {
        this.setWriteOnlyAttribute("stroke", stroke);
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeRW(Color color) {
        this.setAttribute("stroke", color.toString());
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeRW(String stroke) {
        this.setAttribute("stroke", stroke);
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T noStroke() {
        this.setWriteOnlyAttribute("stroke", "none");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T noStrokeRW() {
        this.setAttribute("stroke", "none");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeWidth(double width) {
        this.setWriteOnlyAttribute("stroke-width", String.valueOf(width));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeWidth(String width) {
        this.setWriteOnlyAttribute("stroke-width", width);
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeWidthRW(double width) {
        this.setAttribute("stroke-width", String.valueOf(width));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeWidthRW(String width) {
        this.setAttribute("stroke-width", width);
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeOpacity(double opacity) {
        this.setWriteOnlyAttribute("stroke-opacity", String.valueOf(opacity));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeOpacityRW(double opacity) {
        this.setAttribute("stroke-opacity", String.valueOf(opacity));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeLinecap(LineCap lineCap) {
        this.setWriteOnlyAttribute("stroke-linecap", lineCap.toString());
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeLinecapRW(LineCap lineCap) {
        this.setAttribute("stroke-linecap", lineCap.toString());
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeLinejoin(LineJoin lineJoin) {
        this.setWriteOnlyAttribute("stroke-linejoin", lineJoin.toString());
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeLinejoinRW(LineJoin lineJoin) {
        this.setAttribute("stroke-linejoin", lineJoin.toString());
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeMiterlimit(double limit) {
        this.setWriteOnlyAttribute("stroke-miterlimit", String.valueOf(limit));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeMiterlimitRW(double limit) {
        this.setAttribute("stroke-miterlimit", String.valueOf(limit));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeDasharray(String dasharray) {
        this.setWriteOnlyAttribute("stroke-dasharray", dasharray);
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeDasharray(double ... values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(values[i]);
        }
        this.setWriteOnlyAttribute("stroke-dasharray", sb.toString());
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeDasharrayRW(String dasharray) {
        this.setAttribute("stroke-dasharray", dasharray);
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeDasharrayRW(double ... values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(values[i]);
        }
        this.setAttribute("stroke-dasharray", sb.toString());
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeDashoffset(double offset) {
        this.setWriteOnlyAttribute("stroke-dashoffset", String.valueOf(offset));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeDashoffsetRW(double offset) {
        this.setAttribute("stroke-dashoffset", String.valueOf(offset));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T opacity(double opacity) {
        this.setWriteOnlyAttribute("opacity", String.valueOf(opacity));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T opacityRW(double opacity) {
        this.setAttribute("opacity", String.valueOf(opacity));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T clipPath(ClipPathElement clipPath) {
        this.setWriteOnlyAttribute("clip-path", "url(#" + SvgGraphicsElement.ensureId(clipPath) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T clipPathRW(ClipPathElement clipPath) {
        this.setAttribute("clip-path", "url(#" + SvgGraphicsElement.ensureId(clipPath) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T mask(MaskElement mask) {
        this.setWriteOnlyAttribute("mask", "url(#" + SvgGraphicsElement.ensureId(mask) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T maskRW(MaskElement mask) {
        this.setAttribute("mask", "url(#" + SvgGraphicsElement.ensureId(mask) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T fill(LinearGradientElement gradient) {
        this.setWriteOnlyAttribute("fill", "url(#" + SvgGraphicsElement.ensureId(gradient) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T fillRW(LinearGradientElement gradient) {
        this.setAttribute("fill", "url(#" + SvgGraphicsElement.ensureId(gradient) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T fill(RadialGradientElement gradient) {
        this.setWriteOnlyAttribute("fill", "url(#" + SvgGraphicsElement.ensureId(gradient) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T fillRW(RadialGradientElement gradient) {
        this.setAttribute("fill", "url(#" + SvgGraphicsElement.ensureId(gradient) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T fill(PatternElement pattern) {
        this.setWriteOnlyAttribute("fill", "url(#" + SvgGraphicsElement.ensureId(pattern) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T fillRW(PatternElement pattern) {
        this.setAttribute("fill", "url(#" + SvgGraphicsElement.ensureId(pattern) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T stroke(LinearGradientElement gradient) {
        this.setWriteOnlyAttribute("stroke", "url(#" + SvgGraphicsElement.ensureId(gradient) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeRW(LinearGradientElement gradient) {
        this.setAttribute("stroke", "url(#" + SvgGraphicsElement.ensureId(gradient) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T stroke(RadialGradientElement gradient) {
        this.setWriteOnlyAttribute("stroke", "url(#" + SvgGraphicsElement.ensureId(gradient) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeRW(RadialGradientElement gradient) {
        this.setAttribute("stroke", "url(#" + SvgGraphicsElement.ensureId(gradient) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T stroke(PatternElement pattern) {
        this.setWriteOnlyAttribute("stroke", "url(#" + SvgGraphicsElement.ensureId(pattern) + ")");
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T strokeRW(PatternElement pattern) {
        this.setAttribute("stroke", "url(#" + SvgGraphicsElement.ensureId(pattern) + ")");
        return (T)((Object)this);
    }

    private static String ensureId(SvgElement element) {
        Object id = element.getAttribute("id");
        if (id == null || ((String)id).isEmpty()) {
            id = "svg-auto-" + ++idCounter;
            element.setAttribute("id", (String)id);
        }
        return id;
    }

    public <T extends SvgGraphicsElement> T transform(String transform) {
        this.setWriteOnlyAttribute("transform", transform);
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T transformRW(String transform) {
        this.setAttribute("transform", transform);
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T translate(double x, double y) {
        this.appendTransform("translate(%s,%s)".formatted(x, y));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T translateRW(double x, double y) {
        this.appendTransformRW("translate(%s,%s)".formatted(x, y));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T translateX(double x) {
        this.appendTransform("translate(%s,0)".formatted(x));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T translateXRW(double x) {
        this.appendTransformRW("translate(%s,0)".formatted(x));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T translateY(double y) {
        this.appendTransform("translate(0,%s)".formatted(y));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T translateYRW(double y) {
        this.appendTransformRW("translate(0,%s)".formatted(y));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T rotate(double angle) {
        this.appendTransform("rotate(%s)".formatted(angle));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T rotateRW(double angle) {
        this.appendTransformRW("rotate(%s)".formatted(angle));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T rotate(double angle, double cx, double cy) {
        this.appendTransform("rotate(%s,%s,%s)".formatted(angle, cx, cy));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T rotateRW(double angle, double cx, double cy) {
        this.appendTransformRW("rotate(%s,%s,%s)".formatted(angle, cx, cy));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T scale(double factor) {
        this.appendTransform("scale(%s)".formatted(factor));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T scaleRW(double factor) {
        this.appendTransformRW("scale(%s)".formatted(factor));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T scale(double sx, double sy) {
        this.appendTransform("scale(%s,%s)".formatted(sx, sy));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T scaleRW(double sx, double sy) {
        this.appendTransformRW("scale(%s,%s)".formatted(sx, sy));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T skewX(double angle) {
        this.appendTransform("skewX(%s)".formatted(angle));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T skewXRW(double angle) {
        this.appendTransformRW("skewX(%s)".formatted(angle));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T skewY(double angle) {
        this.appendTransform("skewY(%s)".formatted(angle));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T skewYRW(double angle) {
        this.appendTransformRW("skewY(%s)".formatted(angle));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T matrix(double a, double b, double c, double d, double e, double f) {
        this.appendTransform("matrix(%s,%s,%s,%s,%s,%s)".formatted(a, b, c, d, e, f));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T matrixRW(double a, double b, double c, double d, double e, double f) {
        this.appendTransformRW("matrix(%s,%s,%s,%s,%s,%s)".formatted(a, b, c, d, e, f));
        return (T)((Object)this);
    }

    public <T extends SvgGraphicsElement> T clearTransform() {
        this.removeAttribute("transform");
        return (T)((Object)this);
    }

    private void appendTransform(String transform) {
        String existing = this.getPendingOrAttribute("transform");
        if (existing == null || existing.isEmpty()) {
            this.setWriteOnlyAttribute("transform", transform);
        } else {
            this.setWriteOnlyAttribute("transform", existing + " " + transform);
        }
    }

    private void appendTransformRW(String transform) {
        String existing = this.getPendingOrAttribute("transform");
        if (existing == null || existing.isEmpty()) {
            this.setAttribute("transform", transform);
        } else {
            this.setAttribute("transform", existing + " " + transform);
        }
    }

    public static enum LineCap {
        BUTT("butt"),
        ROUND("round"),
        SQUARE("square");

        private final String value;

        private LineCap(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum LineJoin {
        MITER("miter"),
        ROUND("round"),
        BEVEL("bevel");

        private final String value;

        private LineJoin(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

