/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.vaadin.firitin.components.TreeItem;

@StyleSheet(value="context://frontend/org/vaadin/firitin/components/tree.css")
public class Tree<T>
extends Composite<VerticalLayout> {
    private static final long serialVersionUID = -927074586817131378L;
    private ItemLabelGenerator<T> itemLabelGenerator = (ItemLabelGenerator & Serializable)o -> o.toString();
    private ItemIconGenerator<T> itemIconGenerator;
    private ItemGenerator<T> itemGenerator = (ItemGenerator<Object> & Serializable)item -> {
        if (this.itemIconGenerator != null) {
            Component icon = this.itemIconGenerator.apply(item);
            Span textSpan = new Span(new Component[]{new Text(this.itemToString(item))});
            textSpan.getElement().getClassList().add((Object)"item-text");
            return new Span(new Component[]{icon, textSpan});
        }
        return new Span(this.itemToString(item));
    };
    private List<ItemDecorator<T>> itemDecorators = new ArrayList<ItemDecorator<T>>();
    private Set<SelectionListener<T>> selectionListeners = new LinkedHashSet<SelectionListener<T>>();
    private HashMap<T, TreeItem> domainObjectToTreeItem = new HashMap();
    private TreeItem selectedItem;

    public Tree() {
        this.getElement().getClassList().add((Object)"viritin-tree");
        ((VerticalLayout)this.getContent()).setMargin(false);
        ((VerticalLayout)this.getContent()).setSpacing(false);
    }

    private String itemToString(T item) {
        return this.itemLabelGenerator.apply(item);
    }

    public void setItems(List<? extends T> rootNodes, ChildrenProvider<T> childrenProvider) {
        for (T item : rootNodes) {
            TreeItem treeItem = this.createTreeItem(item);
            ((VerticalLayout)this.getContent()).add(new Component[]{treeItem});
            this.fillTree(childrenProvider, item, treeItem);
        }
    }

    public void setItems(T rootNode, ChildrenProvider<T> childrenProvider) {
        this.setItems((T)Arrays.asList(rootNode), childrenProvider);
    }

    public void setItems(List<? extends T> roots, ChildrenProvider<? extends T> ... providersForNextLevels) {
        for (T item : roots) {
            TreeItem treeItem = this.createTreeItem(item);
            ((VerticalLayout)this.getContent()).add(new Component[]{treeItem});
            this.fillWithProviders(0, item, treeItem, providersForNextLevels);
        }
    }

    public void setItems(T root, ChildrenProvider<? extends T> ... providersForNextLevels) {
        this.setItems((T)Arrays.asList(root), providersForNextLevels);
    }

    protected void fillWithProviders(int level, T item, TreeItem treeItem, ChildrenProvider ... providers) {
        try {
            List children = providers[level].getChildren(item);
            if (children != null && !children.isEmpty()) {
                for (Object t : children) {
                    TreeItem child = this.createTreeItem(t);
                    treeItem.addChild(child);
                    this.fillWithProviders(level + 1, t, child, providers);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Deprecated
    public void setItems(TreeData<T> treeData, ChildrenProvider<T> childrenProvider) {
        ((VerticalLayout)this.getContent()).removeAll();
        this.setItems((T)treeData.getRootItems(), childrenProvider);
    }

    protected TreeItem createTreeItem(T item) {
        TreeItem treeItem = new TreeItem(this.itemGenerator.apply(item));
        this.domainObjectToTreeItem.put(item, treeItem);
        treeItem.addClickListener((ComponentEventListener<ClickEvent<TreeItem>>)(ComponentEventListener & Serializable)e -> {
            if (this.selectedItem != null) {
                this.selectedItem.setSelected(false);
            }
            this.selectedItem = treeItem;
            this.selectedItem.setSelected(true);
            this.selectionListeners.forEach(l -> l.selected(item, treeItem));
        });
        this.itemDecorators.forEach(d -> d.accept(item, treeItem));
        return treeItem;
    }

    protected void fillTree(ChildrenProvider<T> childrenProvider, T item, TreeItem treeItem) {
        List children = childrenProvider.getChildren(item);
        if (children != null && !children.isEmpty()) {
            treeItem.setPopulateSubreeHandler(() -> {
                for (Object t : children) {
                    TreeItem child = this.createTreeItem(t);
                    treeItem.addChild(child);
                    this.fillTree(childrenProvider, t, child);
                }
            });
        }
    }

    public void addItemDecorator(ItemDecorator<T> decorator) {
        this.itemDecorators.add(decorator);
    }

    public void removeItemDecorator(ItemDecorator<T> decorator) {
        this.itemDecorators.remove(decorator);
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        this.itemLabelGenerator = itemLabelGenerator;
    }

    public void setItemIconGenerator(ItemIconGenerator<T> itemIconGenerator) {
        this.itemIconGenerator = itemIconGenerator;
    }

    public void setItemGenerator(ItemGenerator<T> itemGenerator) {
        this.itemGenerator = itemGenerator;
    }

    public void addSelectionListener(SelectionListener<T> listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener<T> listener) {
        this.selectionListeners.remove(listener);
    }

    public void showChildren(T item) {
        this.domainObjectToTreeItem.get(item).showChildren();
    }

    public void showChildrenRecursively(T item) {
        this.domainObjectToTreeItem.get(item).showChildrenRecursively();
    }

    public void hideChildren(T item) {
        this.domainObjectToTreeItem.get(item).closeChildren();
    }

    public void moveChild(T parent, List<T> items, int index, boolean up) {
        int newIndex;
        int n = newIndex = up ? index - 1 : index + 1;
        if (newIndex >= 0 && newIndex < items.size()) {
            List<TreeItem> treeItems = items.stream().map(i -> this.domainObjectToTreeItem.get(i)).collect(Collectors.toList());
            if (parent != null) {
                TreeItem parentTreeItem = this.domainObjectToTreeItem.get(parent);
                treeItems.forEach(ti -> parentTreeItem.removeChild((TreeItem)((Object)ti)));
                Collections.swap(treeItems, index, newIndex);
                treeItems.forEach(ti -> parentTreeItem.addChild((TreeItem)((Object)ti)));
            } else {
                treeItems.forEach(ti -> ((VerticalLayout)this.getContent()).remove(new Component[]{ti}));
                Collections.swap(treeItems, index, newIndex);
                treeItems.forEach(ti -> ((VerticalLayout)this.getContent()).add(new Component[]{ti}));
            }
        }
    }

    public void addChild(T parent, T item) {
        if (parent == null) {
            TreeItem treeItem = this.createTreeItem(item);
            ((VerticalLayout)this.getContent()).add(new Component[]{treeItem});
        } else {
            TreeItem parentTreeItem = this.domainObjectToTreeItem.get(parent);
            TreeItem treeItem = this.createTreeItem(item);
            parentTreeItem.addChild(treeItem);
        }
    }

    public void removeChild(T parent, T item) {
        TreeItem treeItem = this.domainObjectToTreeItem.get(item);
        if (parent == null) {
            ((VerticalLayout)this.getContent()).remove(new Component[]{treeItem});
        } else {
            TreeItem parentTreeItem = this.domainObjectToTreeItem.get(parent);
            parentTreeItem.removeChild(treeItem);
        }
    }

    public void editChild(T item) {
        TreeItem treeItem = this.domainObjectToTreeItem.get(item);
        Span nodeContent = (Span)treeItem.getNodeContent();
        Optional<Component> optIcon = treeItem.getNodeContent().getChildren().filter(c -> c instanceof Icon).findFirst();
        Optional<Component> optSpan = treeItem.getNodeContent().getChildren().filter(c -> c instanceof Span).findFirst();
        if (optIcon.isPresent() && optSpan.isPresent()) {
            Icon icon = (Icon)optIcon.get();
            Span span = (Span)optSpan.get();
            nodeContent.remove(new Component[]{icon});
            nodeContent.remove(new Component[]{span});
            span.getChildren().filter(cc -> cc instanceof Text).findFirst().ifPresent(cc -> ((Text)cc).setText(this.itemLabelGenerator.apply(item)));
            nodeContent.add(new Component[]{this.itemIconGenerator.apply(item)});
            nodeContent.add(new Component[]{span});
        }
    }

    public void styleChild(T item, String styleName, String styleValue) {
        TreeItem treeItem = this.domainObjectToTreeItem.get(item);
        treeItem.getNodeContent().getChildren().filter(c -> c instanceof Span).findFirst().ifPresent(c -> ((Span)c).getStyle().set(styleName, styleValue));
    }

    public TreeItem scrollItemToView(T item) {
        TreeItem treeItem = this.domainObjectToTreeItem.get(item);
        treeItem.getElement().executeJs("this.scrollIntoView()", new Object[0]);
        return treeItem;
    }

    public void selectItem(T item, boolean selected) {
        TreeItem treeItem = this.domainObjectToTreeItem.get(item);
        if (selected) {
            if (this.selectedItem != null) {
                this.selectedItem.setSelected(false);
            }
            this.selectedItem = treeItem;
            this.selectedItem.setSelected(true);
            this.selectionListeners.forEach(l -> l.selected(item, treeItem));
        } else if (this.selectedItem == treeItem) {
            this.selectedItem.setSelected(false);
            this.selectedItem = null;
        }
    }

    public void deselectAllItems() {
        this.selectedItem = null;
        this.domainObjectToTreeItem.values().forEach(treeItem -> treeItem.setSelected(false));
    }

    @FunctionalInterface
    public static interface ItemGenerator<T>
    extends SerializableFunction<T, Component> {
        public Component apply(T var1);
    }

    @FunctionalInterface
    public static interface ChildrenProvider<T> {
        public List getChildren(T var1);
    }

    @FunctionalInterface
    public static interface ItemIconGenerator<T>
    extends SerializableFunction<T, Component> {
        public Component apply(T var1);
    }

    @FunctionalInterface
    public static interface SelectionListener<T>
    extends Serializable {
        public void selected(T var1, TreeItem var2);
    }

    public static interface ItemDecorator<T>
    extends BiConsumer<T, TreeItem>,
    Serializable {
    }
}

