/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.util.fullscreen;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.vaadin.firitin.util.fullscreen.FullscreenChangeEvent;

public class FullScreen {
    public static void requestFullscreen() {
        UI.getCurrent().getPage().executeJs("    if(document.__viritin_restoreOriginalParent) {\n        document.__viritin_resetView();\n    }\n    document.documentElement.requestFullscreen();\n", new Object[0]);
    }

    public static void requestFullscreen(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        if (!component.isAttached()) {
            throw new IllegalStateException("Component must be attached to the UI to request full screen");
        }
        UI.getCurrent().getPage().executeJs("if(document.__viritin_restoreOriginalParent) {\n    document.__viritin_resetView();\n}\nif(document.fullscreenEnabled === true) {\n    const wrapper = $1;\n    const element = $0;\n    const placeholder = document.createComment(\"placeholder\");\n    const originalParent = element.parentNode;\n    element.parentNode.insertBefore(placeholder, element);\n\n    wrapper.appendChild(element);\n    wrapper.firstChild.style.display = \"none\";\n    document.documentElement.requestFullscreen();\n\n    document.__viritin_resetView = () => {\n        originalParent.appendChild(element);\n        placeholder.remove();\n        wrapper.firstChild.style.display = \"\";\n        document.documentElement.removeEventListener(\"fullscreenchange\", document.__viritin_restoreOriginalParent);\n        document.__viritin_restoreOriginalParent = null;\n        document.__viritin_resetView = null;\n    };\n\n    document.__viritin_restoreOriginalParent = evt => {\n        if(!document.fullscreenElement) {\n            document.__viritin_resetView();\n        }\n    };\n    document.documentElement.addEventListener(\"fullscreenchange\", document.__viritin_restoreOriginalParent);\n}\n", new Object[]{component.getElement(), UI.getCurrent().wrapperElement});
    }

    @Deprecated(forRemoval=false)
    public static void requestFullscreenRaw(Element el) {
        UI.getCurrent().getPage().executeJs("    if(document.__viritin_restoreOriginalParent) {\n        document.__viritin_resetView();\n    }\n    const element = $0;\n    element.requestFullscreen();\n", new Object[]{el});
    }

    @Deprecated(forRemoval=false)
    public static void requestFullscreenRaw(Component component) {
        FullScreen.requestFullscreenRaw(component.getElement());
    }

    public static void exitFullscreen() {
        UI.getCurrent().getPage().executeJs("document.exitFullscreen();\n", new Object[0]);
    }

    public static CompletableFuture<Boolean> isFullscreen() {
        return UI.getCurrent().getPage().executeJs("return document.fullscreenElement !== null;\n", new Object[0]).toCompletableFuture(Boolean.class);
    }

    public static CompletableFuture<Boolean> fullScreenAvailable() {
        return UI.getCurrent().getPage().executeJs("return document.fullscreenEnabled === true;\n", new Object[0]).toCompletableFuture(Boolean.class);
    }

    public static Registration addFullscreenChangeListener(ComponentEventListener<FullscreenChangeEvent> listener) {
        UI ui = UI.getCurrent();
        ui.getPage().executeJs("    if(!document.__viritin_fullscreen_change_listener) {\n        document.addEventListener('fullscreenchange', () => {\n            const isFullscreen = document.fullscreenElement !== null;\n            document.body.dispatchEvent(new CustomEvent('viritin-fullscreenchange', {\n                detail: isFullscreen\n            }));\n        });\n    }\n    document.__viritin_fullscreen_change_listener = true;\n", new Object[0]);
        return ui.getElement().addEventListener("viritin-fullscreenchange", (DomEventListener & Serializable)event -> {
            boolean isFullscreen = event.getEventData().get("event.detail").asBoolean();
            listener.onComponentEvent((ComponentEvent)new FullscreenChangeEvent(ui, isFullscreen));
        }).addEventData("event.detail");
    }
}

