/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.internal.AbstractFieldSupport;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceWriter;
import com.vaadin.flow.shared.Registration;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;

@StyleSheet(value="context://frontend/org/vaadin/firitin/bytearrayuploadfield.css")
public class ByteArrayUploadField
extends Composite<Div>
implements HasValue<AbstractField.ComponentValueChangeEvent<ByteArrayUploadField, byte[]>, byte[]> {
    private static final long serialVersionUID = -188233227963143771L;
    private byte[] value;
    private ByteArrayOutputStream bout;
    private final AbstractFieldSupport<ByteArrayUploadField, byte[]> fieldSupport;
    private Upload upload = new Upload();
    private Receiver receiver = new Receiver(){
        private static final long serialVersionUID = 5809889357612029151L;

        public OutputStream receiveUpload(String filename, String mimetype) {
            ByteArrayUploadField.this.uploadedFileName = filename;
            ByteArrayUploadField.this.bout = new ByteArrayOutputStream();
            return ByteArrayUploadField.this.bout;
        }
    };
    private Anchor presentation;
    private String downloadFileName;
    private String fileDownloadText = "download ( %s )";
    private String uploadedFileName;

    public ByteArrayUploadField() {
        ((Div)this.getContent()).addClassName("viritin-uploadfield");
        this.upload.setReceiver(this.receiver);
        this.upload.setMaxFiles(1);
        this.upload.setDropAllowed(false);
        this.upload.addSucceededListener((ComponentEventListener & Serializable)e -> {
            this.setValue(this.bout.toByteArray());
            this.upload.clearFileList();
        });
        ((Div)this.getContent()).add(new Component[]{this.upload});
        this.fieldSupport = this.createFieldSupport(new byte[0]);
    }

    private AbstractFieldSupport<ByteArrayUploadField, byte[]> createFieldSupport(byte[] defaultValue) {
        return new AbstractFieldSupport((Component)this, (Object)defaultValue, this::valueEquals, this::setPresentatinoValue);
    }

    private boolean valueEquals(byte[] v1, byte[] v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    private void setPresentatinoValue(byte[] value) {
        this.value = value;
        this.updatePresentation();
    }

    private void updatePresentation() {
        if (this.presentation == null) {
            this.presentation = new Anchor();
            this.presentation.setTitle("Download as file");
            ((Div)this.getContent()).add(new Component[]{this.presentation});
        }
        if (this.value == null) {
            this.presentation.setVisible(false);
        } else {
            this.presentation.setVisible(true);
            this.presentation.removeAll();
            Icon icon = VaadinIcon.DOWNLOAD_ALT.create();
            icon.addClassName("--lumo-icon-size-s");
            this.presentation.add(new Component[]{icon});
            this.presentation.add(new Component[]{new Span(String.format(this.getFileDownloadText(), ByteArrayUploadField.readableFileSize(this.value.length)))});
            String filename = this.getFileNameForDownload();
            this.presentation.getElement().setAttribute("download", filename);
            this.presentation.setHref((AbstractStreamResource)new StreamResource(filename, (StreamResourceWriter & Serializable)(stream, session) -> stream.write(this.value)));
        }
    }

    private String getFileNameForDownload() {
        return this.getDownloadFileName() == null ? (this.uploadedFileName == null ? "file" : this.uploadedFileName) : this.getDownloadFileName();
    }

    public String getDownloadFileName() {
        return this.downloadFileName;
    }

    public void setDownloadFileName(String downloadFileName) {
        this.downloadFileName = downloadFileName;
    }

    public void setFileDownloadText(String fileDownloadText) {
        this.fileDownloadText = fileDownloadText;
    }

    public String getFileDownloadText() {
        return this.fileDownloadText;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<ByteArrayUploadField, byte[]>> listener) {
        return this.fieldSupport.addValueChangeListener(listener);
    }

    public void setReadOnly(boolean bln) {
        this.upload.setVisible(!bln);
    }

    public boolean isReadOnly() {
        return !this.upload.isVisible();
    }

    public void setRequiredIndicatorVisible(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isRequiredIndicatorVisible() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setValue(byte[] v) {
        this.fieldSupport.setValue((Object)v);
    }

    public byte[] getValue() {
        return (byte[])this.fieldSupport.getValue();
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public Upload getUpload() {
        return this.upload;
    }

    public void setUploadCaption(String uploadCaption) {
        this.getUpload().setUploadButton((Component)new Button(uploadCaption));
    }
}

