/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.devicemotion;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.vaadin.firitin.devicemotion.DeviceMotionEvent;
import org.vaadin.firitin.devicemotion.DeviceSensorPermissions;

public class DeviceMotion {
    static final int DEFAULT_THROTTLE_TIMEOUT = 1000;
    private DomListenerRegistration motionListener;
    private UI ui;

    public static DeviceMotion listen(MotionListener listener) {
        UI ui = UI.getCurrent();
        return DeviceMotion.listen(ui, listener);
    }

    public static Button requestPermissionAndListen(Button button, MotionListener listener, DeviceMotionHandler handler, Runnable onError) {
        DeviceMotion[] holder = new DeviceMotion[1];
        DeviceSensorPermissions.configurePermissionRequest(button, DeviceSensorPermissions.SensorType.MOTION, () -> {
            holder[0] = DeviceMotion.listen(listener);
            if (handler != null) {
                handler.onDeviceMotionCreated(holder[0]);
            }
        }, onError);
        button.addClickListener((ComponentEventListener & Serializable)e -> {
            if (holder[0] != null) {
                holder[0].cancel();
                holder[0] = null;
            }
        });
        return button;
    }

    public static Button requestPermissionAndListen(Button button, MotionListener listener, Runnable onError) {
        return DeviceMotion.requestPermissionAndListen(button, listener, null, onError);
    }

    public static DeviceMotion listen(UI ui, MotionListener listener) {
        DeviceMotion deviceMotion = new DeviceMotion();
        deviceMotion.ui = ui;
        Element eventSourceElement = ui.getElement();
        Component activeModalComponent = ui.getInternals().getActiveModalComponent();
        if (activeModalComponent != null) {
            eventSourceElement = activeModalComponent.getElement();
        }
        deviceMotion.motionListener = eventSourceElement.addEventListener("devicemotionevent", (DomEventListener & Serializable)e -> {
            try {
                DeviceMotionEvent motionEvent = (DeviceMotionEvent)e.getEventDetail(DeviceMotionEvent.class);
                listener.deviceMotionUpdate(motionEvent);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).addEventDetail().throttle(1000);
        deviceMotion.motionListener.addEventData("event.detail");
        eventSourceElement.executeJs("var el = $0;\nwindow.addEventListener('devicemotion', function(e) {\n    const event = new CustomEvent('devicemotionevent', {\n        detail: JSON.stringify({\n            acceleration: e.acceleration ? {\n                x: e.acceleration.x,\n                y: e.acceleration.y,\n                z: e.acceleration.z\n            } : null,\n            accelerationIncludingGravity: e.accelerationIncludingGravity ? {\n                x: e.accelerationIncludingGravity.x,\n                y: e.accelerationIncludingGravity.y,\n                z: e.accelerationIncludingGravity.z\n            } : null,\n            rotationRate: e.rotationRate ? {\n                alpha: e.rotationRate.alpha,\n                beta: e.rotationRate.beta,\n                gamma: e.rotationRate.gamma\n            } : null,\n            interval: e.interval\n        })\n    });\n    el.dispatchEvent(event);\n});\n", new Object[]{eventSourceElement});
        return deviceMotion;
    }

    public void cancel() {
        this.clearListener();
    }

    private void clearListener() {
        if (this.motionListener != null) {
            this.motionListener.remove();
            this.motionListener = null;
        }
    }

    public void throttleEvents(int milliseconds) {
        this.motionListener.throttle(milliseconds);
    }

    public static void requestPermission(Runnable onSuccess, Runnable onError) {
        UI ui = UI.getCurrent();
        DeviceMotion.requestPermission(ui, onSuccess, onError);
    }

    public static void requestPermission(UI ui, Runnable onSuccess, Runnable onError) {
        ui.getPage().executeJs("// Check if permission API exists (iOS 13+)\nif (typeof DeviceMotionEvent !== 'undefined' &&\n    typeof DeviceMotionEvent.requestPermission === 'function') {\n    return DeviceMotionEvent.requestPermission()\n        .then(permissionState => {\n            return permissionState;\n        })\n        .catch(error => {\n            return 'denied';\n        });\n} else {\n    // Permission not required on this platform\n    return 'not_required';\n}\n", new Object[0]).then(String.class, (SerializableConsumer & Serializable)result -> {
            if ("granted".equals(result) || "not_required".equals(result)) {
                onSuccess.run();
            } else {
                onError.run();
            }
        }, (SerializableConsumer & Serializable)error -> onError.run());
    }

    public static CompletableFuture<Boolean> isPermissionRequired() {
        return DeviceMotion.isPermissionRequired(UI.getCurrent());
    }

    public static CompletableFuture<Boolean> isPermissionRequired(UI ui) {
        return ui.getPage().executeJs("return typeof DeviceMotionEvent !== 'undefined' &&\n       typeof DeviceMotionEvent.requestPermission === 'function';\n", new Object[0]).toCompletableFuture(Boolean.class);
    }

    public static CompletableFuture<Permission> checkPermission() {
        return DeviceMotion.checkPermission(UI.getCurrent());
    }

    public static CompletableFuture<Permission> checkPermission(UI ui) {
        return ui.getPage().executeJs("if (typeof DeviceMotionEvent !== 'undefined' &&\n    typeof DeviceMotionEvent.requestPermission === 'function') {\n    // iOS 13+ - check permission state (note: can't actually check state before requesting)\n    return 'default';\n} else {\n    return 'not_required';\n}\n", new Object[0]).toCompletableFuture(String.class).thenApply(str -> Permission.valueOf(str.toUpperCase()));
    }

    public static interface MotionListener {
        public void deviceMotionUpdate(DeviceMotionEvent var1);
    }

    @FunctionalInterface
    public static interface DeviceMotionHandler {
        public void onDeviceMotionCreated(DeviceMotion var1);
    }

    public static enum Permission {
        GRANTED,
        DENIED,
        DEFAULT,
        NOT_REQUIRED;

    }
}

