/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.checkbox;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.customfield.CustomField;
import java.io.Serializable;

public class TriStateCheckbox
extends CustomField<Boolean> {
    private final Checkbox impl = new Checkbox();
    boolean indeterminate = true;

    public TriStateCheckbox() {
        this.impl.setIndeterminate(true);
        this.impl.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (!this.indeterminate && !((Boolean)event.getOldValue()).booleanValue() && event.isFromClient()) {
                this.impl.setValue((Object)false);
                this.impl.setIndeterminate(true);
                this.indeterminate = true;
            } else {
                this.indeterminate = false;
            }
        });
        this.add(new Component[]{this.impl});
    }

    public TriStateCheckbox(String label) {
        this();
        this.setLabel(label);
    }

    protected Boolean generateModelValue() {
        if (this.indeterminate) {
            return null;
        }
        return (Boolean)this.impl.getValue();
    }

    protected void setPresentationValue(Boolean value) {
        if (value == null) {
            this.impl.setIndeterminate(true);
            this.indeterminate = true;
        } else {
            this.impl.setIndeterminate(false);
            this.impl.setValue((Object)value);
            this.indeterminate = false;
        }
    }
}

