/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields.internalhtmltable;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.vaadin.firitin.fields.internalhtmltable.ElementHelper;
import org.vaadin.firitin.fields.internalhtmltable.TableColumn;

@Tag(value="colgroup")
public class TableColumnGroup
extends Component {
    public TableColumn addColumn() {
        TableColumn column = new TableColumn();
        this.addColumns(column);
        return column;
    }

    public void addColumns(TableColumn ... columns) {
        this.getElement().appendChild(ElementHelper.asElements(columns));
    }

    public TableColumn[] addColumns(int columns) {
        if (columns < 1) {
            throw new IllegalArgumentException("Columns must be greater than 0");
        }
        TableColumn[] colObjects = (TableColumn[])IntStream.range(0, columns).mapToObj(i -> new TableColumn()).toArray(TableColumn[]::new);
        this.addColumns(colObjects);
        return colObjects;
    }

    public TableColumn insertColumn(int index) {
        TableColumn tableColumn = new TableColumn();
        this.insertColumns(index, tableColumn);
        return tableColumn;
    }

    public void insertColumns(int index, TableColumn ... columns) {
        this.getElement().insertChild(index, ElementHelper.asElements(columns));
    }

    public void setColumn(int index, TableColumn column) {
        this.replaceColumn(index, column);
    }

    public void replaceColumn(int index, TableColumn column) {
        this.getElement().setChild(index, column.getElement());
    }

    public void removeColumn(int index) {
        TableColumnGroup tableColumnGroup = this;
        this.getColumn(index).ifPresent(xva$0 -> tableColumnGroup.removeColumns((TableColumn)((Object)xva$0)));
    }

    public void removeColumns(TableColumn ... columns) {
        this.getElement().removeChild(ElementHelper.asElements(columns));
    }

    public void removeAllColumns() {
        this.removeColumns((TableColumn[])this.streamColumns().toArray(TableColumn[]::new));
    }

    public List<TableColumn> getColumns() {
        return this.streamColumns().collect(Collectors.toList());
    }

    public Optional<TableColumn> getColumn(int index) {
        return this.streamColumns().skip(index).findFirst();
    }

    public Stream<TableColumn> streamColumns() {
        return this.getChildren().filter(c -> c instanceof TableColumn).map(c -> (TableColumn)((Object)c));
    }
}

