/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields.internalhtmltable;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.dom.Element;
import java.util.stream.Stream;
import org.vaadin.firitin.fields.internalhtmltable.TableBody;
import org.vaadin.firitin.fields.internalhtmltable.TableCaption;
import org.vaadin.firitin.fields.internalhtmltable.TableColumnGroup;
import org.vaadin.firitin.fields.internalhtmltable.TableFoot;
import org.vaadin.firitin.fields.internalhtmltable.TableHead;
import org.vaadin.firitin.fields.internalhtmltable.TableRow;
import org.vaadin.firitin.fields.internalhtmltable.TableRowContainer;

@Tag(value="table")
public class Table
extends HtmlComponent
implements TableRowContainer {
    private TableCaption caption;
    private TableColumnGroup columnGroup;
    private TableHead head;
    private TableBody body;
    private TableFoot foot;

    public TableCaption getCaption() {
        if (this.caption == null) {
            this.caption = this.insertIndexedChild(new TableCaption(), new Component[0]);
        }
        return this.caption;
    }

    public TableColumnGroup getColumnGroup() {
        if (this.columnGroup == null) {
            this.columnGroup = this.insertIndexedChild(new TableColumnGroup(), new Component[]{this.caption});
        }
        return this.columnGroup;
    }

    public TableHead getHead() {
        if (this.head == null) {
            this.head = this.insertIndexedChild(new TableHead(), new Component[]{this.caption, this.columnGroup});
        }
        return this.head;
    }

    public void removeHead() {
        if (this.head != null) {
            this.getElement().removeChild(new Element[]{this.head.getElement()});
        }
    }

    public void removeFoot() {
        if (this.foot != null) {
            this.getElement().removeChild(new Element[]{this.foot.getElement()});
        }
    }

    public void removeBody() {
        if (this.body != null) {
            this.getElement().removeChild(new Element[]{this.body.getElement()});
        }
    }

    public void removeCaption() {
        if (this.caption != null) {
            this.getElement().removeChild(new Element[]{this.caption.getElement()});
        }
    }

    public void removeColumnGroup() {
        if (this.columnGroup != null) {
            this.getElement().removeChild(new Element[]{this.columnGroup.getElement()});
        }
    }

    public TableBody getBody() {
        if (this.body == null) {
            this.body = this.insertIndexedChild(new TableBody(), new Component[]{this.caption, this.columnGroup, this.head});
            this.body.addRows((TableRow[])this.streamRows().toArray(TableRow[]::new));
        }
        return this.body;
    }

    public TableFoot getFoot() {
        if (this.foot == null) {
            this.foot = this.insertIndexedChild(new TableFoot(), new Component[]{this.caption, this.columnGroup, this.head, this.body});
        }
        return this.foot;
    }

    private int calculateIndex(Component ... predecessors) {
        int index = 0;
        for (Component predecessor : predecessors) {
            if (predecessor == null) continue;
            ++index;
        }
        return index;
    }

    private <T extends Component> T insertIndexedChild(T childToAdd, Component ... predecessors) {
        int index = this.calculateIndex(predecessors);
        this.getElement().insertChild(index, new Element[]{childToAdd.getElement()});
        return childToAdd;
    }

    @Override
    public void addRows(TableRow ... rows) {
        if (this.body != null) {
            this.body.addRows(rows);
        } else {
            TableRowContainer.super.addRows(rows);
        }
    }

    @Override
    public void insertRows(int index, TableRow ... rows) {
        if (this.body != null) {
            this.body.insertRows(index, rows);
        } else {
            TableRowContainer.super.insertRows(index, rows);
        }
    }

    @Override
    public void replaceRow(int index, TableRow row) {
        if (this.body != null) {
            this.body.replaceRow(index, row);
        } else {
            TableRowContainer.super.replaceRow(index, row);
        }
    }

    @Override
    public void removeRows(TableRow ... rows) {
        if (this.body != null) {
            this.body.removeRows(rows);
        } else {
            TableRowContainer.super.removeRows(rows);
        }
    }

    @Override
    public Stream<TableRow> streamRows() {
        if (this.body != null) {
            return this.body.streamRows();
        }
        return TableRowContainer.super.streamRows();
    }

    @Override
    public TableRow addRow() {
        return TableRowContainer.super.addRow();
    }

    @Override
    public TableRow[] addRows(int rows) {
        return TableRowContainer.super.addRows(rows);
    }

    @Override
    public TableRow insertRow(int index) {
        return TableRowContainer.super.insertRow(index);
    }

    @Override
    public void setRow(int index, TableRow row) {
        TableRowContainer.super.setRow(index, row);
    }

    @Override
    public void removeAllRows() {
        TableRowContainer.super.removeAllRows();
    }

    @Override
    public void removeRow(int index) {
        TableRowContainer.super.removeRow(index);
    }
}

