/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasPlaceholder;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.data.value.ValueChangeMode;
import java.io.Serializable;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import org.vaadin.firitin.components.textfield.VTextField;

public class DurationField
extends CustomField<Duration>
implements HasPlaceholder {
    VTextField durationInput = new VTextField().withPlaceholder("hh:mm:ss");

    public DurationField() {
        this(null);
    }

    public DurationField(String label) {
        this.setLabel(label);
        this.durationInput.setWidth("8em");
        this.durationInput.addBlurListener((ComponentEventListener & Serializable)e -> {
            String str = this.durationInput.getValue();
            if (!this.durationInput.isInvalid()) {
                Duration duration = this.parseInput(this.durationInput.getValue());
                this.durationInput.setValue(this.formatToPresentation(duration));
            }
        });
        this.durationInput.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.isFromClient()) {
                this.updateValue();
            }
        });
        this.add(new Component[]{this.durationInput});
        this.setTooltipText("    Default formatting for duration: hh:mm:ss.\n    For quick input, if no separator typed in, until 100, interpreted an hour.\n    Then until 10000, hhmm. Also supports ISO-8601 style format for \"human compilers\": PnDTnHnMn.nS\n");
    }

    protected String formatToPresentation(Duration d) {
        return DurationField.defaultFormatToPresentation(d);
    }

    public static final String defaultFormatToPresentation(Duration d) {
        if (d == null) {
            return "";
        }
        long secs = d.get(ChronoUnit.SECONDS);
        boolean includeSeconds = secs % 60L != 0L;
        long hours = d.toHours();
        int minutes = d.toMinutesPart();
        int seconds = d.toSecondsPart();
        if (includeSeconds) {
            return String.format("%d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%d:%02d", hours, minutes);
    }

    protected Duration parseInput(String value) {
        return DurationField.parseInputDefault(value);
    }

    static final Duration parseInputDefault(String value) {
        try {
            return Duration.parse((CharSequence)value);
        }
        catch (DateTimeParseException e) {
            if (((String)value).contains(":")) {
                value = ((String)(value = ((String)value).replaceFirst(":", "H"))).contains(":") ? ((String)value).replaceFirst(":", "M") + "S" : (String)value + "M";
                value = "PT" + (String)value;
                try {
                    return Duration.parse((CharSequence)value);
                }
                catch (DateTimeParseException exception) {
                    return null;
                }
            }
            boolean numbersOnly = ((String)value).matches("[0-9]+");
            if (numbersOnly) {
                try {
                    if (((String)value).length() < 3) {
                        int hours = Integer.parseInt((String)value);
                        return Duration.ofHours(hours);
                    }
                    int firstMinute = ((String)value).length() - 2;
                    int minutes = Integer.parseInt(((String)value).substring(firstMinute));
                    int hours = Integer.parseInt(((String)value).substring(0, firstMinute));
                    return Duration.ofMinutes(minutes + hours * 60);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            return null;
        }
    }

    protected Duration generateModelValue() {
        String value = this.durationInput.getValue();
        Duration d = this.parseInput(value);
        this.durationInput.setInvalid(d == null && !value.isEmpty());
        return d;
    }

    protected void setPresentationValue(Duration newPresentationValue) {
        String presentation = this.formatToPresentation(newPresentationValue);
        this.durationInput.setValue(presentation);
    }

    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
        this.durationInput.setInvalid(invalid);
    }

    public void setPlaceholder(String placeholder) {
        this.durationInput.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.durationInput.getPlaceholder();
    }

    public DurationField withValueChangeMode(ValueChangeMode valueChangeMode) {
        this.durationInput.setValueChangeMode(valueChangeMode);
        return this;
    }

    public DurationField withValueChangeTimeout(int valueChangeTimeout) {
        this.durationInput.setValueChangeTimeout(valueChangeTimeout);
        return this;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.durationInput.setValueChangeMode(valueChangeMode);
    }

    public ValueChangeMode getValueChangeMode() {
        return this.durationInput.getValueChangeMode();
    }

    public void setValueChangeTimeout(int valueChangeTimeout) {
        this.durationInput.setValueChangeTimeout(valueChangeTimeout);
    }

    public int getValueChangeTimeout() {
        return this.durationInput.getValueChangeTimeout();
    }
}

