/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.devicemotion;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.vaadin.firitin.devicemotion.DeviceOrientationEvent;
import org.vaadin.firitin.devicemotion.DeviceSensorPermissions;

public class DeviceOrientation {
    private DomListenerRegistration orientationListener;
    private UI ui;

    public static DeviceOrientation listen(OrientationListener listener) {
        return DeviceOrientation.listen(listener, false);
    }

    public static Button requestPermissionAndListen(Button button, OrientationListener listener, Runnable onError) {
        return DeviceOrientation.requestPermissionAndListen(button, listener, false, onError);
    }

    public static Button requestPermissionAndListen(Button button, OrientationListener listener, boolean absolute, Runnable onError) {
        DeviceOrientation[] holder = new DeviceOrientation[1];
        DeviceSensorPermissions.configurePermissionRequest(button, DeviceSensorPermissions.SensorType.ORIENTATION, () -> {
            holder[0] = DeviceOrientation.listen(listener, absolute);
            button.setText("Stop Listening");
        }, onError);
        button.addClickListener((ComponentEventListener & Serializable)e -> {
            if (holder[0] != null) {
                holder[0].cancel();
                holder[0] = null;
                button.setText("Start Listening");
            }
        });
        return button;
    }

    public static DeviceOrientation listen(OrientationListener listener, boolean absolute) {
        UI ui = UI.getCurrent();
        return DeviceOrientation.listen(ui, listener, absolute);
    }

    public static DeviceOrientation listen(UI ui, OrientationListener listener, boolean absolute) {
        DeviceOrientation deviceOrientation = new DeviceOrientation();
        deviceOrientation.ui = ui;
        Element eventSourceElement = ui.getElement();
        Component activeModalComponent = ui.getInternals().getActiveModalComponent();
        if (activeModalComponent != null) {
            eventSourceElement = activeModalComponent.getElement();
        }
        deviceOrientation.orientationListener = eventSourceElement.addEventListener("deviceorientationevent", (DomEventListener & Serializable)e -> {
            try {
                DeviceOrientationEvent orientationEvent = (DeviceOrientationEvent)e.getEventDetail(DeviceOrientationEvent.class);
                listener.deviceOrientationUpdate(orientationEvent);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).addEventDetail().throttle(1000);
        deviceOrientation.orientationListener.addEventData("event.detail");
        String eventName = absolute ? "deviceorientationabsolute" : "deviceorientation";
        eventSourceElement.executeJs("var el = $0;\nwindow.addEventListener($1, function(e) {\n    const event = new CustomEvent('deviceorientationevent', {\n        detail: JSON.stringify({\n            alpha: e.alpha,\n            beta: e.beta,\n            gamma: e.gamma,\n            absolute: e.absolute,\n            webkitCompassHeading: e.webkitCompassHeading,\n            webkitCompassAccuracy: e.webkitCompassAccuracy\n        })\n    });\n    el.dispatchEvent(event);\n});\n", new Object[]{eventSourceElement, eventName});
        return deviceOrientation;
    }

    public void cancel() {
        this.clearListener();
    }

    private void clearListener() {
        if (this.orientationListener != null) {
            this.orientationListener.remove();
            this.orientationListener = null;
        }
    }

    public void throttleEvents(int milliseconds) {
        this.orientationListener.throttle(milliseconds);
    }

    public static void requestPermission(Runnable onSuccess, Runnable onError) {
        UI ui = UI.getCurrent();
        DeviceOrientation.requestPermission(ui, onSuccess, onError);
    }

    public static void requestPermission(UI ui, Runnable onSuccess, Runnable onError) {
        ui.getPage().executeJs("debugger;\n// Check if permission API exists (iOS 13+)\nif (typeof DeviceOrientationEvent !== 'undefined' &&\n    typeof DeviceOrientationEvent.requestPermission === 'function') {\n    return DeviceOrientationEvent.requestPermission()\n        .then(permissionState => {\n            return permissionState;\n        })\n        .catch(error => {\n            return 'denied';\n        });\n} else {\n    // Permission not required on this platform\n    return 'not_required';\n}\n", new Object[0]).then(String.class, (SerializableConsumer & Serializable)result -> {
            if ("granted".equals(result) || "not_required".equals(result)) {
                onSuccess.run();
            } else {
                onError.run();
            }
        }, (SerializableConsumer & Serializable)error -> onError.run());
    }

    public static CompletableFuture<Boolean> isPermissionRequired() {
        return DeviceOrientation.isPermissionRequired(UI.getCurrent());
    }

    public static CompletableFuture<Boolean> isPermissionRequired(UI ui) {
        return ui.getPage().executeJs("return typeof DeviceOrientationEvent !== 'undefined' &&\n       typeof DeviceOrientationEvent.requestPermission === 'function';\n", new Object[0]).toCompletableFuture(Boolean.class);
    }

    public static CompletableFuture<Permission> checkPermission() {
        return DeviceOrientation.checkPermission(UI.getCurrent());
    }

    public static CompletableFuture<Permission> checkPermission(UI ui) {
        return ui.getPage().executeJs("if (typeof DeviceOrientationEvent !== 'undefined' &&\n    typeof DeviceOrientationEvent.requestPermission === 'function') {\n    // iOS 13+ - check permission state (note: can't actually check state before requesting)\n    return 'default';\n} else {\n    return 'not_required';\n}\n", new Object[0]).toCompletableFuture(String.class).thenApply(str -> Permission.valueOf(str.toUpperCase()));
    }

    public static interface OrientationListener {
        public void deviceOrientationUpdate(DeviceOrientationEvent var1);
    }

    public static enum Permission {
        GRANTED,
        DENIED,
        DEFAULT,
        NOT_REQUIRED;

    }
}

