/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.popover;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.io.Serializable;
import org.vaadin.firitin.components.button.VButton;
import org.vaadin.firitin.components.popover.ContentProvider;
import org.vaadin.firitin.components.popover.VPopover;

public class PopoverButton
extends VButton {
    private final ContentProvider contentProvider;
    private VPopover popover;

    public PopoverButton(ContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        this.addClickListener((ComponentEventListener & Serializable)e -> this.open());
        this.setIcon((Component)VaadinIcon.ELLIPSIS_V.create());
    }

    public VPopover getPopover() {
        if (this.popover == null) {
            this.popover = new VPopover(this.contentProvider);
            this.popover.setTarget((Component)this);
        }
        return this.popover;
    }

    public void open() {
        this.getPopover().open();
        this.getPopover().addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!e.isOpened()) {
                this.popover.removeFromParent();
                this.popover = null;
            }
        });
    }

    public void close() {
        if (this.popover != null) {
            this.popover.close();
        }
    }
}

