/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.dataview.GridDataView;
import com.vaadin.flow.component.grid.dataview.GridLazyDataView;
import com.vaadin.flow.component.grid.dataview.GridListDataView;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.vaadin.firitin.components.grid.VGrid;

public class TreeTable<T>
extends VGrid<T> {
    private OpenModel<T> openModel;
    private LeafModel<T> leafModel;
    private LevelModel<T> levelModel;
    private List<T> rootItems;
    private SerializableFunction<T, List<T>> childrenProvider;
    private boolean allowUserToToggleOpenState = true;

    public Grid.Column<T> addHierarchyColumn(SerializableFunction<T, String> valueProvider) {
        return this.addComponentColumn((ValueProvider & Serializable)item -> {
            HierarchyColumnWrapper hcw = new HierarchyColumnWrapper(item);
            hcw.setText((String)valueProvider.apply(item));
            return hcw;
        });
    }

    public Grid.Column<T> addHierarchyComponentColumn(SerializableFunction<T, Component> valueProvider) {
        return this.addComponentColumn((ValueProvider & Serializable)item -> {
            HierarchyColumnWrapper hcw = new HierarchyColumnWrapper(item);
            hcw.getElement().appendChild(new Element[]{((Component)valueProvider.apply(item)).getElement()});
            return hcw;
        });
    }

    public void setTreeTableModel(TreeTableModel model) {
        this.openModel = model;
        this.leafModel = model;
        this.levelModel = model;
    }

    public void setRootItems(List<T> rootItems, SerializableFunction<T, List<T>> childrenProvider) {
        this.rootItems = rootItems;
        this.childrenProvider = childrenProvider;
        this.reloadData();
    }

    private void addChildrenRecursively(T rootItem, Map<T, Integer> levelMap, Integer level, Function<T, List<T>> childrenProvider, List<T> visibleRows) {
        List<T> children;
        if (this.getOpenModel().isOpen(rootItem) && (children = childrenProvider.apply(rootItem)) != null) {
            level = level + 1;
            for (T child : children) {
                visibleRows.add(child);
                levelMap.put(child, (int)level);
                this.addChildrenRecursively(child, levelMap, level, childrenProvider, visibleRows);
            }
            level = level - 1;
        }
    }

    public OpenModel<T> getOpenModel() {
        if (this.openModel == null) {
            this.openModel = new OpenByDefault();
        }
        return this.openModel;
    }

    public void setOpenModel(OpenModel<T> openModel) {
        this.openModel = openModel;
    }

    public LevelModel<T> getLevelModel() {
        assert (this.levelModel != null);
        return this.levelModel;
    }

    public void setLevelModel(LevelModel<T> levelModel) {
        this.levelModel = levelModel;
    }

    public LeafModel<T> getLeafModel() {
        assert (this.levelModel != null);
        return this.leafModel;
    }

    public void setLeafModel(LeafModel<T> leafModel) {
        this.leafModel = leafModel;
    }

    private void reloadData() {
        if (this.rootItems == null) {
            this.getGenericDataView().refreshAll();
        } else {
            ArrayList<T> visibleRows = new ArrayList<T>();
            HashMap levelMap = new HashMap();
            Integer level = 0;
            for (T rootItem : this.rootItems) {
                visibleRows.add(rootItem);
                levelMap.put(rootItem, level);
                this.addChildrenRecursively(rootItem, (Map<T, Integer>)levelMap, level, (Function<T, List<T>>)this.childrenProvider, (List<T>)visibleRows);
            }
            this.setLevelModel(item -> (Integer)levelMap.get(item));
            this.setLeafModel(item -> ((List)this.childrenProvider.apply(item)).isEmpty());
            super.setItems(visibleRows);
        }
    }

    @Deprecated
    public GridDataView<T> setItems(DataProvider<T, Void> dataProvider) {
        return super.setItems(dataProvider);
    }

    @Deprecated
    public GridDataView<T> setItems(InMemoryDataProvider<T> inMemoryDataProvider) {
        return super.setItems(inMemoryDataProvider);
    }

    @Deprecated
    public GridLazyDataView<T> setItems(BackEndDataProvider<T, Void> dataProvider) {
        return super.setItems(dataProvider);
    }

    @Deprecated
    public GridListDataView<T> setItems(T ... items) {
        return (GridListDataView)super.setItems((Object[])items);
    }

    @Deprecated
    public GridListDataView<T> setItems(ListDataProvider<T> dataProvider) {
        return super.setItems(dataProvider);
    }

    @Deprecated
    public GridListDataView<T> setItems(Collection<T> items) {
        return (GridListDataView)super.setItems(items);
    }

    public void allowUserToToggleOpenState(boolean allow) {
        this.allowUserToToggleOpenState = allow;
    }

    public TreeTable() {
        this.hackAroundScrollToIndexTimingIssue();
    }

    public TreeTable(Class<T> beanType) {
        super(beanType);
        this.hackAroundScrollToIndexTimingIssue();
    }

    private void hackAroundScrollToIndexTimingIssue() {
        this.getElement().executeJs("const orig = this.scrollToIndex;\nconst el = this;\nthis.scrollToIndex = function(idx) {\n    setTimeout(() => {\n        orig.call(el,idx);\n    }, 0);\n}\n", new Object[0]);
    }

    public static interface OpenModel<T> {
        public boolean isOpen(T var1);

        public void setOpen(T var1, boolean var2);
    }

    public static interface LeafModel<T> {
        public boolean isLeaf(T var1);
    }

    public static interface LevelModel<T> {
        public int getLevel(T var1);
    }

    public static class OpenByDefault<T>
    implements OpenModel<T> {
        private final Set<T> closed = new HashSet<T>();

        public Set<T> getClosed() {
            return this.closed;
        }

        @Override
        public boolean isOpen(T item) {
            return !this.closed.contains(item);
        }

        @Override
        public void setOpen(T item, boolean open) {
            if (open) {
                this.closed.remove(item);
            } else {
                this.closed.add(item);
            }
        }
    }

    @Tag(value="vaadin-grid-tree-toggle")
    public class HierarchyColumnWrapper
    extends Component
    implements HasText {
        private final T item;

        public HierarchyColumnWrapper(T item) {
            this.item = item;
            boolean open = TreeTable.this.getOpenModel().isOpen(item);
            this.getElement().setProperty("expanded", open);
            int level = TreeTable.this.getLevelModel().getLevel(item);
            this.getElement().setProperty("level", (double)level);
            this.getElement().setProperty("leaf", TreeTable.this.getLeafModel().isLeaf(item));
            this.getElement().executeJs("    var el = this;\n    const allowToggling = %s;\n    const open = %s;\n    setTimeout(function() {\n        el.addEventListener('expanded-changed', function(e) {\n            if(allowToggling) {\n                if(el.expanded != open)\n                    el.$server.onExpandedChanged();\n            } else {\n                el.expanded = open;\n            }\n            e.stopPropagation();\n        });\n        if(!allowToggling) {\n            // override hover color, TODO figure out a better way...\n            el.shadowRoot.querySelector(\"span[part='toggle']\").style.color = \"var(--lumo-contrast-50pct)\";\n        }\n    }, 100);\n".formatted(TreeTable.this.allowUserToToggleOpenState, open), new Object[0]);
        }

        @ClientCallable
        private void onExpandedChanged() {
            boolean open = this.getElement().getProperty("expanded", false);
            TreeTable.this.getOpenModel().setOpen(this.item, !open);
            TreeTable.this.reloadData();
        }
    }

    public static class ClosedByDefault<T>
    implements OpenModel<T> {
        private final Set<T> open = new HashSet<T>();

        public Set<T> getOpen() {
            return this.open;
        }

        @Override
        public boolean isOpen(T item) {
            return this.open.contains(item);
        }

        @Override
        public void setOpen(T item, boolean open) {
            if (open) {
                this.open.add(item);
            } else {
                this.open.remove(item);
            }
        }
    }

    public static interface TreeTableModel<T>
    extends OpenModel<T>,
    LeafModel<T>,
    LevelModel<T> {
    }
}

