<%@include file="../common/taglibs.jsp"%>
<s:principal name="admin-com.cybelia.sandra.entities.Societe"/>

<html>
    <body>
        <%@include file="../common/header.jsp"%>
        
        <div class="content">
            <div class="subtitle">
                <c:if test="${not empty requestScope.user.topiaId}">
                    <fmt:message key="user.modify.title"/>
                </c:if>
                <c:if test="${empty requestScope.user.topiaId}">
                    <fmt:message key="user.new.title"/>
                </c:if>
            </div>
            <div class="align-right space">
                <html:link styleClass="button go" action="/appli/user/list.do">
                    <fmt:message key="common.backtolist"/>
                </html:link>
            </div>
            <div class="space">
                <html:form action="/appli/user/save" method="POST">
                    <c:if test="${not empty requestScope.user.topiaId}">
                        <html:hidden property="topiaId"/>
                    </c:if>
                    
                    <div class="leftPart">
                        <label for="login"><fmt:message key="user.login"/><span class="required">*</span> :</label>
                    </div>
                    <div class="rightPart">
                        <html:text property="login" styleId="login" size="20" maxlength="20" styleClass="fixed"/>
                    </div>
                    <br class="spacer"/>
                    
                    <div class="leftPart">
                        <label for="email"><fmt:message key="user.email"/><span class="required">*</span> :</label>
                    </div>
                    <div class="rightPart">
                        <html:text property="email" styleId="email" size="20" maxlength="50" styleClass="fixed"/>
                    </div>
                    <br class="spacer"/>
                    
                    <div class="leftPart">
                        <label for="society"><fmt:message key="user.society"/><span class="required">*</span> :</label>
                    </div>
                    <div class="rightPart">
                        <html:select property="society" styleId="society" styleClass="fixed">
                            <c:if test="${empty requestScope.user.topiaId}">
                                <html:option value="" key="society.no"/>
                            </c:if>
                            <html:optionsCollection name="applicationSession" property="namingSocietes" label="value" value="key"/>
                        </html:select>
                    </div>
                    <br class="spacer"/>
                    
                    <div class="leftPart">
                        <label for="enabled"><fmt:message key="user.enabled"/> :</label>
                    </div>
                    <div class="rightPart">
                        <html:checkbox property="enabled" styleId="enabled"/>
                        <html:img page="/images/icons/user.png" altKey="user.actif"/>
                    </div>
                    <br class="spacer"/>
                    
                    <div class="leftPart">
                        <label for="isWeb"><fmt:message key="user.isWeb"/> :</label>
                    </div>
                    <div class="rightPart">
                        <html:checkbox property="isWeb" styleId="isWeb"/>
                        <html:img page="/images/icons/user_green.png" altKey="user.isWeb"/>
                    </div>
                    <br class="spacer"/>
                    
                    <c:if test="${not empty requestScope.user.profilType}">
                        <html:hidden property="profilType"/>
                        <div class="leftPart">
                            <label for="isAdmin"><fmt:message key="user.isAdmin"/> :</label>
                        </div>
                        <div class="rightPart">
                            <html:checkbox property="isAdmin" styleId="isAdmin"/>
                            <html:img page="/images/icons/user_red.png" altKey="user.isAdmin"/>
                        </div>
                        <br class="spacer"/>
                    </c:if>
                    <div class="groupbutton">
                        <html:submit styleClass="save" property="save"><fmt:message key="common.save"/></html:submit>
                    </div>
                    <div class="clear">&nbsp;</div>
                </html:form>
            </div>
            
            <c:if test="${not empty requestScope.user.topiaId}">
                <div class="space">
                    <div class="leftPart">
                        <label for="profilType"><fmt:message key="user.profil"/> :</label>
                    </div>

                    <div class="rightPart">
                        <div class="left">
                            <div class="space">
                                <c:choose>
                                    <c:when test="${empty requestScope.user.profils}">
                                        <html:form action="/appli/user/view" method="POST" styleId="selectProfil">
                                            <html:hidden property="topiaId"/>
                                            <html:select property="profilType" styleId="profilType"
                                                         onchange="document.forms['selectProfil'].submit()" styleClass="fixed">
                                                <html:option value="" key="profilType.no"/>
                                                <html:optionsCollection name="applicationSession" property="namingProfils" label="value" value="key"/>
                                            </html:select>
                                        </html:form>
                                    </c:when>
                                    <c:otherwise>
                                        ${fn:substringAfter(requestScope.user.profilType, "com.cybelia.sandra.entities.")}
                                    </c:otherwise>
                                </c:choose>
                            </div>
                            <html:form action="/appli/user/profil/add" method="POST">
                                <html:hidden property="topiaId"/>
                                <html:hidden property="profilType"/>
                                <div class="space">
                                    <html:select property="selectedProfils" styleId="profil" size="10" multiple="true" styleClass="fixed">
                                        <c:if test="${not empty requestScope.profilValues}">
                                            <html:optionsCollection name="profilValues" label="value" value="key"/>
                                        </c:if>
                                    </html:select>
                                </div>
                                <div class="align-right">
                                    <html:submit disabled="${empty requestScope.profilValues}" styleClass="add"
                                                 property="add"><fmt:message key="common.add"/></html:submit>
                                </div>
                            </html:form>
                        </div>
                        <div class="right">
                            <div class="space">&nbsp;</div>
                            <html:form action="/appli/user/profil/delete" method="POST">
                                <html:hidden property="topiaId"/>
                                <div class="space">
                                    <html:select property="selectedProfils" styleId="profil" size="10" multiple="true" styleClass="fixed">
                                        <c:forEach items="${requestScope.user.profils}" var="profil">
                                            <option value="${profil}"><s:naming topiaId="${profil}"/></option>
                                        </c:forEach>
                                    </html:select>
                                </div>
                                <div class="align-right">
                                    <html:submit disabled="${empty requestScope.user.profils}" styleClass="delete" property="delete">
                                        <fmt:message key="common.delete"/>
                                    </html:submit>
                                </div>
                            </html:form>
                        </div>
                    </div>
                </div>
            </c:if>
        </div>
        
        <%@include file="../common/footer.jsp"%>
    </body>
    
</html>
