<%@include file="../common/taglibs.jsp"%>
<s:principal name="admin-com.cybelia.sandra.entities.Societe"/>

<html>
    <body>
        <%@include file="../common/header.jsp"%>

        <div class="content">
            <div class="subtitle"><fmt:message key="user.list.title"/></div>
            <div class="align-right space">
                <html:link styleClass="button add" action="/appli/user/view.do"><fmt:message key="common.new"/></html:link>
            </div>
            <div class="space">
                <fmt:message key="user.previous.rasDate"/>
                <fmt:formatDate value="${applicationSession.previousRAZ}" pattern="${datehour_pattern_long}"/>
            </div>
            <display:table name="requestScope.users" id="user" requestURI="/appli/user/list.do">
                <display:column>
                    <c:if test="${pageScope.user.enabled}">
                        <img src="<c:url value="/images/icons/user.png"/>" alt="actif">
                         </c:if>
                    <c:if test="${not pageScope.user.enabled}">
                        <img src="<c:url value="/images/icons/user_delete.png"/>" alt="inactif">
                         </c:if>

                    <s:user user="${pageScope.user}" method="globalProfil"/>
                    <c:if test="${pageScope.isWeb and not pageScope.isAdmin}">
                        <img src="<c:url value="/images/icons/user_green.png"/>" alt="web">
                         </c:if>
                    <c:if test="${pageScope.isAdmin}">
                        <img src="<c:url value="/images/icons/user_red.png"/>" alt="admin">
                         </c:if>
                </display:column>
                <display:column property="login" titleKey="user.login" sortable="true"/>
                <display:column property="email" titleKey="user.email" sortable="true" class="colcenter"/>
                <display:column titleKey="user.lastConnectionDate" sortable="true" sortProperty="lastConnectionDate" class="colcenter">
                    <fmt:formatDate value="${pageScope.user.lastConnectionDate}" pattern="${datehour_pattern_long}"/>
                </display:column>
                <display:column property="numberOfConnection" titleKey="user.numberOfConnection" sortable="true" class="colcenter"/>
                <display:column titleKey="user.society" sortable="true" sortProperty="link" class="colcenter">
                    <s:naming topiaId="${pageScope.user.link}"/>
                </display:column>
                <display:column titleKey="user.authorizations" class="colcenter">
                    <s:user user="${pageScope.user}" method="authorizations"/>
                </display:column>
                <display:column titleKey="common.action" class="action">
                    <c:if test="${not empty pageScope.user.email}"> <%-- Utilisateur systeme pas de modification possible --%>
                        <html:link styleClass="button user-go" action="/appli/user/view.do"
                                   paramId="topiaId" paramName="user" paramProperty="topiaId"><fmt:message key="user.modify.title"/></html:link>
                    </c:if>
                </display:column>
            </display:table>
        </div>

        <div>
            <img src="<c:url value="/images/icons/user.png"/>" alt="actif"> <fmt:message key="user.enabled"/>
        </div>
        <div>
            <img src="<c:url value="/images/icons/user_delete.png"/>" alt="inactif"> <fmt:message key="user.disabled"/>
        </div>
        <div>
            <img src="<c:url value="/images/icons/user_green.png"/>" alt="web"> <fmt:message key="user.isWeb"/>
        </div>
        <div>
            <img src="<c:url value="/images/icons/user_red.png"/>" alt="admin"> <fmt:message key="user.isAdmin"/>
        </div>

        <%@include file="../common/footer.jsp"%>
    </body>

</html>
