<%@include file="../common/taglibs.jsp"%>
<s:principal name="admin-com.cybelia.sandra.entities.Societe"/>

<html>
    <body>
        <%@include file="../common/header.jsp"%>
    <div class="content">
            <div class="subtitle"><fmt:message key="user.listCamion.title"/></div>
            <div class="align-right space">
                <html:link styleClass="button email" action="/appli/user/sendUserActivityEmail.do"><fmt:message key="user.sendUserActivityEmail"/></html:link>
                <html:link styleClass="button add" action="/appli/user/view.do"><fmt:message key="common.new"/></html:link>
            </div>
            <div class="space">
                <fmt:message key="user.previous.rasDate"/>
                <fmt:formatDate value="${applicationSession.previousRAZ}" pattern="${datehour_pattern_long}"/>
                <br/>
                <br/>
                <div id='criteriaByBreader' class="space">
                    <html:form action="/appli/user/listCamion" method="POST" styleId="searchCamion">

                        <div class="criteria">
                            <div>
                                <label for="society"><fmt:message key="criteria.society"/> :</label>
                            </div>
                            <div>
                                <html:select property="society" styleId="society">
                                    <html:option value="" key="criteria.no"/>
                                    <html:optionsCollection name="applicationSession" property="namingSocietes" label="value" value="key"/>
                                </html:select>
                            </div>
                        </div>
                        <div class="criteria">
                            <div>
                                <label for="showInactif"><fmt:message key="criteria.showInactif"/> :</label>
                            </div>
                            <div>
                                <html:checkbox property="showInactif" styleId="showInactif"/>
                                <input type="hidden" name="showInactif" value="false"/>
                            </div>
                        </div>
                        <div class="criteria">
                            <div>&nbsp;</div>
                            <div><html:submit styleClass="search" property="apply"><fmt:message key="common.filter"/></html:submit></div>
                        </div>
                    </html:form>
                </div>
            </div>
            <display:table name="requestScope.camions" id="camion" requestURI="/appli/user/listCamion.do">
                <display:column>
                    <c:if test="${pageScope.camion.userIndicateurs.taasUser.enabled}">
                        <img src="<c:url value="/images/icons/user.png"/>" alt="actif">
                    </c:if>
                    <c:if test="${not pageScope.camion.userIndicateurs.taasUser.enabled}">
                        <img src="<c:url value="/images/icons/user_delete.png"/>" alt="inactif">
                    </c:if>

                    <s:user user="${pageScope.camion.userIndicateurs.taasUser}" method="globalProfil"/>
                    <c:if test="${pageScope.isWeb and not pageScope.isAdmin}">
                        <img src="<c:url value="/images/icons/user_green.png"/>" alt="web">
                    </c:if>
                    <c:if test="${pageScope.isAdmin}">
                        <img src="<c:url value="/images/icons/user_red.png"/>" alt="admin">
                    </c:if>
                </display:column>
                <display:column sortProperty="userIndicateurs.taasUser.link" titleKey="user.society" sortable="true" class="colcenter">
                    <s:naming topiaId="${pageScope.camion.userIndicateurs.taasUser.link}"/>
                </display:column>
                <display:column sortProperty="userIndicateurs.taasUser.login" titleKey="user.login" sortable="true">
                      ${pageScope.camion.userIndicateurs.taasUser.login}
                </display:column>
                <display:column sortProperty="userIndicateurs.lastSynch" titleKey="user.lastSynch" sortable="true" class="colcenter">
                    <fmt:formatDate value="${pageScope.camion.userIndicateurs.lastSynch}" pattern="${datehour_pattern_long}"/>
                </display:column>
                <display:column sortProperty="userIndicateurs.lastModif" titleKey="user.lastModif" sortable="true" class="colcenter">
                    <fmt:formatDate value="${pageScope.camion.userIndicateurs.lastModif}" pattern="${datehour_pattern_long}"/>
                </display:column>
                <display:column sortProperty="userIndicateurs.nbGpsMaj" titleKey="user.nbGpsMaj" sortable="true" class="colcenter">
                      ${pageScope.camion.userIndicateurs.nbGpsMaj}
                </display:column>
                <display:column sortProperty="userIndicateurs.nbSecuMaj" titleKey="user.nbSecuMaj" sortable="true" class="colcenter">
                      ${pageScope.camion.userIndicateurs.nbSecuMaj}
                </display:column>
                <display:column sortProperty="userIndicateurs.nbMaj" titleKey="user.nbMaj" sortable="true" class="colcenter">
                      ${pageScope.camion.userIndicateurs.nbMaj}
                </display:column>
                <display:column sortProperty="userIndicateurs.nbNotifs" titleKey="user.nbNotifs" sortable="true" class="colcenter">
                      ${pageScope.camion.userIndicateurs.nbNotifs}
                </display:column>
                <display:column sortProperty="userIndicateurs.nbSynchWifi" titleKey="user.nbSynchWifi" sortable="true" class="colcenter">
                      ${pageScope.camion.userIndicateurs.nbSynchWifi}
                </display:column>
                <display:column sortProperty="userIndicateurs.nbSynchAuto" titleKey="user.nbSynchAuto" sortable="true" class="colcenter">
                      ${pageScope.camion.userIndicateurs.nbSynchAuto}
                </display:column>
                <display:column sortProperty="userIndicateurs.nbSynchGPRS" titleKey="user.nbSynchGprs" sortable="true" class="colcenter">
                      ${pageScope.camion.userIndicateurs.nbSynchGPRS}
                </display:column>
                <display:column sortProperty="userIndicateurs.nbSynchKo" titleKey="user.nbSynchKo" sortable="true" class="colcenter">
                      ${pageScope.camion.userIndicateurs.nbSynchKo}
                </display:column>
                <display:column sortProperty="userIndicateurs.nbOctetsSendGPRS" titleKey="user.nbOctetsSendGPRS" sortable="true" class="colcenter">
                      ${pageScope.camion.userIndicateurs.nbOctetsSendGPRS}
                </display:column>
                <display:column sortProperty="userIndicateurs.nbOctetsReceivedGPRS" titleKey="user.nbOctetsReceivedGPRS" sortable="true" class="colcenter">
                      ${pageScope.camion.userIndicateurs.nbOctetsReceivedGPRS}
                </display:column>
                <display:column sortProperty="userIndicateurs.nbOctetsSendWifi" titleKey="user.nbOctetsSendWifi" sortable="true" class="colcenter">
                      ${pageScope.camion.userIndicateurs.nbOctetsSendWifi}
                </display:column>
                <display:column sortProperty="userIndicateurs.nbOctetsReceivedWifi" titleKey="user.nbOctetsReceivedWifi" sortable="true" class="colcenter">
                      ${pageScope.camion.userIndicateurs.nbOctetsReceivedWifi}
                </display:column>
                <display:column titleKey="common.action" class="action">
                    <c:if test="${requestScope.actif}">
                        <html:link styleClass="button user-go" action="/appli/user/setInactifCamion.do" paramId="topiaId" paramName="camion" paramProperty="topiaId">
                            <fmt:message key="user.listCamion.setInactifCamion"/>
                        </html:link>
                    </c:if>
                    <c:if test="${!requestScope.actif}">
                        <html:link styleClass="button user-go" action="/appli/user/setActifCamion.do" paramId="topiaId" paramName="camion" paramProperty="topiaId">
                            <fmt:message key="user.listCamion.setActifCamion"/>
                        </html:link>
                    </c:if>
                </display:column>
            </display:table>
        </div>

        <div>
            <img src="<c:url value="/images/icons/user.png"/>" alt="actif"> <fmt:message key="user.enabled"/>
        </div>
        <div>
            <img src="<c:url value="/images/icons/user_delete.png"/>" alt="inactif"> <fmt:message key="user.disabled"/>
        </div>
        <div>
            <img src="<c:url value="/images/icons/user_green.png"/>" alt="web"> <fmt:message key="user.isWeb"/>
        </div>
        <div>
            <img src="<c:url value="/images/icons/user_red.png"/>" alt="admin"> <fmt:message key="user.isAdmin"/>
        </div>

        <%@include file="../common/footer.jsp"%>
    </body>

</html>
