<%@ page import="com.cybelia.sandra.SandraHelper" %>
<%@ page import="com.cybelia.sandra.entities.Eleveur" %>
<%@include file="../common/taglibs.jsp"%>
<s:principal name="com.cybelia.sandra.entities.Societe"/>

<html>
    <body>
        <%@include file="../common/header.jsp"%>
        <script>
            $(document).ready(function(){
                $('#livraisonDateStart').datepicker();
                $('#livraisonDateEnd').datepicker();

                $('#criteria').show();
                $('#criteriaByBreader').hide();

                // if was breeder selected
                if (window.location.pathname.indexOf("searchByBreader.do") >= 0) {
                    switchCriteria();
                }
            });

            function switchCriteria() {
                $('#criteria').toggle();
                $('#criteriaByBreader').toggle();
            }
        </script>

        <c:if test="${not empty requestScope.breeder}">
            <div class="subtitle"><fmt:message key="traceability.list.title"/> : <s:breeder eleveur="${requestScope.breeder}" method="title"/>
            </div>
        </c:if>

        <c:if test="${empty requestScope.breeder}">
            <div class="subtitle"><fmt:message key="traceability.list.title"/></div>
        </c:if>

        <div id="criteria">
            <jsp:include page="criteria.jsp">
                <jsp:param name="action" value="/appli/tour/traceability/search"/>
                <jsp:param name="doAction" value="/appli/tour/traceability.do"/>
            </jsp:include>
        </div>

        <div id='criteriaByBreader' class="space">
            <html:form action="/appli/tour/traceability/searchByBreader" method="POST" styleId="searchBreader">
                <html:hidden property="breederTopiaId"/>

                <div class="criteria">
                    <div>
                        <label for="livraisonDateStart"><fmt:message key="breeder.criteria.livraisonDateStart"/> :</label>
                    </div>
                    <div>
                        <fmt:formatDate value="${criteriaByBreeder.livraisonDateStart}" var="livraisonDateStart" pattern="${date_pattern_long}"/>
                        <html:text property="livraisonDateStart" styleId="livraisonDateStart" size="8" maxlength="8" value="${livraisonDateStart}"/>
                    </div>
                </div>

                <div class="criteria">
                    <div>
                        <label for="livraisonDateEnd"><fmt:message key="breeder.criteria.livraisonDateEnd"/> :</label>
                    </div>
                    <div>
                        <fmt:formatDate value="${criteriaByBreeder.livraisonDateEnd}" var="livraisonDateEnd" pattern="${date_pattern_long}"/>
                        <html:text property="livraisonDateEnd" styleId="livraisonDateEnd" size="8" maxlength="8" value="${livraisonDateEnd}"/>
                    </div>
                </div>
                <div class="criteria">
                    <div>&nbsp;</div>
                    <html:submit styleClass="search"><fmt:message key="breeder.search"/></html:submit>
                </div>
            </html:form>
        </div>
        <br class="spacer"/>

        <fmt:message key="traceability.result.title"/> :
        <c:set var="tracabilityUrl">
            <c:if test="${empty requestScope.breeder}">
                /appli/tour/traceability.do
            </c:if>
            <c:if test="${not empty requestScope.breeder}">
                /appli/tour/traceability/searchByBreader.do
            </c:if>
        </c:set>
        <display:table name="requestScope.steps" id="s" requestURI="${tracabilityUrl}">

            <display:column titleKey="tour.delivery" sortable="true" class="colcenter">
                <fmt:formatDate value="${pageScope.s.tour.dateLivraison}" pattern="${date_pattern_short}"/>
            </display:column>
            <display:column titleKey="tour.truck" sortable="true" class="colcenter">
                <s:naming topiaId="${pageScope.s.tour.camion.topiaId}"/>
            </display:column>
            <display:column titleKey="tour.number" sortable="true" class="colcenter">
                ${pageScope.s.tour.numero}
            </display:column>

            <c:if test="${empty requestScope.breeder}">
                <display:column titleKey="step.number" sortable="true" class="colcenter">
                    ${pageScope.s.number}
                </display:column>
            </c:if>

            <c:if test="${not empty requestScope.breeder}">
                <c:if test="${empty pageScope.s.suiviEtape}">
                    <display:column titleKey="step.number" sortable="true" class="colcenter">
                        ${pageScope.s.etape.ordre}
                    </display:column>
                </c:if>
                <c:if test="${not empty pageScope.s.suiviEtape}">
                    <display:column titleKey="step.number" sortable="true" class="colcenter">
                        ${pageScope.s.suiviEtape.etape.ordre}
                    </display:column>
                </c:if>
            </c:if>

            <c:if test="${not empty pageScope.s.etape}">
                <display:column titleKey="step.entryDate" sortable="true" class="colcenter"/>
                <display:column titleKey="step.exitDate" sortable="true" class="colcenter"/>
                <display:column titleKey="step.deliveryQuantity"/>
                <c:if test="${empty requestScope.breeder}">
                    <display:column titleKey="step.name" sortable="true">
                        ${pageScope.s.etape.eleveur.raisonSociale}
                    </display:column>
                    <display:column titleKey="step.address">
                        ${pageScope.s.etape.eleveur.adresse} - ${pageScope.s.etape.eleveur.codePostal} ${pageScope.s.etape.eleveur.ville}
                    </display:column>
                </c:if>
                <display:column titleKey="tour.driver" sortable="true">
                    <s:tour tour="${pageScope.s.tour}" method="driver"/>
                </display:column>
                <display:column titleKey="step.delivery.status" class="colcenter"/>
                <display:column titleKey="step.delivery.comment"/>
            </c:if>
            
            <c:if test="${not empty pageScope.s.suiviEtape}">
                <display:column titleKey="step.entryDate" sortable="true" class="colcenter">
                    <fmt:formatDate value="${pageScope.s.suiviEtape.dateEntree}" pattern="${datehour_pattern_long}"/>
                </display:column>
                <display:column titleKey="step.exitDate" sortable="true" class="colcenter">
                    <fmt:formatDate value="${pageScope.s.suiviEtape.dateSortie}" pattern="${datehour_pattern_long}"/>
                </display:column>
                <display:column titleKey="step.deliveryQuantity">
                    <s:step etape="${pageScope.s.suiviEtape.etape}" method="quantity"/>
                </display:column>
                <c:if test="${empty requestScope.breeder}">
                    <display:column titleKey="step.name" sortable="true" class="colcenter">
                        ${pageScope.s.suiviEtape.etape.eleveur.raisonSociale}
                    </display:column>
                    <display:column titleKey="step.address">
                        ${pageScope.s.suiviEtape.etape.eleveur.adresse} - ${pageScope.s.suiviEtape.etape.eleveur.codePostal} ${pageScope.s.suiviEtape.etape.eleveur.ville}
                    </display:column>
                </c:if>
                <display:column titleKey="tour.driver" sortable="true">
                    <s:tour tour="${pageScope.s.tour}" method="driver"/>
                </display:column>
                <display:column titleKey="step.delivery.status" class="colcenter">
                    <s:label categorie="CLS" id="${pageScope.s.suiviEtape.status}"/>
                </display:column>
                <display:column titleKey="step.delivery.comment">
                    ${pageScope.s.suiviEtape.CREtape.commentaireLivraison}
                </display:column>
            </c:if>
            
            <c:if test="${not empty pageScope.s.usine}">
                <display:column titleKey="step.entryDate" sortable="true" class="colcenter"/>
                <display:column titleKey="step.exitDate" sortable="true" class="colcenter"/>
                <display:column titleKey="step.deliveryQuantity"/>
                <c:if test="${empty requestScope.breeder}">
                    <display:column titleKey="step.name" sortable="true">
                        ${pageScope.s.usine.code}
                    </display:column>
                    <display:column titleKey="step.address">
                        ${pageScope.s.usine.ville}
                    </display:column>
                </c:if>
                <display:column titleKey="tour.driver" sortable="true">
                    <s:tour tour="${pageScope.s.tour}" method="driver"/>
                </display:column>
                <display:column titleKey="step.delivery.status" class="colcenter"/>
                <display:column titleKey="step.delivery.comment"/>
            </c:if>
            
            <c:if test="${not empty pageScope.s.suiviUsine}">
                <display:column titleKey="step.entryDate" sortable="true" class="colcenter">
                    <fmt:formatDate value="${pageScope.s.suiviUsine.dateEntree}" pattern="${datehour_pattern_long}"/>
                </display:column>
                <display:column titleKey="step.exitDate" sortable="true" class="colcenter">
                    <fmt:formatDate value="${pageScope.s.suiviUsine.dateSortie}" pattern="${datehour_pattern_long}"/>
                </display:column>
                <display:column titleKey="step.deliveryQuantity"/>
                <c:if test="${empty requestScope.breeder}">
                    <display:column titleKey="step.name" sortable="true">
                        ${pageScope.s.suiviUsine.usine.code}
                    </display:column>
                    <display:column titleKey="step.address">
                        ${pageScope.s.suiviUsine.usine.ville}
                    </display:column>
                </c:if>
                <display:column titleKey="tour.driver" sortable="true">
                    <s:tour tour="${pageScope.s.tour}" method="driver"/>
                </display:column>
                <display:column titleKey="step.delivery.status" class="colcenter"/>
                <display:column titleKey="step.delivery.comment"/>
            </c:if>
        </display:table>
        
        <fmt:message key="traceability.anomaly.title"/> :
        <display:table name="requestScope.anomalies" id="a" requestURI="${tracabilityUrl}" sort="list" defaultsort="1" defaultorder="ascending" pagesize="10">
            
            <display:column titleKey="tour.delivery" sortable="true" class="colcenter">
                <fmt:formatDate value="${pageScope.a.tour.dateLivraison}" pattern="${date_pattern_short}"/>
            </display:column>
            <display:column titleKey="tour.truck" sortable="true" class="colcenter">
                <s:naming topiaId="${pageScope.a.tour.camion.topiaId}"/>
            </display:column>
            <display:column titleKey="tour.number" sortable="true" class="colcenter">
                ${pageScope.a.tour.numero}
            </display:column>

            <c:if test="${empty requestScope.breeder}">
                <c:if test="${not empty pageScope.s.etape}">
                    <display:column titleKey="step.name" sortable="true">
                        ${pageScope.a.etape.eleveur.raisonSociale}
                    </display:column>
                    <display:column titleKey="step.address">
                        ${pageScope.a.etape.eleveur.adresse} - ${pageScope.a.etape.eleveur.codePostal} ${pageScope.a.etape.eleveur.ville}
                    </display:column>
                </c:if>

                <c:if test="${not empty pageScope.s.suiviEtape}">
                    <display:column titleKey="step.name" sortable="true">
                        ${pageScope.a.suiviEtape.etape.eleveur.raisonSociale}
                    </display:column>
                    <display:column titleKey="step.address">
                        ${pageScope.a.suiviEtape.etape.eleveur.adresse} - ${pageScope.a.suiviEtape.etape.eleveur.codePostal} ${pageScope.a.suiviEtape.etape.eleveur.ville}
                    </display:column>
                </c:if>

                <c:if test="${not empty pageScope.s.usine}">
                    <display:column titleKey="step.name" sortable="true">
                        ${pageScope.a.usine.code}
                    </display:column>
                    <display:column titleKey="step.address">
                        ${pageScope.a.usine.ville}
                    </display:column>
                </c:if>

                <c:if test="${not empty pageScope.s.suiviUsine}">
                    <display:column titleKey="step.name" sortable="true">
                        ${pageScope.a.suiviUsine.usine.code}
                    </display:column>
                    <display:column titleKey="step.address">
                        ${pageScope.a.suiviUsine.usine.ville}
                    </display:column>
                </c:if>
            </c:if>

            <display:column titleKey="step.incident">
                <c:if test="${pageScope.a.noDelivery}">
                    <fmt:message key="traceability.incident.nodelivery"/> : <s:label categorie="CLS" id="${pageScope.a.suiviEtape.status}"/>
                </c:if>
                <c:if test="${pageScope.a.noReport}">
                    <fmt:message key="traceability.incident.noreport"/>
                </c:if>
                <c:if test="${pageScope.a.noGPS}">
                    <fmt:message key="traceability.incident.nogps"/>
                </c:if>
            </display:column>

        </display:table>
        
        <%@include file="../common/footer.jsp"%>
    </body>
    
</html>