<%@include file="../common/taglibs.jsp"%>
<s:authorization expression="com.cybelia.sandra.entities.trace#*" actions="LOAD"/>

<html>
    <body>
        <%@include file="../common/header.jsp"%>
        
        <div class="subtitle"><fmt:message key="tour.report.title"/>
            <c:if test="${not empty requestScope.tour}">
                : <fmt:formatDate value="${requestScope.tour.dateLivraison}" pattern="${date_pattern_short}"/> - ${requestScope.tour.camion.societe.code}-${requestScope.tour.camion.code} - ${requestScope.tour.numero} - <s:tour tour="${requestScope.tour}" method="driver"/>
            </c:if>
        </div>

        <div id="criteria">
            <jsp:include page="criteria.jsp">
                <jsp:param name="action" value="/appli/tour/report/search"/>
                <jsp:param name="doAction" value="/appli/tour/report.do"/>
            </jsp:include>
        </div>

        <display:table name="requestScope.tours" id="t" requestURI="/appli/tour/report.do">
        <%--display:table name="requestScope.tours" id="t" requestURI="/appli/tour/report.do" sort="list" defaultsort="1" defaultorder="ascending" pagesize="25"--%>
            <display:column titleKey="tour.delivery" sortable="true" sortProperty="dateLivraison" class="colcenter">
                <fmt:formatDate value="${pageScope.t.dateLivraison}" pattern="${date_pattern_short}"/>
            </display:column>
            <display:column titleKey="tour.truck" sortable="true" class="colcenter">
                <s:naming topiaId="${pageScope.t.camion.topiaId}"/>
            </display:column>
            <display:column property="numero" titleKey="tour.number" sortable="true" class="colcenter"/>
            <display:column titleKey="tour.driver" sortable="true" sortProperty="defautChauffeur">
                <s:tour tour="${pageScope.t}" method="driver"/>
            </display:column>
            <display:column property="suiviTour.kmTotal" titleKey="tour.kmTotal" class="colcenter"/>
            <display:column property="suiviTour.CRTour.remarques" titleKey="tour.remark"/>
            <display:column property="suiviTour.CRTour.litresGasoil" titleKey="tour.petrol" class="colcenter"/>
            <display:column property="suiviTour.CRTour.retourMP" titleKey="tour.returnMP" class="colcenter"/>
            <display:column property="suiviTour.CRTour.reprise" titleKey="tour.recapture" class="colcenter"/>
            <display:column property="suiviTour.CRTour.transfert" titleKey="tour.transfer" class="colcenter"/>
            <display:column titleKey="common.action" class="action">
                <html:link styleClass="button go" action="/appli/tour/list.do" paramId="tour" paramName="t" paramProperty="topiaId"><fmt:message key="tour.list.title"/></html:link>
                <html:link styleClass="button go" action="/appli/tour/step/list.do" paramId="tour" paramName="t" paramProperty="topiaId"><fmt:message key="step.list.title"/></html:link>
                <html:link styleClass="button go" action="/appli/tour/step/report.do" paramId="tour" paramName="t" paramProperty="topiaId"><fmt:message key="step.report.title"/></html:link>
            </display:column>
        </display:table>
        
        <%@include file="../common/footer.jsp"%>
    </body>
    
</html>
