<%@include file="../common/taglibs.jsp"%>
<s:authorization expression="com.cybelia.sandra.entities.Tour#*" actions="LOAD"/>

<html>
    <body>
        <%@include file="../common/header.jsp"%>
        
        <div class="subtitle">
            <fmt:message key="tour.list.title"/>
            <c:if test="${not empty requestScope.tour}">
                : <fmt:formatDate value="${requestScope.tour.dateLivraison}" pattern="${date_pattern_short}"/> - ${requestScope.tour.camion.societe.code}-${requestScope.tour.camion.code} - ${requestScope.tour.numero} - <s:tour tour="${requestScope.tour}" method="driver"/>
            </c:if>
        </div>

        <div id="criteria">
            <jsp:include page="criteria.jsp">
                <jsp:param name="action" value="/appli/tour/list/search"/>
                <jsp:param name="doAction" value="/appli/tour/list.do"/>
            </jsp:include>
        </div>
        
        <display:table name="requestScope.tours" id="t" requestURI="/appli/tour/list.do">
            <display:column titleKey="tour.delivery" sortable="true" sortProperty="dateLivraison" class="colcenter">
                <fmt:formatDate value="${pageScope.t.dateLivraison}" pattern="${date_pattern_short}"/>
            </display:column>
            <display:column titleKey="tour.truck" sortable="true" class="colcenter">
                <s:naming topiaId="${pageScope.t.camion.topiaId}"/>
            </display:column>
            <display:column property="numero" titleKey="tour.number" sortable="true" class="colcenter"/>
            <display:column titleKey="tour.driver" sortable="true" sortProperty="defautChauffeur">
                <s:tour tour="${pageScope.t}" method="driver"/>
            </display:column>
            <display:column titleKey="tour.quantity" sortable="true" class="colcenter">
                <s:tour tour="${pageScope.t}" method="quantity"/>
            </display:column>
            <display:column titleKey="tour.factories" class="colcenter">
                <s:tour tour="${pageScope.t}" method="factories"/>
            </display:column>
            <display:column titleKey="tour.status" class="colcenter">
                <s:tour tour="${pageScope.t}" method="status"/>
            </display:column>
            <display:column titleKey="tour.loading" class="colcenter">
                <s:tour tour="${pageScope.t}" method="dateChargement"/>
                <%--c:if test="${pageScope.t.dateLivraison != pageScope.t.dateChargement}">
                    <fmt:formatDate value="${pageScope.t.dateChargement}" pattern="${datehour_pattern_long}"/>
                </c:if--%>
            </display:column>
            <display:column property="commentaire" titleKey="tour.comment"/>
            <display:column titleKey="tour.time" class="colcenter">
                <fmt:formatDate value="${pageScope.t.suiviTour.duree}" pattern="hh:mm"/>
            </display:column>
            <display:column titleKey="tour.incident" class="colcenter">
                <s:tour tour="${pageScope.t}" method="incident"/>
                <fmt:message key="${pageScope.tourIncident}"/>
            </display:column>
            <display:column titleKey="common.action" class="action">
                <s:authorization expression="com.cybelia.sandra.entities.trace#*" actions="LOAD">
                    <html:link styleClass="button go" action="/appli/tour/report.do" paramId="tour" paramName="t" paramProperty="topiaId"><fmt:message key="tour.report.title"/></html:link>
                </s:authorization>    
                <html:link styleClass="button go" action="/appli/tour/step/list.do" paramId="tour" paramName="t" paramProperty="topiaId"><fmt:message key="step.list.title"/></html:link>
                <html:link styleClass="button go" action="/appli/tour/product/list.do" paramId="tour" paramName="t" paramProperty="topiaId"><fmt:message key="product.list.title"/></html:link>
            </display:column>
        </display:table>
        
        <%@include file="../common/footer.jsp"%>
    </body>
    
</html>
