<%@include file="../common/taglibs.jsp"%>
<s:authorization expression="com.cybelia.sandra.entities.trace#*" actions="LOAD"/>

<html>
    <body>
        <%@include file="../common/header.jsp"%>
        
        <div class="subtitle">
            <fmt:message key="step.report.title"/>
            <c:if test="${not empty requestScope.tour}">
                : <fmt:formatDate value="${requestScope.tour.dateLivraison}" pattern="${date_pattern_short}"/> - ${requestScope.tour.camion.societe.code}-${requestScope.tour.camion.code} - ${requestScope.tour.numero} - <s:tour tour="${requestScope.tour}" method="driver"/>
            </c:if>
        </div>

        <div id="criteria">
            <jsp:include page="criteria.jsp">
                <jsp:param name="action" value="/appli/tour/step/report/search"/>
                <jsp:param name="doAction" value="/appli/tour/step/report.do"/>
            </jsp:include>
        </div>
        
        <display:table name="requestScope.steps" id="s" requestURI="/appli/tour/step/report.do" sort="list" defaultsort="1" defaultorder="ascending" pagesize="25">
            
            <c:if test="${empty requestScope.tour}">
                <display:column titleKey="tour.delivery" sortable="true"  group="1" class="colcenter">
                    <fmt:formatDate value="${pageScope.s.tour.dateLivraison}" pattern="${date_pattern_short}"/>
                </display:column>
                <display:column titleKey="tour.truck" sortable="true"  group="1" class="colcenter">
                    <s:naming topiaId="${pageScope.s.tour.camion.topiaId}"/>
                </display:column>
                <display:column titleKey="tour.number" sortable="true"  group="1" class="colcenter">
                    ${pageScope.s.tour.numero}
                </display:column>
                <display:column titleKey="tour.driver" sortable="true"  group="1">
                    <s:tour tour="${pageScope.s.tour}" method="driver"/>
                </display:column>
            </c:if>
            
            <display:column titleKey="step.number" sortable="true" class="colcenter">
                ${pageScope.s.number}
            </display:column>
            
            <c:if test="${not empty pageScope.s.etape}">
                <display:column titleKey="step.name" sortable="true">
                    ${pageScope.s.etape.eleveur.raisonSociale}
                </display:column>
                <display:column titleKey="step.charged" class="colcenter"/>
                <display:column titleKey="step.delivery.purge" class="colcenter"/>
                <display:column titleKey="step.delivery.hours" class="colcenter"/>
                <display:column titleKey="step.delivery.status" class="colcenter"/>
                <display:column titleKey="step.delivery.comment"/>
            </c:if>
            
            <c:if test="${not empty pageScope.s.suiviEtape}">
                <display:column titleKey="step.name" sortable="true">
                    ${pageScope.s.suiviEtape.etape.eleveur.raisonSociale}
                </display:column>
                <display:column titleKey="step.charged" class="colcenter"/>
                <display:column titleKey="step.delivery.purge" class="colcenter">
                    <s:label categorie="PGE" id="${pageScope.s.suiviEtape.CREtape.purge}"/>
                </display:column>
                <display:column titleKey="step.delivery.hours" class="colcenter">
                    <fmt:formatDate value="${pageScope.s.suiviEtape.CREtape.etapeHeureLivraison}" pattern="HH:mm"/>
                </display:column>
                <display:column titleKey="step.delivery.status" class="colcenter">
                    <s:label categorie="CLS" id="${pageScope.s.suiviEtape.CREtape.livraisonStatut}"/>
                </display:column>
                <display:column titleKey="step.delivery.comment">
                    ${pageScope.s.suiviEtape.CREtape.commentaireLivraison}
                </display:column>
            </c:if>
            
            <c:if test="${not empty pageScope.s.usine}">
                <display:column titleKey="step.name" sortable="true">
                    ${pageScope.s.usine.code}
                </display:column>
                <display:column titleKey="step.charged" class="colcenter"/>
                <display:column titleKey="step.delivery.purge" class="colcenter"/>
                <display:column titleKey="step.delivery.hours" class="colcenter"/>
                <display:column titleKey="step.delivery.status" class="colcenter"/>
                <display:column titleKey="step.delivery.comment"/>
            </c:if>
            
            <c:if test="${not empty pageScope.s.suiviUsine}">
                <display:column titleKey="step.name" sortable="true">
                    ${pageScope.s.suiviUsine.usine.code}
                </display:column>
                <display:column titleKey="step.charged" class="colcenter">
                    ${pageScope.s.suiviUsine.chargePar}
                </display:column>
                <display:column titleKey="step.delivery.purge" class="colcenter"/>
                <display:column titleKey="step.delivery.hours" class="colcenter"/>
                <display:column titleKey="step.delivery.status" class="colcenter"/>
                <display:column titleKey="step.delivery.comment"/>
            </c:if>

            <display:column titleKey="common.action" class="action">
                <html:link styleClass="button go" action="/appli/tour/report.do" paramId="tour" paramName="s" paramProperty="tour.topiaId"><fmt:message key="tour.report.title"/></html:link>
                <html:link styleClass="button go" action="/appli/tour/step/list.do" paramId="tour" paramName="s" paramProperty="tour.topiaId"><fmt:message key="step.list.title"/></html:link>
            </display:column>

        </display:table>
        
        <%@include file="../common/footer.jsp"%>
    </body>
    
</html>
