<%@include file="../common/taglibs.jsp"%>

<s:authorization expression="com.cybelia.sandra.entities.Tour#*" actions="LOAD"/>

<html>
    
    <script src="${applicationSession.googleMapKey}"  type="text/javascript"></script>

    <script type="text/javascript">

        var map;
        function Coord(x, y, num, type){
            this.x = x;
            this.y = y;
            this.num = num;
            // type values :
            // 1 : GPS enabled
            // 2 : GPS not enabled
            // 3 : is an usine
            this.type = type;
        }
        var coords = new Array();

        function initialize() {
          if (GBrowserIsCompatible()) {
              if (coords.length != 0){

                  // Init map
                  map = new GMap2(document.getElementById("map"));
                  map.addControl(new GSmallMapControl());
                  map.addControl(new GMapTypeControl());
                  map.addControl(new GScaleControl());

                  // Calcule du pts central
                  var xCenter = 0;
                  var yCenter = 0;
                  var minX = 90;
                  var minY = 90;
                  var maxX = 0;
                  var maxY = 0;

                  var nb = 0;
                  for (var i=0;i<coords.length;i++){
                     var c = coords[i];

                     xCenter += c.x;
                     yCenter += c.y;
                     if (c.x <= minX)
                         minX = c.x;
                     if (c.x >= maxX)
                         maxX = c.x;
                     if (c.y <= minY)
                         minY = c.y;
                     if (c.Y >= minY)
                         maxY = c.y;
                     nb++;
                  }

                  // Calcule de la moyenne
                  xCenter = xCenter / nb;
                  yCenter = yCenter / nb;

                  // Initialisation du centre
                  var center = new GLatLng(xCenter, yCenter);

                  // Calcul du zoom
                  var bounds = new GLatLngBounds;
                  bounds.extend(new GLatLng(minX, minY));
                  bounds.extend(new GLatLng(maxX, maxY));
                  var zoom = map.getBoundsZoomLevel(bounds);

                  // Init map
                  map.setCenter(center, zoom);

                  // Ajout des balises
                  for (var i=0;i<coords.length;i++){
                     var c = coords[i];
                     var usineIcon = new GIcon(G_DEFAULT_ICON);
                     usineIcon.image = "../../../images/maps/blue/marker" + c.num + ".png";
                     var greenIcon = new GIcon(G_DEFAULT_ICON);
                     greenIcon.image = "../../../images/maps/green/marker" + c.num + ".png";
                     var redIcon = new GIcon(G_DEFAULT_ICON);
                     redIcon.image = "../../../images/maps/red/marker" + c.num + ".png";
                     if (c.type == 1)
                         map.addOverlay(new GMarker(new GLatLng(parseFloat(c.x), parseFloat(c.y)), greenIcon));
                     if (c.type == 2)
                         map.addOverlay(new GMarker(new GLatLng(parseFloat(c.x), parseFloat(c.y)), redIcon));
                     if (c.type == 3)
                         map.addOverlay(new GMarker(new GLatLng(parseFloat(c.x), parseFloat(c.y)), usineIcon));
                  }
              }
          }
        }

        function addStep(lng, lat, num, type) {
            var latitude = parseFloat(lat);
            var longitude = parseFloat(lng);
            coords.push(new Coord(latitude, longitude, num, type));
        }

        function addAdress(adresse, name, num, type) {
            var localiser = new GClientGeocoder();
            localiser.getLatLng(adresse + " " + name, function(point){
                if (point != null){
                    var longitude= parseFloat(point.x);
                    var latitude = parseFloat(point.y);
                    coords.push(new Coord(latitude, longitude,  num, type));
                    initialize();
                }
                else{
                    // Si l'adresse n'est pas trouv�, l'on r�ssai avec le code postal et la ville
                    if (adresse!=""){
                        addAdress("", name, num, type);
                    }
                    else{
                        window.alert("Impossible de trouver les coordonnees pour l'adresse de l'etape num " + num);
                    }
                }
            });
        }

    </script>
    <body onunload="GUnload()">
        <%@include file="../common/header.jsp"%>
        <div class="subtitle">
            <fmt:message key="step.list.title"/>
            <c:if test="${not empty requestScope.tour}">
                : <fmt:formatDate value="${requestScope.tour.dateLivraison}" pattern="${date_pattern_short}"/> - ${requestScope.tour.camion.societe.code}-${requestScope.tour.camion.code} - ${requestScope.tour.numero} - <s:tour tour="${requestScope.tour}" method="driver"/>
            </c:if>
        </div>

        <div id="criteria">
            <jsp:include page="criteria.jsp">
                <jsp:param name="action" value="/appli/tour/step/list/search"/>
                <jsp:param name="doAction" value="/appli/tour/list.do"/>
            </jsp:include>
        </div>
        
        <display:table name="requestScope.steps" id="s" requestURI="/appli/tour/step/list.do" sort="list" defaultsort="1" defaultorder="ascending" pagesize="25" export="true">
            <display:setProperty name="export.excel.filename" value="steps.xls" />

            <c:if test="${empty requestScope.tour}">
                <display:column titleKey="tour.delivery" sortable="true" group="1" class="colcenter">
                    <fmt:formatDate value="${pageScope.s.tour.dateLivraison}" pattern="${date_pattern_short}"/>
                </display:column>
                <display:column titleKey="tour.truck" sortable="true" group="1" class="colcenter">
                    <s:naming topiaId="${pageScope.s.tour.camion.topiaId}"/>
                </display:column>
                <display:column titleKey="tour.number" sortable="true" group="1" class="colcenter">
                    ${pageScope.s.tour.numero}
                </display:column>
                <display:column titleKey="tour.driver" sortable="true" group="1">
                    <s:tour tour="${pageScope.s.tour}" method="driver"/>
                </display:column>
            </c:if>

            <c:if test="${not empty pageScope.s.etape}">
                <display:column titleKey="step.number" sortable="true" group="2" class="colcenter">
                    ${pageScope.s.etape.ordre}
                </display:column>
                <display:column titleKey="step.quantity" sortable="true" class="colcenter">
                    <s:step etape="${pageScope.s.etape}" method="quantity"/>
                </display:column>
                <display:column titleKey="silo.securityLevel" sortable="true" class="colcenter">
                    <c:if test="${pageScope.s.etape.eleveur.accesEleveur.niveauSecurite == 1}">
                        <img src="<c:url value="/images/silo_vert.jpg"/>"/>
                    </c:if>
                    <c:if test="${pageScope.s.etape.eleveur.accesEleveur.niveauSecurite == 2}">
                        <img src="<c:url value="/images/silo_orange.jpg"/>"/>
                    </c:if>
                    <c:if test="${pageScope.s.etape.eleveur.accesEleveur.niveauSecurite == 3}">
                        <img src="<c:url value="/images/silo_rouge.jpg"/>"/>
                    </c:if>
                    <c:if test="${pageScope.s.etape.eleveur.accesEleveur.niveauSecurite == 4}">
                        <img src="<c:url value="/images/silo_gris.jpg"/>"/>
                    </c:if>
                </display:column>
                <display:column titleKey="step.name" sortable="true" group="2">
                    ${pageScope.s.etape.eleveur.raisonSociale}
                </display:column>
                <display:column titleKey="step.address" group="2">
                    <c:if test="${not empty requestScope.tour}">
                        <c:if test="${pageScope.s.etape.eleveur.tomtomGPS != null}">
                            <script type="text/javascript">
                                addStep("${pageScope.s.etape.eleveur.tomtomGPS.point.x}", "${pageScope.s.etape.eleveur.tomtomGPS.point.y}", ${pageScope.s.number}, 1);
                            </script>
                        </c:if>
                        <c:if test="${pageScope.s.etape.eleveur.tomtomGPS == null}">
                            <script type="text/javascript">
                                addAdress("${pageScope.s.etape.eleveur.adresse}", "${pageScope.s.etape.eleveur.codePostal} ${pageScope.s.etape.eleveur.ville}", ${pageScope.s.number}, 2);
                            </script>
                        </c:if>
                    </c:if>
                    ${pageScope.s.etape.eleveur.adresse} - ${pageScope.s.etape.eleveur.codePostal} ${pageScope.s.etape.eleveur.ville}
                </display:column>
                <display:column titleKey="step.phone" group="2" class="colcenter">
                    ${pageScope.s.etape.eleveur.telephone} ${pageScope.s.etape.eleveur.mobile}
                </display:column>
                <display:column titleKey="step.gps" class="colcenter">
                    <c:choose>
                        <c:when test="${pageScope.s.etape.eleveur.nbTomTomGPSModif > 3}">
                            <img src="<c:url value="/images/tom-tom-small-blue-block.jpg"/>"/>
                        </c:when>
                        <c:when test="${empty pageScope.s.etape.eleveur.tomtomGPS}">
                            <img src="<c:url value="/images/tom-tom-small.jpg"/>"/>
                        </c:when>
                        <c:otherwise>
                            <c:choose>
                                <c:when test="${pageScope.s.etape.eleveur.tomtomGPS.point.x == 0}">
                                    <c:choose>
                                        <c:when test="${pageScope.s.etape.eleveur.tomtomGPS.point.y == 0}">
                                            <img src="<c:url value="/images/tom-tom-small.jpg"/>"/>
                                        </c:when>
                                        <c:otherwise>
                                            <img src="<c:url value="/images/tom-tom-small-blue.jpg"/>"/>
                                        </c:otherwise>
                                    </c:choose>
                                </c:when>             
                                <c:otherwise>
                                    <img src="<c:url value="/images/tom-tom-small-blue.jpg"/>"/>
                                </c:otherwise>
                            </c:choose>
                        </c:otherwise>
                    </c:choose>
                </display:column>
                <display:column titleKey="product.order.comment">
                    <s:productComment products="${pageScope.s.etape.produits}"/>
                </display:column>
            </c:if>
            
            <c:if test="${not empty pageScope.s.suiviEtape}">
                <display:column titleKey="step.number" sortable="true" group="2" class="colcenter">
                    ${pageScope.s.suiviEtape.etape.ordre}
                </display:column>
                <display:column titleKey="step.quantity" sortable="true" class="colcenter">
                    <s:step etape="${pageScope.s.suiviEtape.etape}" method="quantity"/>
                </display:column>
                <display:column titleKey="silo.securityLevel" sortable="true" class="colcenter">
                    <c:if test="${pageScope.s.suiviEtape.etape.eleveur.accesEleveur.niveauSecurite == 1}">
                        <img src="<c:url value="/images/silo_vert.jpg"/>"/>
                    </c:if>
                    <c:if test="${pageScope.s.suiviEtape.etape.eleveur.accesEleveur.niveauSecurite == 2}">
                        <img src="<c:url value="/images/silo_orange.jpg"/>"/>
                    </c:if>
                    <c:if test="${pageScope.s.suiviEtape.etape.eleveur.accesEleveur.niveauSecurite == 3}">
                        <img src="<c:url value="/images/silo_rouge.jpg"/>"/>
                    </c:if>
                    <c:if test="${pageScope.s.suiviEtape.etape.eleveur.accesEleveur.niveauSecurite == 4}">
                        <img src="<c:url value="/images/silo_gris.jpg"/>"/>
                    </c:if>
                </display:column>
                <display:column titleKey="step.name" sortable="true" group="2">
                    ${pageScope.s.suiviEtape.etape.eleveur.raisonSociale}
                </display:column>
                <display:column titleKey="step.address" group="2">
                    <c:if test="${not empty requestScope.tour}">
                        <c:if test="${pageScope.s.suiviEtape.etape.eleveur.tomtomGPS != null}">
                            <script type="text/javascript">
                                addStep("${pageScope.s.suiviEtape.etape.eleveur.tomtomGPS.point.x}", "${pageScope.s.suiviEtape.etape.eleveur.tomtomGPS.point.y}", ${pageScope.s.number}, 1);
                            </script>
                        </c:if>
                        <c:if test="${pageScope.s.suiviEtape.etape.eleveur.tomtomGPS == null}">
                            <script type="text/javascript">
                                addAdress("${pageScope.s.suiviEtape.etape.eleveur.adresse}", "${pageScope.s.suiviEtape.etape.eleveur.codePostal} ${pageScope.s.suiviEtape.etape.eleveur.ville}", ${pageScope.s.number}, 2);
                            </script>
                        </c:if>
                    </c:if>
                    ${pageScope.s.suiviEtape.etape.eleveur.adresse} - ${pageScope.s.suiviEtape.etape.eleveur.codePostal} ${pageScope.s.suiviEtape.etape.eleveur.ville}
                </display:column>
                <display:column titleKey="step.phone" group="2" class="colcenter">
                    ${pageScope.s.suiviEtape.etape.eleveur.telephone} ${pageScope.s.suiviEtape.etape.eleveur.mobile}
                </display:column>
                <display:column titleKey="step.gps" class="colcenter">
                    <c:choose>
                        <c:when test="${pageScope.s.suiviEtape.etape.eleveur.nbTomTomGPSModif > 3}">
                            <img src="<c:url value="/images/tom-tom-small-blue-block.jpg"/>"/>
                        </c:when>
                        <c:when test="${empty pageScope.s.suiviEtape.etape.eleveur.tomtomGPS}">
                            <img src="<c:url value="/images/tom-tom-small.jpg"/>"/>
                        </c:when>
                        <c:otherwise>
                            <c:choose>
                                <c:when test="${pageScope.s.suiviEtape.etape.eleveur.tomtomGPS.point.x == 0}">
                                    <c:choose>
                                        <c:when test="${pageScope.s.suiviEtape.etape.eleveur.tomtomGPS.point.y == 0}">
                                            <img src="<c:url value="/images/tom-tom-small.jpg"/>"/>
                                        </c:when>
                                        <c:otherwise>
                                            <img src="<c:url value="/images/tom-tom-small-blue.jpg"/>"/>
                                        </c:otherwise>
                                    </c:choose>
                                </c:when>
                                <c:otherwise>
                                    <img src="<c:url value="/images/tom-tom-small-blue.jpg"/>"/>
                                </c:otherwise>
                            </c:choose>
                        </c:otherwise>
                    </c:choose>
                </display:column>
                <display:column titleKey="product.order.comment" class="colcenter">
                    <s:productComment products="${pageScope.s.suiviEtape.etape.produits}"/>
                </display:column>
            </c:if>
            
            <c:if test="${not empty pageScope.s.usine}">
                <display:column titleKey="step.number" sortable="true" group="2" class="colcenter">
                    0
                </display:column>
                <display:column titleKey="step.quantity" sortable="true" class="colcenter"/>
                <display:column titleKey="silo.securityLevel" sortable="true" class="colcenter"/>
                <display:column titleKey="step.name" sortable="true" group="2">
                    ${pageScope.s.usine.code}
                </display:column>
                <display:column titleKey="step.address" group="2">
                    <c:if test="${not empty requestScope.tour}">
                         <c:if test="${pageScope.s.usine.tomtomGPS != null}">
                            <script type="text/javascript">
                                addStep("${pageScope.s.usine.tomtomGPS.point.x}", "${pageScope.s.usine.tomtomGPS.point.y}", ${pageScope.s.number}, 3);
                            </script>
                        </c:if>
                        <c:if test="${pageScope.s.usine.tomtomGPS == null}">
                            <script type="text/javascript">
                                addAdress("${pageScope.s.usine.adresse}", "${pageScope.s.usine.codePostal} ${pageScope.s.usine.ville}", ${pageScope.s.number}, 3);
                            </script>
                        </c:if>
                    </c:if>
                    ${pageScope.s.usine.ville}
                </display:column>
                <display:column titleKey="step.phone" group="2" class="colcenter"/>
                <display:column titleKey="step.gps" class="colcenter">
                    <c:choose>
                        <c:when test="${pageScope.s.usine.blockGPSModif}">
                            <img src="<c:url value="/images/tom-tom-small-blue-block.jpg"/>"/>
                        </c:when>
                        <c:when test="${empty pageScope.s.usine.tomtomGPS}">
                            <img src="<c:url value="/images/tom-tom-small.jpg"/>"/>
                        </c:when>
                        <c:otherwise>
                            <img src="<c:url value="/images/tom-tom-small-blue.jpg"/>"/>
                        </c:otherwise>
                    </c:choose>
                </display:column>
                <display:column titleKey="product.order.comment"/>
            </c:if>
            
            <c:if test="${not empty pageScope.s.suiviUsine}">
                <display:column titleKey="step.number" sortable="true" group="2" class="colcenter">
                    0
                </display:column>
                <display:column titleKey="step.quantity" sortable="true" class="colcenter"/>
                <display:column titleKey="silo.securityLevel" sortable="true" class="colcenter"/>
                <display:column titleKey="step.name" sortable="true" group="2">
                    ${pageScope.s.suiviUsine.usine.code}
                </display:column>
                <display:column titleKey="step.address" group="2">
                    <c:if test="${not empty requestScope.tour}">
                         <c:if test="${pageScope.s.suiviUsine.usine.tomtomGPS != null}">
                            <script type="text/javascript">
                                addStep("${pageScope.s.suiviUsine.usine.tomtomGPS.point.x}", "${pageScope.s.suiviUsine.usine.tomtomGPS.point.y}", ${pageScope.s.number}, 3);
                            </script>
                        </c:if>
                        <c:if test="${pageScope.s.suiviUsine.usine.tomtomGPS == null}">
                            <script type="text/javascript">
                                addAdress("${pageScope.s.suiviUsine.usine.adresse}", "${pageScope.s.suiviUsine.usine.codePostal} ${pageScope.s.suiviUsine.usine.ville}", ${pageScope.s.number}, 3);
                            </script>
                        </c:if>
                    </c:if>
                    ${pageScope.s.suiviUsine.usine.ville}
                </display:column>
                <display:column titleKey="step.phone" group="2" class="colcenter"/>
                <display:column titleKey="step.gps" class="colcenter">
                    <c:choose>
                        <c:when test="${pageScope.s.suiviUsine.usine.blockGPSModif}">
                            <img src="<c:url value="/images/tom-tom-small-blue-block.jpg"/>"/>
                        </c:when>
                        <c:when test="${empty pageScope.s.suiviUsine.usine.tomtomGPS}">
                            <img src="<c:url value="/images/tom-tom-small.jpg"/>"/>
                        </c:when>
                        <c:otherwise>
                            <img src="<c:url value="/images/tom-tom-small-blue.jpg"/>"/>
                        </c:otherwise>
                    </c:choose>
                </display:column>
                <display:column titleKey="product.order.comment"/>
            </c:if>
            
            <display:column titleKey="common.action" class="colright action" media="html">
                <c:if test="${not empty pageScope.s.etape}">
                    <html:link styleClass="button go" action="/appli/breeder/view.do" paramId="topiaId" paramName="s" paramProperty="etape.eleveur.topiaId"><fmt:message key="breeder.view.title"/></html:link>
                </c:if>
                <c:if test="${not empty pageScope.s.suiviEtape}">
                    <html:link styleClass="button go" action="/appli/breeder/view.do" paramId="topiaId" paramName="s" paramProperty="suiviEtape.etape.eleveur.topiaId"><fmt:message key="breeder.view.title"/></html:link>
                </c:if>
                <c:if test="${(not empty pageScope.s.etape) || (not empty pageScope.s.suiviEtape)}">
                    <s:authorization expression="com.cybelia.sandra.entities.trace#*" actions="LOAD">
                        <html:link styleClass="button go" action="/appli/tour/step/report.do" paramId="tour" paramName="s" paramProperty="tour.topiaId"><fmt:message key="step.report.title"/></html:link>
                    </s:authorization>
                </c:if>

                <c:if test="${(not empty pageScope.s.usine) || (not empty pageScope.s.suiviUsine)}">
                    <html:link styleClass="button go" action="/appli/tour/list.do" paramId="tour" paramName="s" paramProperty="tour.topiaId"><fmt:message key="tour.list.title"/></html:link>
                    <s:authorization expression="com.cybelia.sandra.entities.trace#*" actions="LOAD">
                        <html:link styleClass="button go" action="/appli/tour/report.do" paramId="tour" paramName="s" paramProperty="tour.topiaId"><fmt:message key="tour.report.title"/></html:link>
                    </s:authorization>
                    <html:link styleClass="button go" action="/appli/tour/product/list.do" paramId="tour" paramName="s" paramProperty="tour.topiaId"><fmt:message key="product.list.title"/></html:link>
                </c:if>
            </display:column>
        
        </display:table>

        <c:if test="${not empty requestScope.tour}">
            <div id="mapPanel" class="mapPanel">
                <div id="map" class="stepMap">&nbsp;</div>
                <div id="mapLegend" class="mapLegend">
                    <p class="colorGreen"><fmt:message key="step.gpsIsEnabled"/></p>
                    <p class="colorRed"><fmt:message key="step.gpsIsNotEnabled"/></p>
                    <p class="colorUsine"><fmt:message key="step.usine"/></p>
                    <br class="bigspace"/>
                    <c:if test="${not empty requestScope.toursNav}">
                        <p>
                            <c:forEach begin="0" end="${fn:length(requestScope.toursNav)}" var='t' items="${requestScope.toursNav}" varStatus="vs">
                                <c:if test="${requestScope.tour.topiaId == t.topiaId}">
                                    <c:if test="${!vs.first}">
                                        <c:forEach begin="${vs.index - 1}" end="${vs.index - 1}" var='tp' items="${requestScope.toursNav}" varStatus="vsp">
                                            <html:link styleClass="button previous left" action="/appli/tour/step/list.do" paramId="tour" paramName="tp" paramProperty="topiaId"><fmt:message key="common.previous"/></html:link>
                                        </c:forEach>
                                    </c:if>
                                    <c:if test="${!vs.last}">
                                        <c:forEach begin="${vs.index + 1}" end="${vs.index + 1}" var='ts' items="${requestScope.toursNav}" varStatus="vsp">
                                            <html:link styleClass="button next right" action="/appli/tour/step/list.do" paramId="tour" paramName="ts" paramProperty="topiaId"><fmt:message key="common.next"/></html:link>
                                        </c:forEach>
                                    </c:if>
                                </c:if>
                            </c:forEach>
                        </p>
                    </c:if>
                </div>
            </div>
        </c:if>
        <script>
            initialize();
        </script>

        <%@include file="../common/footer.jsp"%>
    </body>
    
</html>
