<%@include file="../common/taglibs.jsp"%>
<s:authorization expression="com.cybelia.sandra.entities.Tour#*" actions="LOAD"/>

<html>
    <body>
        <%@include file="../common/header.jsp"%>
        
        <div class="subtitle">
            <fmt:message key="product.list.title"/>
            <c:if test="${not empty requestScope.tour}">
                : <fmt:formatDate value="${requestScope.tour.dateLivraison}" pattern="${date_pattern_short}"/> - ${requestScope.tour.camion.societe.code}-${requestScope.tour.camion.code} - ${requestScope.tour.numero} - <s:tour tour="${requestScope.tour}" method="driver"/>
            </c:if>
        </div>

        <div id="criteria">
            <jsp:include page="criteria.jsp">
                <jsp:param name="action" value="/appli/tour/step/list/search"/>
                <jsp:param name="doAction" value="/appli/tour/product/list.do"/>
            </jsp:include>
        </div>

        <display:table name="requestScope.steps" id="s" requestURI="/appli/tour/product/list.do" sort="list" defaultsort="1" defaultorder="ascending" pagesize="25">
            
            <c:if test="${empty requestScope.tour}">
                <display:column titleKey="tour.delivery" sortable="true" group="1" class="colcenter">
                    <fmt:formatDate value="${pageScope.s.tour.dateLivraison}" pattern="${date_pattern_short}"/>
                </display:column>
                <display:column titleKey="tour.truck" sortable="true" group="1" class="colcenter">
                    <s:naming topiaId="${pageScope.s.tour.camion.topiaId}"/>
                </display:column>
                <display:column titleKey="tour.number" sortable="true" group="1" class="colcenter">
                    ${pageScope.s.tour.numero}
                </display:column>
                <display:column titleKey="tour.driver" sortable="true" group="1">
                    <s:tour tour="${pageScope.s.tour}" method="driver"/>
                </display:column>
            </c:if>

            <display:column titleKey="step.number" sortable="true" group="2" class="colcenter" property="number"/>

            <c:if test="${not empty pageScope.s.etape}">
                <display:column titleKey="step.order" sortable="true" group="2" class="hiddenColumn" headerClass="hiddenColumn">
                    ${pageScope.s.etape.ordre}
                </display:column>
                <display:column titleKey="step.product.order" sortable="true" group="2" class="hiddenColumn" headerClass="hiddenColumn">
                    ${pageScope.s.product.ordre}
                </display:column>
                <display:column titleKey="step.commande.number" sortable="true" group="2" class="hiddenColumn" headerClass="hiddenColumn">
                    ${pageScope.s.product.commande.numero}
                </display:column>
                <display:column titleKey="step.name" sortable="true">
                    ${pageScope.s.etape.eleveur.ville} (${pageScope.s.etape.eleveur.codeRegion}) ${pageScope.s.etape.eleveur.raisonSociale}
                </display:column>
                <display:column titleKey="product.compartments" class="colcenter">
                    ${pageScope.s.product.infoChargement.compartiments}
                </display:column>
                <display:column titleKey="product.name">
                    ${pageScope.s.product.libelle}
                </display:column>
                <display:column titleKey="product.presentation" class="colcenter">
                    ${pageScope.s.product.presentation}
                </display:column>
                <display:column titleKey="product.capacity" class="colcenter">
                    ${pageScope.s.product.capaciteUnitaire}
                </display:column>
                <display:column titleKey="product.quantity.toBeCharged" class="colright">
                    ${pageScope.s.product.quantiteACharger}
                </display:column>
                <display:column titleKey="product.quantity.charged" class="colright">
                    ${pageScope.s.product.infoChargement.quantite}
                </display:column>
                <display:column titleKey="product.silo" class="colcenter">
                    ${pageScope.s.product.nomSilo}
                </display:column>
                <display:column titleKey="product.acess" class="colcenter">
                    ${pageScope.s.product.acces}
                </display:column>
                <display:column titleKey="product.equipment" class="colcenter">
                    ${pageScope.s.product.equipement}
                </display:column>
                <display:column titleKey="product.comment">
                    ${pageScope.s.product.commentaire}
                </display:column>
            </c:if>
            
            <c:if test="${not empty pageScope.s.suiviEtape}">
                <display:column titleKey="step.order" sortable="true" group="2" class="hiddenColumn" headerClass="hiddenColumn">
                    ${pageScope.s.suiviEtape.etape.ordre}
                </display:column>
                <display:column titleKey="step.product.order" sortable="true" group="2" class="hiddenColumn" headerClass="hiddenColumn">
                    ${pageScope.s.product.ordre}
                </display:column>
                <display:column titleKey="step.commande.number" sortable="true" group="2" class="hiddenColumn" headerClass="hiddenColumn">
                    ${pageScope.s.product.commande.numero}
                </display:column>
                <display:column titleKey="step.name" sortable="true">
                    ${pageScope.s.suiviEtape.etape.eleveur.ville} (${pageScope.s.suiviEtape.etape.eleveur.codeRegion}) ${pageScope.s.suiviEtape.etape.eleveur.raisonSociale}
                </display:column>
                <display:column titleKey="product.compartments" class="colcenter">
                    <c:choose>
                        <c:when test="${not empty pageScope.s.suiviProduct}">
                            ${pageScope.s.suiviProduct.compartiments}
                        </c:when>
                        <c:otherwise>
                            ${pageScope.s.product.infoChargement.compartiments}
                        </c:otherwise>
                    </c:choose>
                </display:column>
                <display:column titleKey="product.name">
                    ${pageScope.s.product.libelle}
                </display:column>
                <display:column titleKey="product.presentation" class="colcenter">
                    ${pageScope.s.product.presentation}
                </display:column>
                <display:column titleKey="product.capacity" class="colcenter">
                    ${pageScope.s.product.capaciteUnitaire}
                </display:column>
                <display:column titleKey="product.quantity.toBeCharged" class="colright">
                    ${pageScope.s.product.quantiteACharger}
                </display:column>
                <display:column titleKey="product.quantity.charged" class="colright">
                    <c:choose>
                        <c:when test="${not empty pageScope.s.suiviProduct}">
                            ${pageScope.s.suiviProduct.quantite}
                        </c:when>
                        <c:otherwise>
                            ${pageScope.s.product.infoChargement.quantite}
                        </c:otherwise>
                    </c:choose>
                </display:column>
                <display:column titleKey="product.silo" class="colcenter">
                    ${pageScope.s.product.nomSilo}
                </display:column>
                <display:column titleKey="product.acess" class="colcenter">
                    ${pageScope.s.product.acces}
                </display:column>
                <display:column titleKey="product.equipment" class="colcenter">
                    ${pageScope.s.product.equipement}
                </display:column>
                <display:column titleKey="product.comment">
                    ${pageScope.s.product.commentaire}
                </display:column>
            </c:if>
            
            <c:if test="${not empty pageScope.s.usine}">
                <display:column titleKey="step.order" class="hiddenColumn" headerClass="hiddenColumn"/>
                <display:column titleKey="step.product.order" class="hiddenColumn" headerClass="hiddenColumn"/>
                <display:column titleKey="step.commande.number" class="hiddenColumn" headerClass="hiddenColumn"/>
                <display:column titleKey="step.name" sortable="true">
                    ${pageScope.s.usine.code}
                </display:column>
                <display:column titleKey="product.compartments" class="colcenter"/>
                <display:column titleKey="product.name"/>
                <display:column titleKey="product.presentation" class="colcenter"/>
                <display:column titleKey="product.capacity" class="colcenter"/>
                <display:column titleKey="product.quantity.toBeCharged" class="coltight"/>
                <display:column titleKey="product.quantity.charged" class="colright"/>
                <display:column titleKey="product.silo" class="colcenter"/>
                <display:column titleKey="product.acess" class="colcenter"/>
                <display:column titleKey="product.equipment" class="colcenter"/>
                <display:column titleKey="product.comment"/>
            </c:if>
            
            <c:if test="${not empty pageScope.s.suiviUsine}">
                <display:column titleKey="step.order" class="hiddenColumn" headerClass="hiddenColumn"/>
                <display:column titleKey="step.product.order" class="hiddenColumn" headerClass="hiddenColumn"/>
                <display:column titleKey="step.commande.number" class="hiddenColumn" headerClass="hiddenColumn"/>
                <display:column titleKey="step.name" sortable="true">
                    ${pageScope.s.suiviUsine.usine.code}
                </display:column>
                <display:column titleKey="product.compartments" class="colcenter"/>
                <display:column titleKey="product.name"/>
                <display:column titleKey="product.presentation" class="colcenter"/>
                <display:column titleKey="product.capacity" class="colcenter"/>
                <display:column titleKey="product.quantity.toBeCharged" class="colright"/>
                <display:column titleKey="product.quantity.charged" class="colright"/>
                <display:column titleKey="product.silo" class="colcenter"/>
                <display:column titleKey="product.acess" class="colcenter"/>
                <display:column titleKey="product.equipment" class="colcenter"/>
                <display:column titleKey="product.comment"/>
            </c:if>
            
            <display:column titleKey="common.action" class="action">
                <html:link styleClass="button go" action="/appli/tour/list.do" paramId="tour" paramName="s" paramProperty="tour.topiaId"><fmt:message key="tour.list.title"/></html:link>
                <html:link styleClass="button go" action="/appli/tour/step/list.do" paramId="tour" paramName="s" paramProperty="tour.topiaId"><fmt:message key="step.list.title"/></html:link>
            </display:column>

        </display:table>
        
        <%@include file="../common/footer.jsp"%>
    </body>
    
</html>
