<%@include file="../common/taglibs.jsp" %>

<script>
    $(document).ready(function(){
        $('#dateStart').datepicker();
        $('#dateEnd').datepicker();
    });
</script>
<%
    String action = request.getParameter("action");
    String doAction = request.getParameter("doAction");
%>

<html:form action="<%=action%>" method="POST">
    <div class="criteria">
        <div>
            <label for="dateStart"><fmt:message key="criteria.from"/><span class="required">*</span> :</label>
        </div>
        <div>
            <fmt:formatDate value="${criteria.dateStart}" var="dateStart" pattern="${date_pattern_long}"/>
            <html:text property="dateStart" styleId="dateStart" size="8" maxlength="8" value="${dateStart}"/>
        </div>
    </div>

    <div class="criteria">
        <div>
            <label for="dateEnd"><fmt:message key="criteria.to"/><span class="required">*</span> :</label>
        </div>
        <div>
            <fmt:formatDate value="${criteria.dateEnd}" var="dateEnd" pattern="${date_pattern_long}"/>
            <html:text property="dateEnd" styleId="dateEnd" size="8" maxlength="8" value="${dateEnd}"/>
        </div>
    </div>

    <div class="criteria">
        <div>
            <label for="planified"><fmt:message key="criteria.planified"/> :</label>
        </div>
        <div class="input">
            <html:checkbox property="planified" styleId="planified"/>
            <input type="hidden" name="planified" value="false"/>
        </div>
    </div>

    <div class="criteria">
        <div>
            <label for="terminated"><fmt:message key="criteria.terminated"/> :</label>
        </div>
        <div>
            <html:checkbox property="terminated" styleId="terminated"/>
            <input type="hidden" name="terminated" value="false"/>
        </div>
    </div>

    <div class="criteria">
        <div>
            <label for="society"><fmt:message key="criteria.society"/> :</label>
        </div>
        <div>
            <html:select property="society" styleId="society">
                <html:option value="" key="criteria.no"/>
                <html:optionsCollection name="applicationSession" property="namingSocietes" label="value" value="key"/>
            </html:select>
        </div>
    </div>

    <div class="criteria">
        <div>
            <label for="transporter"><fmt:message key="criteria.transporter"/> :</label>
        </div>
        <div>
            <html:select property="transporter" styleId="transporter">
                <html:option value="" key="criteria.no"/>
                <html:optionsCollection name="applicationSession" property="namingTransporteurs" label="value" value="key"/>
            </html:select>
        </div>
    </div>

    <div class="criteria">
        <div>
            <label for="truck"><fmt:message key="criteria.truck"/> :</label>
        </div>
        <div>
            <html:select property="truck" styleId="truck">
                <html:option value="" key="criteria.no"/>
                <html:optionsCollection name="applicationSession" property="namingCamionsActifs" label="value" value="key"/>
            </html:select>
        </div>
    </div>

    <div class="criteria">
        <div>
            <label for="driver"><fmt:message key="criteria.driver"/> :</label>
        </div>
        <div>
            <html:select property="driver" styleId="driver">
                <html:option value="" key="criteria.no"/>
                <html:optionsCollection name="applicationSession" property="namingChauffeurs" label="value" value="key"/>
            </html:select>
        </div>
    </div>

    <div class="criteria">
        <div>&nbsp;</div>
        <div><html:submit styleClass="search" property="apply"><fmt:message key="common.filter"/></html:submit></div>
    </div>
</html:form>

<c:if test="${not empty requestScope.tour}">
    <div class="right">
        <div>&nbsp;</div>
        <div class="button go"><html:link action="<%=doAction%>"><fmt:message key="tour.all.title"/></html:link></div>
    </div>
</c:if>
<br class="clear"/>