<%@include file="../common/taglibs.jsp" %>
<s:principal name="admin"/>

<html>
<body>
<%@include file="../common/header.jsp" %>

<div class="content">
    <div class="subtitle">
        <c:if test="${not empty requestScope.transporteur.topiaId}">
            <fmt:message key="transporteur.modify.title"/>
        </c:if>
        <c:if test="${empty requestScope.transporteur.topiaId}">
            <fmt:message key="transporteur.new.title"/>
        </c:if>
    </div>
    <div class="align-right space">
        <html:link styleClass="button go" action="/appli/ref/transporteur/list.do">
            <fmt:message key="common.backtolist"/>
        </html:link>
    </div>
    <div class="space">
        <html:form action="/appli/ref/transporteur/save" method="POST">
            <html:hidden property="topiaId"/>

            <div class="leftPart">
                <label for="code"><fmt:message key="transporteur.code"/><span class="required">*</span> :</label>
            </div>
            <div class="rightPart">
                <html:text property="code" styleId="code" size="20" maxlength="20" styleClass="fixed"/>
            </div>
            <br class="spacer"/>

            <div class="leftPart">
                <label for="name"><fmt:message key="transporteur.name"/><span class="required">*</span> :</label>
            </div>
            <div class="rightPart">
                <html:text property="name" styleId="name" size="20" maxlength="20" styleClass="fixed"/>
            </div>
            <br class="spacer"/>

            <div class="leftPart">
                <label for="societeId"><fmt:message key="transporteur.societe"/><span class="required">*</span> :</label>
            </div>
            <div class="rightPart">
                <html:select property="societeId" styleId="societeId" styleClass="fixed">
                    <html:option value="" key="society.no"/>
                    <html:optionsCollection name="applicationSession" property="namingSocietes" label="value" value="key"/>
                </html:select>
            </div>
            <br class="spacer"/>


            <div class="groupbutton">
                <html:submit styleClass="save" property="save"><fmt:message key="common.save"/></html:submit>
            </div>
            <div class="clear">&nbsp;</div>
        </html:form>
    </div>

</div>

<%@include file="../common/footer.jsp" %>
</body>

</html>
