<%@include file="../common/taglibs.jsp" %>
<s:principal name="admin"/>

<html>
<body>
<%@include file="../common/header.jsp" %>

<div class="content">
    <div class="subtitle">
        <c:if test="${not empty requestScope.chauffeur.topiaId}">
            <fmt:message key="chauffeur.modify.title"/>
        </c:if>
        <c:if test="${empty requestScope.chauffeur.topiaId}">
            <fmt:message key="chauffeur.new.title"/>
        </c:if>
    </div>

    <div class="align-right space">
        <html:link styleClass="button go" action="/appli/ref/chauffeur/list.do">
            <fmt:message key="common.backtolist"/>
        </html:link>
    </div>
    <div class="space">
        <html:form action="/appli/ref/chauffeur/save" method="POST">
            <html:hidden property="topiaId"/>

            <div class="leftPart">
                <label for="code"><fmt:message key="chauffeur.code"/><span class="required">*</span> :</label>
            </div>
            <div class="rightPart">
                <html:text property="code" styleId="code" size="20" maxlength="20" styleClass="fixed"/>
            </div>
            <br class="spacer"/>

            <div class="leftPart">
                <label for="nom"><fmt:message key="chauffeur.nom"/><span class="required">*</span> :</label>
            </div>
            <div class="rightPart">
                <html:text property="nom" styleId="nom" size="20" maxlength="20" styleClass="fixed"/>
            </div>
            <br class="spacer"/>

            <div class="leftPart">
                <label for="prenom"><fmt:message key="chauffeur.prenom"/><span class="required">*</span> :</label>
            </div>
            <div class="rightPart">
                <html:text property="prenom" styleId="prenom" size="20" maxlength="20" styleClass="fixed"/>
            </div>
            <br class="spacer"/>

            <div class="leftPart">
                <label for="trigramme"><fmt:message key="chauffeur.trigramme"/><span class="required">*</span> :</label>
            </div>
            <div class="rightPart">
                <html:text property="trigramme" styleId="trigramme" size="3" maxlength="3" styleClass="fixed"/>
            </div>
            <br class="spacer"/>

            <div class="leftPart">
                <label for="societeId"><fmt:message key="chauffeur.societe"/><span class="required">*</span> :</label>
            </div>
            <div class="rightPart">
                <html:select property="societeId" styleId="societeId" styleClass="fixed">
                    <html:option value="" key="societe.no"/>
                    <html:optionsCollection name="applicationSession" property="namingSocietes" label="value" value="key"/>
                </html:select>
            </div>
            <br class="spacer"/>

            <div class="groupbutton">
                <html:submit styleClass="save" property="save"><fmt:message key="common.save"/></html:submit>
            </div>
            <div class="clear">&nbsp;</div>
        </html:form>
    </div>
    <c:if test="${not empty requestScope.chauffeur.topiaId}">
        <div class="space">
            <div class="leftPart">
                <label><fmt:message key="chauffeur.available.camions"/> :</label>
            </div>
            
            <div class="rightPart">
                <div class="left">
                    <html:form action="/appli/ref/chauffeur/camions/add" method="POST">
                        <html:hidden property="topiaId"/>
                        <html:hidden property="code"/>
                        <div class="space">
                            <html:select property="selectedCamions" styleId="profil" size="20" multiple="true" styleClass="fixed">
                                <html:optionsCollection name="applicationSession" property="namingCamions" label="value" value="key"/>
                            </html:select>
                        </div>
                        <div class="align-right">
                            <html:submit styleClass="add" property="add"><fmt:message key="common.add"/></html:submit>
                        </div>
                    </html:form>
                </div>
                <div class="right">
                    <div class="space">&nbsp;</div>
                    <html:form action="/appli/ref/chauffeur/camions/delete" method="POST">
                        <html:hidden property="topiaId"/>
                        <html:hidden property="code"/>
                        <div class="space">
                            <html:select property="selectedCamions" styleId="profil" size="20" multiple="true" styleClass="fixed">
                                <c:forEach items="${requestScope.camions}" var="camion">
                                    <option value="${pageScope.camion.topiaId}"><s:naming topiaId="${pageScope.camion.topiaId}"/></option>
                                </c:forEach>
                            </html:select>
                        </div>
                        <div class="align-right">
                            <html:submit styleClass="delete" property="delete"><fmt:message key="common.delete"/></html:submit>
                        </div>
                    </html:form>
                </div>
            </div>
        </div>
    </c:if>

</div>

<%@include file="../common/footer.jsp" %>
</body>

</html>
