<%@include file="../common/taglibs.jsp" %>
<s:principal name="admin"/>

<html>
<body>
<%@include file="../common/header.jsp" %>

<div class="content">
    <div class="subtitle">
        <c:if test="${not empty requestScope.camion.topiaId}">
            <fmt:message key="camion.modify.title"/>
        </c:if>
        <c:if test="${empty requestScope.camion.topiaId}">
            <fmt:message key="camion.new.title"/>
        </c:if>
    </div>

    <div class="align-right space">
        <html:link styleClass="button go" action="/appli/ref/camion/list.do">
            <fmt:message key="common.backtolist"/>
        </html:link>
    </div>

    <div class="space">
        <html:form action="/appli/ref/camion/save" method="POST">
            <html:hidden property="topiaId"/>

            <div class="leftPart">
                <label for="code"><fmt:message key="camion.principal"/> :</label>
            </div>
            <div class="rightPart">
                <c:choose>
                    <c:when test="${not empty requestScope.camion.camionPrincipal}">
                         <s:naming topiaId="${requestScope.camion.camionPrincipal.topiaId}"/>
                    </c:when>
                    <c:when test="${not empty requestScope.camion.topiaId}">
                        Camion principal
                    </c:when>
                    <c:otherwise>
                      <html:select property="camionPrincipalId" styleId="profil" styleClass="fixed">
                        <html:option value="" key="camion.principal.no"/>
                        <html:optionsCollection name="applicationSession" property="namingCamionsPrincipaux" label="value" value="key"/>
                    </html:select>
                    </c:otherwise>
                </c:choose>
            </div>
            <br class="spacer"/>

            <div class="leftPart">
                <label for="code"><fmt:message key="camion.code"/><span class="required">*</span> :</label>
            </div>
            <div class="rightPart">
                <html:text property="code" styleId="code" size="20" maxlength="20" styleClass="fixed"/>
            </div>
            <br class="spacer"/>

            <div class="leftPart">
                <label for="nombreCompartiments"><fmt:message key="camion.nombreCompartiments"/><span
                        class="required">*</span> :</label>
            </div>
            <div class="rightPart">
                <c:choose>
                    <c:when test="${not empty requestScope.camion.topiaId}">
                        ${requestScope.camion.nombreCompartiments}
                        <html:hidden property="nombreCompartiments"/>
                    </c:when>
                    <c:when test="${not empty requestScope.camion.camionPrincipal}">
                         ${requestScope.camion.camionPrincipal.nombreCompartiments}
                        <html:hidden property="nombreCompartiments"/>
                    </c:when>
                    <c:otherwise>
                        <html:text property="nombreCompartiments" styleId="nombreCompartiments" size="5" maxlength="5" styleClass="fixed"/>
                    </c:otherwise>
                </c:choose>
            </div>
            <br class="spacer"/>

            <div class="leftPart">
                <label for="societeId"><fmt:message key="camion.societe"/><span class="required">*</span>  :</label>
            </div>
            <div class="rightPart">
                <html:select property="societeId" styleId="societeId" styleClass="fixed">
                    <html:option value="" key="society.no"/>
                    <html:optionsCollection name="applicationSession" property="namingSocietes" label="value" value="key"/>
                </html:select>
            </div>
            <br class="spacer"/>

            <div class="leftPart">
                <label for="transporteurId"><fmt:message key="camion.transporteur"/><span class="required">*</span>  :</label>
            </div>
            <div class="rightPart">
                <html:select property="transporteurId" styleId="transporteurId" styleClass="fixed">
                    <html:option value="" key="transporteur.no"/>
                    <html:optionsCollection name="applicationSession" property="namingTransporteurs" label="value" value="key"/>
                </html:select>
            </div>
            <br class="spacer"/>


            <div class="groupbutton">
                <html:submit styleClass="save" property="save"><fmt:message key="common.save"/></html:submit>
            </div>
            <div class="clear">&nbsp;</div>
        </html:form>
    </div>

</div>

<%@include file="../common/footer.jsp" %>
</body>

</html>
