<%@include file="../common/taglibs.jsp" %>
<s:principal name="admin-com.cybelia.sandra.entities.Societe"/>

<html>
    <body>
        <%@include file="../common/header.jsp" %>
        
        <div class="content">
            <div class="subtitle"><fmt:message key="cron.recipient.title"/></div>
            
            <br class="spacer"/>
            
            <div class="align-right space">
                <c:if test="${not empty requestScope.recipient.topiaId}">
                    <html:link styleClass="button go" action="/appli/cron/view.do" paramId="topiaId"
                               paramName="recipient" paramProperty="topiaId">
                        <fmt:message key="cron.modify.title"/>
                    </html:link>
                </c:if>
                <html:link styleClass="button go" action="/appli/cron/list.do">
                    <fmt:message key="common.backtolist"/>
                </html:link>
            </div>
            <div class="leftPart">
                <label for="event"><fmt:message key="cron.type"/> :</label>
            </div>
            <div class="rightPart" id="event">
                <s:naming topiaId="${requestScope.recipient.eventTopiaId}"/>
            </div>
            <br class="spacer"/>
            
            <div class="leftPart">
                <label for="label"><fmt:message key="cron.label"/> :</label>
            </div>
            <div class="rightPart" id="label">
                ${requestScope.recipient.label}
            </div>
            <br class="spacer bigspace"/>
            
            <div class="space">
                <div class="leftPart">
                    <label><fmt:message key="cron.available.user"/> :</label>
                </div>
                
                <div class="rightPart">
                    <div class="left">
                        <html:form action="/appli/recipient/add" method="POST">
                            <html:hidden property="topiaId"/>
                            <div class="space">
                                <html:select property="selected" size="10" multiple="true" styleClass="fixed">
                                    <c:forEach items="${requestScope.recipient.availableUsers}" var="user">
                                        <option value="${user}"><s:naming topiaId="${user}"/></option>
                                    </c:forEach>
                                </html:select>
                            </div>
                            <div class="align-right">
                                <html:submit styleClass="add" disabled="${empty requestScope.recipient.availableUsers}" property="add"><fmt:message key="common.add"/></html:submit>
                            </div>
                        </html:form>
                    </div>
                    <div class="right">
                        <div class="space">&nbsp;</div>
                        <html:form action="/appli/recipient/delete" method="POST">
                            <html:hidden property="topiaId"/>
                            <div class="space">
                                <html:select property="selected" size="10" multiple="true" styleClass="fixed">
                                    <c:forEach items="${requestScope.recipient.users}" var="user">
                                        <option value="${user}"><s:naming topiaId="${user}"/></option>
                                    </c:forEach>
                                </html:select>
                            </div>
                            <div class="align-right">
                                <html:submit styleClass="delete" disabled="${empty requestScope.recipient.users}" property="delete"><fmt:message key="common.delete"/></html:submit>
                            </div>
                        </html:form>
                    </div>
                </div>
            </div>
            <div class="space">
                <div class="leftPart">
                    <label><fmt:message key="cron.available.profil"/> :</label>
                </div>
                
                <div class="rightPart">
                    <div class="left">
                        <html:form action="/appli/recipient/selectProfil" method="POST" styleId="selectProfil">
                            <html:hidden property="topiaId"/>
                            <div class="space">
                                  <html:select property="profilType" styleId="profilType"
                                               onchange="document.forms['selectProfil'].submit()" styleClass="fixed">
                                      <html:option value="" key="profilType.no"/>
                                      <html:optionsCollection name="applicationSession" property="namingProfils" label="value" value="key"/>
                                  </html:select>
                            </div>
                        </html:form>

                        <html:form action="/appli/recipient/add" method="POST">
                            <html:hidden property="topiaId"/>
                            <div class="space">
                                  <label for="isAdmin"><fmt:message key="user.isAdmin"/> :</label>
                                  <html:checkbox property="isAdmin" styleId="isAdmin"/>
                                  <html:img page="/images/icons/user_red.png" altKey="user.isAdmin"/>
                            </div>
                            <div class="space">
                                <html:select property="selected" styleId="profil" size="10" multiple="true" styleClass="fixed">
                                    <c:forEach items="${requestScope.recipient.availableProfils}" var="profil">
                                        <option value="${profil}"><s:naming topiaId="${profil}"/></option>
                                    </c:forEach>
                                </html:select>
                            </div>

                            <div class="align-right">
                                <html:submit styleClass="add" disabled="${empty requestScope.recipient.availableProfils}" property="add"><fmt:message key="common.add"/></html:submit>
                            </div>
                        </html:form>
                    </div>
                    <div class="right">
                        <div class="space">&nbsp;</div>
                        <html:form action="/appli/recipient/delete" method="POST">
                            <html:hidden property="topiaId"/>
                            <div class="space">
                                <html:select property="selected" size="10" multiple="true" styleClass="fixed">
                                    <c:forEach items="${requestScope.recipient.profils}" var="profil">
                                        <option value="${profil}">
                                            <c:choose>
                                                <c:when test="${fn:startsWith(profil, 'admin-')}">
                                                    <s:naming topiaId="${fn:replace(profil, 'admin-', '')}"/> (<fmt:message key="cron.recipient.admin"/>)
                                                </c:when>
                                                <c:otherwise>
                                                    <s:naming topiaId="${profil}"/>
                                                </c:otherwise>
                                            </c:choose>
                                        </option>
                                    </c:forEach>
                                </html:select>
                            </div>
                            <div class="align-right">
                                <html:submit styleClass="delete" disabled="${empty requestScope.recipient.profils}" property="delete"><fmt:message key="common.delete"/></html:submit>
                            </div>
                        </html:form>
                    </div>
                </div>
            </div>
            <div class="space">
                <div class="leftPart">
                    <label><fmt:message key="cron.available.free"/> :</label>
                </div>
                <div class="rightPart">
                    <div class="left">
                        <html:form action="/appli/recipient/add" method="POST">
                            <html:hidden property="topiaId"/>
                            <div class="space">
                                <html:text property="selected" styleClass="fixed"/>
                            </div>
                            <div class="align-right">
                                <html:submit styleClass="add" property="add"><fmt:message key="common.add"/></html:submit>
                            </div>
                        </html:form>
                    </div>
                    <div class="right">
                        <div class="space">&nbsp;</div>
                        <html:form action="/appli/recipient/delete" method="POST">
                            <html:hidden property="topiaId"/>
                            <div class="space">
                                <html:select property="selected" size="10" multiple="true" styleClass="fixed">
                                    <c:forEach items="${requestScope.recipient.frees}" var="email">
                                        <option value="${email}">${email}</option>
                                    </c:forEach>
                                </html:select>
                            </div>
                            <div class="align-right">
                                <html:submit styleClass="delete" disabled="${empty requestScope.recipient.frees}" property="delete"><fmt:message key="common.delete"/></html:submit>
                            </div>
                        </html:form>
                    </div>
                </div>
            </div>
            
        </div>
        <%@include file="../common/footer.jsp" %>
    </body>
    
</html>
