<%@include file="../common/taglibs.jsp" %>
<s:principal name="admin-com.cybelia.sandra.entities.Societe"/>

<html>
<body>
<%@include file="../common/header.jsp" %>

<script>
    $(document).ready(function(){
        $('#dateStart').datepicker();
        $('#dateEnd').datepicker();
    });
</script>

<div class="content">

    <div class="subtitle">
        <c:choose>
            <c:when test="${empty requestScope.cron.topiaId}">
                <fmt:message key="cron.new.title"/>
            </c:when>
            <c:otherwise>
                <fmt:message key="cron.modify.title"/>
            </c:otherwise>
        </c:choose>
    </div>

    <br class="spacer"/>

    <div class="align-right space">
        <c:if test="${not empty requestScope.cron.topiaId}">
            <html:link styleClass="button email" action="/appli/recipient/view.do" paramId="topiaId"
                       paramName="cron" paramProperty="topiaId">
                <fmt:message key="cron.recipient.title"/>
            </html:link>
        </c:if>
        <html:link styleClass="button go" action="/appli/cron/list.do">
            <fmt:message key="common.backtolist"/>
        </html:link>
    </div>

    <html:form action="/appli/cron/save" method="POST">
        <html:hidden property="topiaId"/>
        <div class="leftPart">
            <label for="event"><fmt:message key="cron.type"/><span class="required">*</span> :</label>
        </div>
        <div class="rightPart">
            <c:url var="selectEvent" value="/appli/cron/selectEvent.do"/>
            <html:select property="eventTopiaId" styleId="event"
                    onchange="document.forms['cron'].action='${selectEvent}';document.forms['cron'].submit()">
                <html:option value="" key="cron.event.no"/>
                <html:optionsCollection name="applicationSession" property="namingEvents"
                                        label="value" value="key"/>
            </html:select>
        </div>

        <br class="spacer"/>

        <div class="leftPart">
            <label for="label"><fmt:message key="cron.label"/><span class="required">*</span>  :</label>
        </div>
        <div class="rightPart">
            <html:text property="label" styleClass="fixed2" styleId="label"/>
        </div>
        <br class="spacer"/>
        
        <div class="leftPart">
            <label for="label"><fmt:message key="cron.author"/> :</label>
        </div>
        <div class="rightPart">
            <c:url var="selectAuthor" value="/appli/cron/selectAuthor.do"/>
            <html:select property="authorTopiaId" styleId="author"
                    onchange="document.forms['cron'].action='${selectAuthor}';document.forms['cron'].submit()">
                <html:option value="" key="cron.author.no"/>
                <html:optionsCollection name="applicationSession" property="namingUsers"
                                        label="value" value="key"/>
            </html:select>
        </div>

        <div class="leftPart">
            <label for="enable"><fmt:message key="cron.enable"/> :</label>
        </div>
        <div class="rightPart">
            <html:checkbox property="enable" styleId="enable"/>
        </div>
        <br class="spacer"/>

        <div class="leftPart">
            <label for="dateStart"><fmt:message key="cron.dateStart"/> :</label>
        </div>
        <div class="rightPart">
            <fmt:formatDate value="${cron.dateStart}" var="dateStart" pattern="${date_pattern_long}"/>
            <html:text property="dateStart" styleId="dateStart" size="8" maxlength="8" value="${dateStart}"/>
        </div>
        <br class="spacer"/>

        <div class="leftPart">
            <label for="dateEnd"><fmt:message key="cron.dateEnd"/> :</label>
        </div>
        <div class="rightPart">
            <fmt:formatDate value="${cron.dateEnd}" var="dateEnd" pattern="${date_pattern_long}"/>
            <html:text property="dateEnd" styleId="dateEnd" size="8" maxlength="8" value="${dateEnd}"/>
        </div>
        <br class="spacer"/>

        <div class="leftPart">
            <label for="seconds"><fmt:message key="cron.expression"/> :</label>
        </div>
        <div class="rightPart">
            <div><html:text property="seconds" styleClass="fixed" styleId="seconds"/> <fmt:message key="cron.seconds"/></div><br/>
            <div><html:text property="minutes" styleClass="fixed" styleId="minutes"/> <fmt:message key="cron.minutes"/></div><br/>
            <div><html:text property="hours" styleClass="fixed" styleId="hours"/> <fmt:message key="cron.hours"/></div><br/>
            <div><html:text property="dayOfMonth" styleClass="fixed" styleId="dayOfMonth"/> <fmt:message key="cron.dayOfMonth"/></div><br/>
            <div><html:text property="month" styleClass="fixed" styleId="month"/> <fmt:message key="cron.month"/></div><br/>
            <div><html:text property="dayOfWeek" styleClass="fixed" styleId="dayOfWeek"/> <fmt:message key="cron.dayOfWeek"/></div><br/>
            <div><html:text property="year" styleClass="fixed" styleId="year"/> <fmt:message key="cron.year"/></div>
        </div>
        <br class="spacer"/>

        <div class="leftPart">
            <label for="templateModel"><fmt:message key="cron.templateModel"/> :</label>
        </div>
        <div class="rightPart">
            <c:url var="selectTemplate" value="/appli/cron/selectTemplate.do"/>
            <html:select property="templateModel" styleClass="fixed" styleId="templateModel"
                    onchange="document.forms['cron'].action='${selectTemplate}';document.forms['cron'].submit()">
                <html:option value="" key="cron.template.no"/>
                <html:options name="applicationSession" property="templates"/>
            </html:select>
        </div>
        <br class="spacer"/>

        <div class="leftPart">
            <label for="templateName"><fmt:message key="cron.templateName"/><span class="required">*</span> :</label>
        </div>
        <div class="rightPart">
            <html:text property="templateName" styleClass="fixed2" styleId="templateName"/>
        </div>
        <br class="spacer"/>

        <div class="leftPart">
            <label for="templateContent"><fmt:message key="cron.template"/> :</label>
        </div>
        <div class="rightPart">
            <html:textarea property="templateContent" rows="15" cols="80" styleClass="fixed2" styleId="templateContent"/>
        </div>
        <br class="spacer"/>

        <div class="leftPart">
            <label for="variables"><fmt:message key="cron.variables"/> :</label>
        </div>

        <div class="rightPart">
            <c:forEach items="${requestScope.cron.variables}" var="variable" varStatus="status">
                <b>&#36;&#123;${variable}&#125;</b> : <fmt:message key="cron.variables.${variable}"/>
                <br/>
            </c:forEach>
        </div>
        <br class="spacer bigspace"/>

        <div class="groupbutton">
            <c:choose>
                <c:when test="${empty requestScope.cron.topiaId}">
                    <html:submit styleClass="add" property="save"><fmt:message key="common.add"/></html:submit>
                </c:when>
                <c:otherwise>
                    <html:submit styleClass="save" property="save"><fmt:message key="common.save"/></html:submit>
                </c:otherwise>
            </c:choose>
        </div>
        <div class="clear">&nbsp;</div>

    </html:form>
    <div>
        <fmt:message key="cron.expression.help"/><br><br>
        <fmt:message key="cron.template.help"/>
    </div>

</div>
<%@include file="../common/footer.jsp" %>
</body>

</html>
