<%@include file="../common/taglibs.jsp" %>
<s:principal name="admin-com.cybelia.sandra.entities.Societe"/>

<html>
<body>
<%@include file="../common/header.jsp" %>

<div class="content">
    <div class="subtitle"><fmt:message key="cron.list.title"/></div>

    <div class="align-right space">
        <html:link styleClass="button add" action="/appli/cron/view.do"><fmt:message
                key="common.new"/></html:link>
    </div>    
    <display:table name="requestScope.beans" id="bean" requestURI="/appli/cron/list.do">

        <display:column titleKey="cron.type" class="colcenter">
            <s:naming topiaId="${pageScope.bean.event.topiaId}"/>
        </display:column>

        <display:column property="label" titleKey="cron.label" sortable="true"/>

        <display:column titleKey="cron.enable" sortable="true" sortProperty="enable" class="colcenter">
            <s:boolean value="${pageScope.bean.enable}"/>
        </display:column>

        <display:column titleKey="common.action" class="action">            
            <html:link styleClass="button go" action="/appli/cron/view.do" paramId="topiaId" paramName="bean" paramProperty="topiaId">
                <fmt:message key="cron.modify.title"/>
            </html:link>
            <html:link styleClass="button email" action="/appli/recipient/view.do" paramId="topiaId" paramName="bean" paramProperty="topiaId">
                <fmt:message key="cron.recipient.title"/>
            </html:link>
            <html:link styleClass="button delete" action="/appli/cron/delete.do" paramId="topiaId" paramName="bean" paramProperty="topiaId">
                <fmt:message key="common.delete"/>
            </html:link>
        </display:column>
    </display:table>
</div>
<%@include file="../common/footer.jsp" %>
</body>

</html>
