<%@include file="../common/taglibs.jsp" %>
<s:principal name="com.cybelia.sandra.entities.Societe, com.cybelia.sandra.entities.Usine"/>

<html>
    <body>
        <%@include file="../common/header.jsp" %>
        
        <div class="content">
            <div class="subtitle"><fmt:message key="loading.tour.title"/></div>
            
            <c:if test="${not empty requestScope.chargementTour.usineTopiaId}">
                <div class="align-right space">
                    <html:form action="/appli/loading/view" method="POST">
                        <html:hidden property="usineTopiaId" value="${requestScope.chargementTour.usineTopiaId}"/>
                        <html:hidden property="startingDateAsLong" value="${requestScope.chargementTour.startingDateAsLong}"/>
                        <html:submit styleClass="button go"><fmt:message key="loading.view.title"/></html:submit>
                    </html:form>
                </div>
                <br class="spacer"/>
            </c:if>
            
            <div class="leftPart">
                <label for="truck"><fmt:message key="tour.truck"/> :</label>
            </div>
            <div class="rightPart">
                <s:naming topiaId="${requestScope.tour.camion.topiaId}"/>
            </div>
            <br class="spacer"/>
            
            <div class="leftPart">
                <label for="number"><fmt:message key="tour.number"/> :</label>
            </div>
            <div class="rightPart">
                ${requestScope.tour.numero}
            </div>
            <br class="spacer"/>
            
            <div class="leftPart">
                <label for="driver"><fmt:message key="tour.driver"/> :</label>
            </div>
            <div class="rightPart">
                <s:tour tour="${requestScope.tour}" method="driver"/>
            </div>
            <br class="spacer"/>
            
            <div class="leftPart">
                <label for="loading"><fmt:message key="tour.loading"/> :</label>
            </div>
            <div class="rightPart">
                <fmt:formatDate value="${requestScope.chargementTour.tourDate}" pattern="${datehour_pattern_long}"/>
            </div>
            <br class="spacer"/>
            
            <div class="leftPart">
                <label for="delivery"><fmt:message key="tour.delivery"/> :</label>
            </div>
            <div class="rightPart">
                <fmt:formatDate value="${requestScope.tour.dateLivraison}" pattern="${date_pattern_long}"/>
            </div>
            <br class="spacer"/>
            
            <div class="leftPart">
                <label for="status"><fmt:message key="tour.status"/> :</label>
            </div>
            <div class="rightPart">
                <s:label categorie="CHA" id="${requestScope.chargementTour.tourStatut}" var="label"/>
                <fmt:message key="loading.statut.${pageScope.label}"/>
            </div>
            <br class="spacer bigspace"/>
            
            <html:form action="/appli/loading/tour/save" method="POST" styleId="tourSave">
                <display:table name="requestScope.produits" id="p" requestURI="/appli/loading/tour/view.do" sort="list" defaultsort="1" defaultorder="ascending" pagesize="25">
                    <display:column titleKey="product.name">
                        ${pageScope.p.libelle}
                    </display:column>
                    <display:column titleKey="product.quantity.commanded" class="colright">
                        ${pageScope.p.quantiteCommandee}
                    </display:column>
                    <display:column titleKey="product.quantity.charged" class="colright">
                        ${pageScope.p.infoChargement.quantite}
                    </display:column>
                    <display:column titleKey="product.comment">
                        ${pageScope.p.commentaire}
                    </display:column>
                    <display:column titleKey="product.order.comment">
                        ${pageScope.p.commande.commentaire}
                    </display:column>
                    <display:column titleKey="product.available" class="action">
                        <html:hidden property="produitsTopiaId" value="${pageScope.p.topiaId}"/>
                        <html:select property="produitsStatut" value="${pageScope.p.disponible}" styleClass="fixed">
                            <html:option value="false" key="common.no"/>
                            <html:option value="true" key="common.yes"/>
                        </html:select>
                    </display:column>
                </display:table>
                <s:authorization expression="com.cybelia.sandra.entities.LigneProduit#*" actions="UPDATE">
                    <c:if test="${requestScope.chargementTour.tourStatut < 3}">
                        <div class="align-right">
                            <html:hidden property="produitsAllStatut" value="false"/>
                            <html:hidden property="camionTopiaId"/>
                            <html:hidden property="tourTopiaId"/>
                            <html:hidden property="usineTopiaId"/>
                            <html:hidden property="startingDateAsLong"/>
                            <html:hidden property="tourDateAsLong"/>
                            <html:hidden property="tourStatut"/>
                            <html:submit styleClass="save" property="save"><fmt:message key="common.save"/></html:submit>
                            <html:submit styleClass="save" property="save" onclick="document.forms['tourSave'].produitsAllStatut.value='true'"><fmt:message key="loading.tour.save.all.available"/></html:submit>
                        </div>
                    </c:if>
                </s:authorization>
            </html:form>
        </div>
        
        <%@include file="../common/footer.jsp" %>
    </body>
    
</html>
