<%@include file="../common/taglibs.jsp" %>
<s:principal name="com.cybelia.sandra.entities.Societe, com.cybelia.sandra.entities.Usine"/>

<html>
    <head>
        <link rel="stylesheet" href="<c:url value="/css/loading.css"/>" type="text/css">
        <link rel="icon" type="image/png" href="<c:url value="/images/icons/lorry.png"/>">
        
        <script type="text/javascript">
            function reload() {
                document.getElementById('reload').submit();
            }
            
            setInterval("reload()", 2 * 60 * 1000); //2min
        </script>
    </head>
    
    <body onload="document.getElementById('tableLoading').style.display=''">
        
        <html:form action="/appli/loading/view" method="POST" styleId="reload" style="display:none">
            <html:hidden property="usineTopiaId" value="${requestScope.chargement.usineTopiaId}"/>
            <html:hidden property="startingDateAsLong" value="${requestScope.chargement.model.startingDate.time}"/>
        </html:form>
                        
        <div id="header">
            <div class="container">
                <div class="left title">
                    <html:link action="/appli/index">
                        <img src="<c:url value="/images/logo.gif"/>" alt="<fmt:message key="common.title"/>"/>
                    </html:link>
                </div>
                
                <%if (request.getRemoteUser() != null) {%>
                <div class="right">
                    <div>
                        <s:label categorie="MSG" id="msg0"/>
                    </div>
                    <div>
                        <%=request.getRemoteUser()%>
                        <html:link action="/appli/logout.do" styleClass="quit"><fmt:message key="common.logout"/></html:link>
                    </div>
                    <div>
                        <html:form action="/appli/loading/view" method="POST" styleId="selectUsine" styleClass="inline">
                            <html:select property="usineTopiaId" styleId="usine" onchange="document.forms['selectUsine'].submit()">
                                <html:option value="" key="usine.no"/>
                                <html:optionsCollection name="applicationSession" property="namingUsines" label="value" value="key"/>
                            </html:select>
                            <html:hidden property="startingDateAsLong" value="${requestScope.chargement.model.startingDate.time}"/>
                        </html:form>
                        <html:form action="/appli/loading/config/selectUsine" method="POST" styleId="selectUsine" styleClass="inline">
                            <html:hidden property="usineTopiaId" value="${requestScope.chargement.usineTopiaId}"/>
                            <html:hidden property="startingDateAsLong" value="${requestScope.chargement.model.startingDate.time}"/>
                            <html:submit styleClass="button go"><fmt:message key="loading.config.action"/></html:submit>
                        </html:form>
                    </div>
                </div>
                <div class="subtitle">
                    <fmt:message key="loading.title"/>
                </div>
                <% }%>
                <div class="clear">&nbsp;</div>
            </div>
            
            <fmt:message key="common.date.pattern.extra.long" var="date_pattern_extra_long" scope="request"/>
            <fmt:message key="common.date.pattern.longer" var="date_pattern_longer" scope="request"/>
            <c:set var="nbPixelPerHour" value="${requestScope.chargement.model.nbPixelPerHour}"/>
            <c:set var="nbColumns" value="${requestScope.chargement.config.nombreHeures}"/>
            
            <table id="tableLoadingHeader" cellspacing="0">
                <thead>
                    <!-- days header -->
                    <c:set var="days" value="${requestScope.chargement.model.days}"/>
                    <tr>
                        <th class="colright">&nbsp;</th>
                        <c:forEach items="${days}" var="day" varStatus="statut">
                            <c:set var="firstHourOfDay" value=""/>
                            <c:if test="${not statut.first}">
                                <c:set var="firstHourOfDay" value="firstHourOfDay"/>
                            </c:if>
                            
                            <th colspan="${pageScope.day.nbHours}" class="colcenter simpleBorder day_${pageScope.statut.index % 2 == 0} ${firstHourOfDay}">
                                <c:choose>
                                    <c:when test="${pageScope.day.nbHours < 2}">
                                        <fmt:formatDate value="${pageScope.day.day}" pattern="${date_pattern_short}"/>
                                    </c:when>
                                    <c:when test="${pageScope.day.nbHours < 3}">
                                        <fmt:formatDate value="${pageScope.day.day}" pattern="${date_pattern_long}"/>
                                    </c:when>
                                    <c:when test="${pageScope.day.nbHours < 6}">
                                        <fmt:formatDate value="${pageScope.day.day}" pattern="${date_pattern_longer}"/>
                                    </c:when>
                                    <c:otherwise>
                                        <fmt:formatDate value="${pageScope.day.day}" pattern="${date_pattern_extra_long}"/>
                                    </c:otherwise>
                                </c:choose>
                            </th>
                        </c:forEach>
                        <th class="colleft">&nbsp;</th>
                    </tr>
                    
                    <!-- hours header -->
                    <tr>
                        <th class="colright">&nbsp;</th>
                        <c:forEach items="${requestScope.chargement.model.hours}" var="column" varStatus="statut">
                            <c:set var="firstHourOfDay" value=""/>
                            <c:if test="${pageScope.column.firstHour and not statut.first}">
                                <c:set var="firstHourOfDay" value="firstHourOfDay"/>
                            </c:if>
                            
                            <td class="colleft ${firstHourOfDay}" style="width:${pageScope.nbPixelPerHour}px;">
                                <c:if test="${not empty pageScope.column.currentDate}">
                                    <div class="currentDate" style="margin-left:${requestScope.chargement.model.currentDateNbPixelForMinute}px;">&nbsp;</div>
                                </c:if>
                                ${pageScope.column.hour}H
                            </td>
                        </c:forEach>
                        <th class="colleft">&nbsp;</th>
                    </tr>
                </thead>
            </table>
        </div>
        
        
        <div id="footer">
            <c:forEach items="${requestScope.chargement.status}" var="statut">
                <s:label categorie="CHA" id="${pageScope.statut.code}" var="label"/>
                <c:set var="color" value="${pageScope.statut.color}"/>
                <div class="left decal">
                    <span class="legendStatut" style="background-color:rgb(${pageScope.color.red},${pageScope.color.green},${pageScope.color.blue});">&nbsp;</span>&nbsp;
                    <fmt:message key="loading.statut.${pageScope.label}"/>
                </div>
            </c:forEach>
            
            <div class="right">
                <html:form action="/appli/loading/view" method="POST">
                    <html:hidden property="usineTopiaId"/>
                    <html:hidden property="startingDateAsLong" value="${requestScope.chargement.nextStartingDateAsLong}"/>
                    <fmt:message key="loading.next.action.title" var="title">
                        <fmt:param><fmt:formatDate value="${requestScope.chargement.nextStartingDate}" pattern="${datehour_pattern_long}"/></fmt:param>
                        <fmt:param><fmt:formatDate value="${requestScope.chargement.nextEndingDate}" pattern="${datehour_pattern_long}"/></fmt:param>
                    </fmt:message>
                    <html:submit styleClass="button next" title="${pageScope.title}">
                        <fmt:message key="loading.next.action"/>
                    </html:submit>
                </html:form>
            </div>
            <div class="right decal">
                <html:form action="/appli/loading/view" method="POST">
                    <html:hidden property="usineTopiaId"/>
                    <html:hidden property="startingDateAsLong" value="${requestScope.chargement.previousStartingDateAsLong}"/>
                    <fmt:message key="loading.previous.action.title" var="title">
                        <fmt:param><fmt:formatDate value="${requestScope.chargement.previousStartingDate}" pattern="${datehour_pattern_long}"/></fmt:param>
                        <fmt:param><fmt:formatDate value="${requestScope.chargement.previousEndingDate}" pattern="${datehour_pattern_long}"/></fmt:param>
                    </fmt:message>
                    <html:submit styleClass="button previous" title="${pageScope.title}">
                        <fmt:message key="loading.previous.action"/>
                    </html:submit>
                </html:form>
            </div>
            <div class="right decal">
                <fmt:formatDate value="${requestScope.chargement.model.currentDate}" pattern="${datehour_pattern_long}"/>
                <html:form action="/appli/loading/view" method="POST" styleClass="inline">
                    <html:hidden property="usineTopiaId"/>
                    <html:hidden property="startingDateAsLong" value="${requestScope.chargement.model.currentDate.time}"/>
                    <html:submit styleClass="button go">
                        <fmt:message key="loading.go.action"/>
                    </html:submit>
                </html:form>
            </div>
            <div class="clear">&nbsp;</div>
        </div>
        
        <div id="content">
            <table id="tableLoading" cellspacing="0" style="display:none">
                <tbody>
                    <c:forEach items="${requestScope.chargement.model.rows}" var="ligne">
                        <tr>
                            <th class="colright"><s:naming topiaId="${ligne.key}"/></th>
                            <c:forEach items="${pageScope.ligne.value}" var="column" varStatus="status">
                                <c:url value="/appli/loading/drawCellule.do" var="cellURL">
                                    <c:param name="nbHours" value="${pageScope.nbColumns}"/>
                                    <c:param name="numero" value="${pageScope.column.chargement.tourNumero}"/>
                                    <c:param name="startingDate" value="${pageScope.column.chargement.startingDateAsLong}"/>
                                    <c:param name="delay" value="${pageScope.column.chargement.delay}"/>
                                    <c:param name="statut" value="${pageScope.column.chargement.statut.code}"/>
                                </c:url>
                                
                                <c:set var="firstHourOfDay" value=""/>
                                <c:if test="${pageScope.column.firstHour and not status.first}">
                                    <c:set var="firstHourOfDay" value="firstHourOfDay"/>
                                </c:if>
                                
                                <td class="loadingCell ${firstHourOfDay}" style="width:${pageScope.nbPixelPerHour}px;" >
                                    <c:choose>
                                        <c:when test="${not empty pageScope.column.chargement}">
                                            <div>
                                                <html:form action="/appli/loading/tour/view.do" method="POST" style="margin-left:${pageScope.column.chargement.nbPixelForMinute}px;">
                                                    <html:hidden property="camionTopiaId" value="${ligne.key}"/>
                                                    <html:hidden property="tourTopiaId" value="${pageScope.column.chargement.tourId}"/>
                                                    <html:hidden property="usineTopiaId" value="${requestScope.chargement.usineTopiaId}"/>
                                                    <html:hidden property="startingDateAsLong" value="${requestScope.chargement.model.startingDate.time}"/>
                                                    <html:hidden property="tourDateAsLong" value="${pageScope.column.chargement.startingDate.time}"/>
                                                    <html:hidden property="tourStatut" value="${pageScope.column.chargement.statut.code}"/>
                                                    
                                                    <html:link href="#" onclick="this.parentNode.submit();">
                                                        <img src="${pageScope.cellURL}">
                                                    </html:link>
                                                </html:form>
                                            </div>
                                        </c:when>
                                        <c:otherwise>
                                            &nbsp;
                                        </c:otherwise>
                                    </c:choose>
                                </td>
                            </c:forEach>
                            <th class="colleft"><s:naming topiaId="${ligne.key}"/></th>
                        </tr>
                    </c:forEach>
                </tbody>
            </table>
        </div>
    </body>
</html>