<%@include file="../common/taglibs.jsp" %>
<s:principal name="com.cybelia.sandra.entities.Societe, com.cybelia.sandra.entities.Usine"/>

<html>
    <body>
        <%@include file="../common/header.jsp" %>

        <div class="content">
            <div class="subtitle"><fmt:message key="loading.config.title"/></div>

            <c:if test="${not empty requestScope.chargementConfig.usineTopiaId}">
                <div class="align-right space">
                    <html:form action="/appli/loading/view" method="POST">
                        <html:hidden property="usineTopiaId" value="${requestScope.chargementConfig.usineTopiaId}"/>
                        <html:hidden property="startingDateAsLong" value="${requestScope.chargementConfig.startingDateAsLong}"/>
                        <html:submit styleClass="button go"><fmt:message key="loading.view.title"/></html:submit>
                    </html:form>
                </div>
                <br class="spacer"/>
            </c:if>

            <html:form action="/appli/loading/config/selectUsine" method="POST" styleId="selectUsine">
                <div class="leftPart">
                    <label for="usine"><fmt:message key="loading.usine.name"/><span class="required">*</span> :</label>
                </div>
                <div class="rightPart">
                    <html:select property="usineTopiaId" styleId="usine" onchange="document.forms['selectUsine'].submit()">
                        <html:option value="" key="usine.no"/>
                        <html:optionsCollection name="applicationSession" property="namingUsines" label="value" value="key"/>
                    </html:select>
                </div>
                <br class="spacer"/>
            </html:form>

            <c:if test="${not empty requestScope.chargementConfig.usineTopiaId}">
            <html:form action="/appli/loading/config/save" method="POST">
            <html:hidden property="topiaId"/>
            <html:hidden property="usineTopiaId"/>

            <div class="leftPart">
                <label for="nombreHeures"><fmt:message key="loading.config.nombreHeures"/><span class="required">*</span>  :</label>
            </div>
            <div class="rightPart" >
                <html:text property="nombreHeures" styleId="nombreHeures" size="5" maxlength="5" styleClass="fixed"/>
            </div>
            <br class="spacer"/>

            <div class="leftPart">
                <label for="positionHeureActuelle"><fmt:message key="loading.config.positionHeureCourante"/><span class="required">*</span>  :</label>
            </div>
            <div class="rightPart">
                <html:text property="positionHeureActuelle" styleId="positionHeureActuelle" size="5" maxlength="5" styleClass="fixed"/>
            </div>
            <br class="spacer"/>

            <div class="leftPart">
                <label for="tempFixeParTournee"><fmt:message key="loading.config.tempFixeParTournee"/><span class="required">*</span>  :</label>
            </div>
            <div class="rightPart">
                <html:text property="tempFixeParTournee" styleId="tempFixeParTournee" size="5" maxlength="5" styleClass="fixed"/>
            </div>
            <br class="spacer"/>


            <div class="leftPart">
                <label for="tempFixeParLigneProduit"><fmt:message key="loading.config.tempFixeParLigneProduit"/><span class="required">*</span>  :</label>
            </div>
            <div class="rightPart">
                <html:text property="tempFixeParLigneProduit" styleId="tempFixeParLigneProduit" size="5" maxlength="5" styleClass="fixed"/>
            </div>
            <br class="spacer"/>

            <div class="leftPart">
                <label for="tempVariableParQuantite"><fmt:message key="loading.config.tempVariableParQuantite"/><span class="required">*</span>  :</label>
            </div>
            <div class="rightPart">
                <html:text property="tempVariableParQuantite" styleId="tempVariableParQuantite" size="5" maxlength="5" styleClass="fixed"/>
            </div>
            <br class="spacer"/>

            <s:authorization expression="com.cybelia.sandra.entities.ChargementUsineConfig#*" actions="UPDATE">
              <div class="groupbutton">
                  <html:submit styleClass="save" property="save"><fmt:message key="common.save"/></html:submit>
              </div>
            </s:authorization>
            <br class="bigspace"/>
            <div class="clear">&nbsp;</div>
            </html:form>
            </c:if>
        </div>
        <%@include file="../common/footer.jsp" %>
    </body>

</html>
